/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernelcontrolcenter;

import java.util.Objects;
import javax.inject.Inject;
import org.opentcs.common.ClientConnectionMode;
import org.opentcs.common.KernelClientApplication;
import org.opentcs.common.PortalManager;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.kernelcontrolcenter.KernelControlCenter;
import org.opentcs.kernelcontrolcenter.exchange.KernelEventFetcher;
import org.opentcs.kernelcontrolcenter.util.KernelControlCenterConfiguration;
import org.opentcs.util.event.EventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KernelControlCenterApplication
implements KernelClientApplication {
    private static final Logger LOG = LoggerFactory.getLogger(KernelControlCenterApplication.class);
    private final KernelEventFetcher eventFetcher;
    private final KernelControlCenter kernelControlCenter;
    private final PortalManager portalManager;
    private final EventBus eventBus;
    private final KernelControlCenterConfiguration configuration;
    private ConnectionState connectionState = ConnectionState.OFFLINE;
    private boolean initialized;

    @Inject
    public KernelControlCenterApplication(KernelEventFetcher eventFetcher, KernelControlCenter kernelControlCenter, PortalManager portalManager, @ApplicationEventBus EventBus eventBus, KernelControlCenterConfiguration configuration) {
        this.eventFetcher = Objects.requireNonNull(eventFetcher, "eventHub");
        this.kernelControlCenter = Objects.requireNonNull(kernelControlCenter, "kernelControlCenter");
        this.portalManager = Objects.requireNonNull(portalManager, "portalManager");
        this.eventBus = Objects.requireNonNull(eventBus, "eventBus");
        this.configuration = Objects.requireNonNull(configuration, "configuration");
    }

    public void initialize() {
        if (this.isInitialized()) {
            return;
        }
        this.kernelControlCenter.initialize();
        this.eventFetcher.initialize();
        this.online(this.configuration.connectAutomaticallyOnStartup());
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void terminate() {
        if (!this.isInitialized()) {
            return;
        }
        this.offline();
        this.eventFetcher.terminate();
        this.kernelControlCenter.terminate();
        this.initialized = false;
    }

    public void online(boolean autoConnect) {
        if (this.isOnline() || this.isConnecting()) {
            return;
        }
        this.connectionState = ConnectionState.CONNECTING;
        if (this.portalManager.connect(this.toConnectionMode(autoConnect))) {
            LOG.info("Switching application state to online...");
            this.connectionState = ConnectionState.ONLINE;
            this.eventBus.onEvent((Object)ClientConnectionMode.ONLINE);
        } else {
            this.connectionState = ConnectionState.OFFLINE;
        }
    }

    public void offline() {
        if (!this.isOnline() && !this.isConnecting()) {
            return;
        }
        this.portalManager.disconnect();
        LOG.info("Switching application state to offline...");
        this.connectionState = ConnectionState.OFFLINE;
        this.eventBus.onEvent((Object)ClientConnectionMode.OFFLINE);
    }

    public boolean isOnline() {
        return this.connectionState == ConnectionState.ONLINE;
    }

    public boolean isConnecting() {
        return this.connectionState == ConnectionState.CONNECTING;
    }

    private PortalManager.ConnectionMode toConnectionMode(boolean autoConnect) {
        return autoConnect ? PortalManager.ConnectionMode.AUTO : PortalManager.ConnectionMode.MANUAL;
    }

    private static enum ConnectionState {
        OFFLINE,
        CONNECTING,
        ONLINE;

    }
}

