/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernelcontrolcenter.exchange;

import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import javax.inject.Inject;
import javax.swing.JOptionPane;
import org.opentcs.common.KernelClientApplication;
import org.opentcs.common.PortalManager;
import org.opentcs.components.kernel.services.ServiceUnavailableException;
import org.opentcs.util.CallWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServiceCallWrapper
implements CallWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultServiceCallWrapper.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("i18n/org/opentcs/kernelcontrolcenter/Bundle");
    private final KernelClientApplication application;
    private final PortalManager portalManager;

    @Inject
    public DefaultServiceCallWrapper(KernelClientApplication application, PortalManager portalManager) {
        this.application = Objects.requireNonNull(application, "application");
        this.portalManager = Objects.requireNonNull(portalManager, "portalManager");
    }

    public <R> R call(Callable<R> callable) throws Exception {
        boolean retry = true;
        Exception failureReason = null;
        while (retry) {
            try {
                return callable.call();
            }
            catch (Exception ex) {
                LOG.warn("Failed to call remote service method: {}", callable, (Object)ex);
                failureReason = ex;
                if (ex instanceof ServiceUnavailableException) {
                    this.portalManager.disconnect();
                    retry = this.showRetryDialog();
                    continue;
                }
                retry = false;
            }
        }
        throw failureReason;
    }

    public void call(Runnable runnable) throws Exception {
        Callable<Object> callable = Executors.callable(runnable);
        this.call(callable);
    }

    private boolean showRetryDialog() {
        int dialogSelection = JOptionPane.showConfirmDialog(null, BUNDLE.getString("defaultServiceCallWrapper.optionPane_retryConfirmation.message"), BUNDLE.getString("defaultServiceCallWrapper.optionPane_retryConfirmation.title"), 1);
        switch (dialogSelection) {
            case 0: {
                return this.portalManager.connect(PortalManager.ConnectionMode.RECONNECT);
            }
            case 1: {
                return false;
            }
            case 2: {
                this.application.offline();
                return false;
            }
            case -1: {
                return false;
            }
        }
        return false;
    }
}

