/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernelcontrolcenter.peripherals;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import org.opentcs.access.KernelServicePortal;
import org.opentcs.components.Lifecycle;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.customizations.ServiceCallWrapper;
import org.opentcs.data.model.Location;
import org.opentcs.data.model.TCSResourceReference;
import org.opentcs.drivers.peripherals.PeripheralProcessModel;
import org.opentcs.drivers.peripherals.management.PeripheralAttachmentEvent;
import org.opentcs.drivers.peripherals.management.PeripheralAttachmentInformation;
import org.opentcs.drivers.peripherals.management.PeripheralProcessModelEvent;
import org.opentcs.kernelcontrolcenter.peripherals.LocalPeripheralEntry;
import org.opentcs.util.CallWrapper;
import org.opentcs.util.event.EventHandler;
import org.opentcs.util.event.EventSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalPeripheralEntryPool
implements EventHandler,
Lifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(LocalPeripheralEntryPool.class);
    private final KernelServicePortal servicePortal;
    private final CallWrapper callWrapper;
    private final EventSource eventSource;
    private final Map<TCSResourceReference<Location>, LocalPeripheralEntry> entries = new HashMap<TCSResourceReference<Location>, LocalPeripheralEntry>();
    private boolean initialized;

    @Inject
    public LocalPeripheralEntryPool(KernelServicePortal servicePortal, @ServiceCallWrapper CallWrapper callWrapper, @ApplicationEventBus EventSource eventSource) {
        this.servicePortal = Objects.requireNonNull(servicePortal, "servicePortal");
        this.callWrapper = Objects.requireNonNull(callWrapper, "callWrapper");
        this.eventSource = Objects.requireNonNull(eventSource, "eventSource");
    }

    public void initialize() {
        if (this.isInitialized()) {
            return;
        }
        try {
            this.initializeEntryMap();
            LOG.debug("Initialized peripheral entry pool: {}", this.entries);
        }
        catch (Exception e) {
            LOG.warn("Error initializing peripheral entry pool.", (Throwable)e);
            this.entries.clear();
            return;
        }
        this.eventSource.subscribe((EventHandler)this);
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void terminate() {
        if (!this.isInitialized()) {
            return;
        }
        this.eventSource.unsubscribe((EventHandler)this);
        this.entries.clear();
        this.initialized = false;
    }

    public void onEvent(Object event) {
        if (event instanceof PeripheralProcessModelEvent) {
            this.onPeripheralProcessModelEvent((PeripheralProcessModelEvent)event);
        } else if (event instanceof PeripheralAttachmentEvent) {
            this.onPeripheralAttachmentEvent((PeripheralAttachmentEvent)event);
        }
    }

    public Map<TCSResourceReference<Location>, LocalPeripheralEntry> getEntries() {
        return this.entries;
    }

    private void initializeEntryMap() throws Exception {
        Set locations = (Set)this.callWrapper.call(() -> this.servicePortal.getPlantModelService().fetchObjects(Location.class));
        for (Location location : locations) {
            PeripheralAttachmentInformation ai = (PeripheralAttachmentInformation)this.callWrapper.call(() -> this.servicePortal.getPeripheralService().fetchAttachmentInformation(location.getReference()));
            PeripheralProcessModel processModel = (PeripheralProcessModel)this.callWrapper.call(() -> this.servicePortal.getPeripheralService().fetchProcessModel(location.getReference()));
            this.entries.put((TCSResourceReference<Location>)location.getReference(), new LocalPeripheralEntry((TCSResourceReference<Location>)location.getReference(), ai.getAttachedCommAdapter(), processModel));
        }
    }

    private void onPeripheralProcessModelEvent(PeripheralProcessModelEvent event) {
        if (!this.entries.containsKey(event.getLocation())) {
            LOG.warn("Received an event for an unknown location: {}", (Object)event.getLocation().getName());
            return;
        }
        this.entries.get(event.getLocation()).setProcessModel(event.getProcessModel());
    }

    private void onPeripheralAttachmentEvent(PeripheralAttachmentEvent event) {
        if (!this.entries.containsKey(event.getLocation())) {
            LOG.warn("Received an event for an unknown location: {}", (Object)event.getLocation().getName());
            return;
        }
        this.entries.get(event.getLocation()).setAttachedCommAdapter(event.getAttachmentInformation().getAttachedCommAdapter());
    }
}

