/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernelcontrolcenter.vehicles;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.Set;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import org.opentcs.access.KernelServicePortal;
import org.opentcs.components.Lifecycle;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.customizations.ServiceCallWrapper;
import org.opentcs.data.model.Vehicle;
import org.opentcs.data.notification.UserNotification;
import org.opentcs.drivers.vehicle.VehicleProcessModel;
import org.opentcs.drivers.vehicle.management.AttachmentEvent;
import org.opentcs.drivers.vehicle.management.AttachmentInformation;
import org.opentcs.drivers.vehicle.management.ProcessModelEvent;
import org.opentcs.drivers.vehicle.management.VehicleCommAdapterPanel;
import org.opentcs.drivers.vehicle.management.VehicleCommAdapterPanelFactory;
import org.opentcs.kernelcontrolcenter.vehicles.LocalVehicleEntry;
import org.opentcs.kernelcontrolcenter.vehicles.LogTableModel;
import org.opentcs.util.CallWrapper;
import org.opentcs.util.event.EventHandler;
import org.opentcs.util.event.EventSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailPanel
extends JPanel
implements EventHandler,
Lifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(DetailPanel.class);
    private static final String DEFAULT_BORDER_TITLE = "";
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());
    private final List<VehicleCommAdapterPanel> customPanelList = new LinkedList<VehicleCommAdapterPanel>();
    private final Set<VehicleCommAdapterPanelFactory> panelFactories;
    private final LogTableModel loggingTableModel = new LogTableModel();
    private final EventSource eventSource;
    private final KernelServicePortal servicePortal;
    private final CallWrapper callWrapper;
    private LocalVehicleEntry vehicleEntry;
    private AttachmentInformation attachmentInfo;
    private boolean initialized;
    private JPanel adapterStatusPanel;
    private JCheckBox chkBoxEnable;
    private JMenuItem clearMenuItem;
    private JLabel curPosLbl;
    private JTextField curPosTxt;
    private JLabel curStateLbl;
    private JTextField curStateTxt;
    private JCheckBoxMenuItem errorsCheckBoxMenuItem;
    private JCheckBoxMenuItem everythingCheckBoxMenuItem;
    private JLabel fillingLbl;
    private JMenu filterMenu;
    private JPanel headPanel;
    private JPanel logPanel;
    private JPopupMenu logPopupMenu;
    private JScrollPane logTableScrollPane;
    private JScrollPane logTextScrollPane;
    private JTable loggingTable;
    private JPopupMenu loggingTablePopupMenu;
    private JTextArea loggingTextArea;
    private JLabel logoLbl;
    private JPanel logoPanel;
    private JLabel noVehicleLabel;
    private JPanel noVehiclePanel;
    private JPanel overviewTabPanel;
    private JPanel statusFiguresPanel;
    private JPanel statusPanel;
    private JTabbedPane tabbedPane;
    private JCheckBoxMenuItem warningsCheckBoxMenuItem;

    @Inject
    public DetailPanel(KernelServicePortal servicePortal, @ServiceCallWrapper CallWrapper callWrapper, @ApplicationEventBus EventSource eventSource, Set<VehicleCommAdapterPanelFactory> panelFactories) {
        this.servicePortal = Objects.requireNonNull(servicePortal, "servicePortal");
        this.callWrapper = Objects.requireNonNull(callWrapper, "callWrapper");
        this.eventSource = Objects.requireNonNull(eventSource, "eventSource");
        this.panelFactories = Objects.requireNonNull(panelFactories, "panelFactories");
        this.initComponents();
        this.loggingTable.setModel(this.loggingTableModel);
        this.loggingTable.getColumnModel().getColumn(0).setPreferredWidth(40);
        this.loggingTable.getColumnModel().getColumn(1).setPreferredWidth(110);
        this.loggingTable.getSelectionModel().addListSelectionListener(new RowListener());
        this.detachFromVehicle();
    }

    public void initialize() {
        if (this.isInitialized()) {
            return;
        }
        for (VehicleCommAdapterPanelFactory fatory : this.panelFactories) {
            fatory.initialize();
        }
        this.eventSource.subscribe((EventHandler)this);
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void terminate() {
        if (!this.isInitialized()) {
            return;
        }
        this.detachFromVehicle();
        this.eventSource.unsubscribe((EventHandler)this);
        for (VehicleCommAdapterPanelFactory fatory : this.panelFactories) {
            fatory.terminate();
        }
        this.initialized = false;
    }

    public void onEvent(Object e) {
        AttachmentEvent event;
        if (this.vehicleEntry == null) {
            return;
        }
        if (e instanceof AttachmentEvent) {
            event = (AttachmentEvent)e;
            if (Objects.equals(this.vehicleEntry.getVehicleName(), event.getVehicleName())) {
                this.updateFromVehicleEntry(event);
            }
        }
        if (e instanceof ProcessModelEvent) {
            event = (ProcessModelEvent)e;
            if (Objects.equals(this.vehicleEntry.getVehicleName(), event.getUpdatedProcessModel().getVehicleName())) {
                this.updateFromVehicleProcessModel((ProcessModelEvent)event);
                this.customPanelList.forEach(arg_0 -> DetailPanel.lambda$onEvent$0((ProcessModelEvent)event, arg_0));
            }
        }
    }

    void attachToVehicle(LocalVehicleEntry newVehicleEntry) {
        Objects.requireNonNull(newVehicleEntry, "newVehicleEntry");
        if (this.vehicleEntry != newVehicleEntry) {
            this.detachFromVehicle();
        }
        this.vehicleEntry = newVehicleEntry;
        this.setBorderTitle(this.vehicleEntry.getVehicleName());
        this.removeAll();
        this.add(this.tabbedPane);
        this.loggingTableModel.clear();
        for (UserNotification notification : this.vehicleEntry.getProcessModel().getNotifications()) {
            this.loggingTableModel.addRow(notification);
        }
        this.initVehicleEntryAttributes();
        this.validate();
        this.tabbedPane.setSelectedIndex(0);
    }

    private void detachFromVehicle() {
        if (this.vehicleEntry != null) {
            this.removeCustomPanels();
            if (this.attachmentInfo != null) {
                this.attachmentInfo = null;
            }
            this.customPanelList.clear();
            this.vehicleEntry = null;
        }
        this.loggingTableModel.clear();
        this.setBorderTitle(DEFAULT_BORDER_TITLE);
        this.removeAll();
        this.add(this.noVehiclePanel);
        this.validate();
    }

    private void initVehicleEntryAttributes() {
        this.updateCommAdapter(this.vehicleEntry.getAttachmentInformation());
        this.updateCommAdapterEnabled(this.vehicleEntry.getProcessModel().isCommAdapterEnabled());
        this.updateVehiclePosition(this.vehicleEntry.getProcessModel().getVehiclePosition());
        this.updateVehicleState(this.vehicleEntry.getProcessModel().getVehicleState());
    }

    private void updateFromVehicleEntry(AttachmentEvent evt) {
        this.updateCommAdapter(evt.getUpdatedAttachmentInformation());
    }

    private void updateFromVehicleProcessModel(ProcessModelEvent evt) {
        if (Objects.equals(evt.getAttributeChanged(), VehicleProcessModel.Attribute.COMM_ADAPTER_ENABLED.name())) {
            this.updateCommAdapterEnabled(evt.getUpdatedProcessModel().isCommAdapterEnabled());
        } else if (Objects.equals(evt.getAttributeChanged(), VehicleProcessModel.Attribute.POSITION.name())) {
            this.updateVehiclePosition(evt.getUpdatedProcessModel().getVehiclePosition());
        } else if (Objects.equals(evt.getAttributeChanged(), VehicleProcessModel.Attribute.STATE.name())) {
            this.updateVehicleState(evt.getUpdatedProcessModel().getVehicleState());
        } else if (Objects.equals(evt.getAttributeChanged(), VehicleProcessModel.Attribute.USER_NOTIFICATION.name())) {
            this.updateUserNotification(evt.getUpdatedProcessModel().getNotifications());
        }
    }

    private void updateCommAdapter(AttachmentInformation newAttachmentInfo) {
        SwingUtilities.invokeLater(() -> {
            if (this.attachmentInfo != null) {
                this.removeCustomPanels();
                this.customPanelList.clear();
            }
            this.attachmentInfo = newAttachmentInfo;
            if (this.attachmentInfo != null) {
                this.updateCustomPanels();
            }
            this.chkBoxEnable.setEnabled(this.attachmentInfo != null);
            this.chkBoxEnable.setSelected(this.attachmentInfo != null && this.vehicleEntry.getProcessModel().isCommAdapterEnabled());
        });
    }

    private void updateCommAdapterEnabled(boolean enabled) {
        SwingUtilities.invokeLater(() -> this.chkBoxEnable.setSelected(enabled));
    }

    private void updateVehiclePosition(String position) {
        SwingUtilities.invokeLater(() -> this.curPosTxt.setText(position));
    }

    private void updateVehicleState(Vehicle.State state) {
        SwingUtilities.invokeLater(() -> this.curStateTxt.setText(state.toString()));
    }

    private void updateUserNotification(Queue<UserNotification> notifications) {
        SwingUtilities.invokeLater(() -> {
            this.loggingTableModel.clear();
            notifications.forEach(notification -> this.loggingTableModel.addRow((UserNotification)notification));
        });
    }

    private void updateCustomPanels() {
        for (VehicleCommAdapterPanel curPanel : this.customPanelList) {
            LOG.debug("Removing {} from tabbedPane.", (Object)curPanel);
            this.tabbedPane.remove((Component)curPanel);
        }
        this.customPanelList.clear();
        if (this.attachmentInfo != null) {
            for (VehicleCommAdapterPanelFactory panelFactory : this.panelFactories) {
                this.customPanelList.addAll(panelFactory.getPanelsFor(this.vehicleEntry.getAttachedCommAdapterDescription(), this.vehicleEntry.getAttachmentInformation().getVehicleReference(), this.vehicleEntry.getProcessModel()));
                for (VehicleCommAdapterPanel curPanel : this.customPanelList) {
                    LOG.debug("Adding {} with title {} to tabbedPane.", (Object)curPanel, (Object)curPanel.getTitle());
                    this.tabbedPane.addTab(curPanel.getTitle(), (Component)curPanel);
                }
            }
        }
    }

    private void removeCustomPanels() {
        LOG.debug("Setting selected component of tabbedPane to overviewTabPanel.");
        this.tabbedPane.setSelectedComponent(this.overviewTabPanel);
        for (VehicleCommAdapterPanel panel : this.customPanelList) {
            LOG.debug("Removing {} from tabbedPane.", (Object)panel);
            this.tabbedPane.remove((Component)panel);
        }
    }

    private void setBorderTitle(String newTitle) {
        Objects.requireNonNull(newTitle, "newTitle");
        ((TitledBorder)this.getBorder()).setTitle(newTitle);
        this.repaint();
    }

    private void outputLogNotification(int row) {
        UserNotification message = this.loggingTableModel.getRow(row);
        String timestamp = DATE_FORMAT.format(message.getTimestamp());
        String output = timestamp + " (" + message.getLevel() + "):\n" + message.getText();
        this.loggingTextArea.setText(output);
    }

    private void initComponents() {
        this.logPopupMenu = new JPopupMenu();
        this.clearMenuItem = new JMenuItem();
        this.loggingTablePopupMenu = new JPopupMenu();
        this.filterMenu = new JMenu();
        this.everythingCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.warningsCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.errorsCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.noVehiclePanel = new JPanel();
        this.noVehicleLabel = new JLabel();
        this.tabbedPane = new JTabbedPane();
        this.overviewTabPanel = new JPanel();
        this.headPanel = new JPanel();
        this.statusPanel = new JPanel();
        this.adapterStatusPanel = new JPanel();
        this.chkBoxEnable = new JCheckBox();
        this.statusFiguresPanel = new JPanel();
        this.curPosLbl = new JLabel();
        this.curPosTxt = new JTextField();
        this.curStateLbl = new JLabel();
        this.curStateTxt = new JTextField();
        this.fillingLbl = new JLabel();
        this.logoPanel = new JPanel();
        this.logoLbl = new JLabel();
        this.logPanel = new JPanel();
        this.logTableScrollPane = new JScrollPane();
        this.loggingTable = new JTable();
        this.logTextScrollPane = new JScrollPane();
        this.loggingTextArea = new JTextArea();
        ResourceBundle bundle = ResourceBundle.getBundle("i18n/org/opentcs/kernelcontrolcenter/Bundle");
        this.clearMenuItem.setText(bundle.getString("detailPanel.popupMenu_messageDetails.menuItem_clear.text"));
        this.clearMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DetailPanel.this.clearMenuItemActionPerformed(evt);
            }
        });
        this.logPopupMenu.add(this.clearMenuItem);
        this.filterMenu.setText(bundle.getString("detailPanel.popupMenu_messagesTable.subMenu_filter.text"));
        this.filterMenu.setActionCommand(" message filtering");
        this.everythingCheckBoxMenuItem.setText(bundle.getString("detailPanel.popupMenu_messagesTable.subMenu_filter.menuItem_showAll.text"));
        this.everythingCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DetailPanel.this.everythingCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.filterMenu.add(this.everythingCheckBoxMenuItem);
        this.warningsCheckBoxMenuItem.setText(bundle.getString("detailPanel.popupMenu_messagesTable.subMenu_filter.menuItem_showErrorsAndWarnings.text"));
        this.warningsCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DetailPanel.this.warningsCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.filterMenu.add(this.warningsCheckBoxMenuItem);
        this.errorsCheckBoxMenuItem.setText(bundle.getString("detailPanel.popupMenu_messagesTable.subMenu_filter.menuItem_showErrors.text"));
        this.errorsCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DetailPanel.this.errorsCheckBoxMenuItemActionPerformed(evt);
            }
        });
        this.filterMenu.add(this.errorsCheckBoxMenuItem);
        this.loggingTablePopupMenu.add(this.filterMenu);
        this.noVehiclePanel.setLayout(new BorderLayout());
        this.noVehicleLabel.setFont(this.noVehicleLabel.getFont().deriveFont((float)this.noVehicleLabel.getFont().getSize() + 3.0f));
        this.noVehicleLabel.setHorizontalAlignment(0);
        this.noVehicleLabel.setText(bundle.getString("detailPanel.label_noVehicleAttached.text"));
        this.noVehiclePanel.add((Component)this.noVehicleLabel, "Center");
        this.setBorder(BorderFactory.createTitledBorder(DEFAULT_BORDER_TITLE));
        this.setLayout(new BorderLayout());
        this.tabbedPane.setTabLayoutPolicy(1);
        this.overviewTabPanel.setLayout(new GridBagLayout());
        this.headPanel.setLayout(new BorderLayout());
        this.statusPanel.setLayout(new BoxLayout(this.statusPanel, 2));
        this.adapterStatusPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("detailPanel.panel_adapterStatus.border.title")));
        this.adapterStatusPanel.setLayout(new BorderLayout());
        this.chkBoxEnable.setText(bundle.getString("detailPanel.checkBox_enableAdapter.text"));
        this.chkBoxEnable.setEnabled(false);
        this.chkBoxEnable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DetailPanel.this.chkBoxEnableActionPerformed(evt);
            }
        });
        this.adapterStatusPanel.add((Component)this.chkBoxEnable, "Center");
        this.statusPanel.add(this.adapterStatusPanel);
        this.statusFiguresPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("detailPanel.panel_vehicleStatus.border.title")));
        this.statusFiguresPanel.setLayout(new GridBagLayout());
        this.curPosLbl.setText(bundle.getString("detailPanel.label_currentPosition.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.statusFiguresPanel.add((Component)this.curPosLbl, gridBagConstraints);
        this.curPosTxt.setEditable(false);
        this.curPosTxt.setColumns(9);
        this.curPosTxt.setHorizontalAlignment(4);
        this.curPosTxt.setText("Point-0001");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.statusFiguresPanel.add((Component)this.curPosTxt, gridBagConstraints);
        this.curStateLbl.setText(bundle.getString("detailPanel.label_currentState.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.statusFiguresPanel.add((Component)this.curStateLbl, gridBagConstraints);
        this.curStateTxt.setEditable(false);
        this.curStateTxt.setColumns(9);
        this.curStateTxt.setHorizontalAlignment(4);
        this.curStateTxt.setText(Vehicle.State.UNKNOWN.name());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.statusFiguresPanel.add((Component)this.curStateTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        this.statusFiguresPanel.add((Component)this.fillingLbl, gridBagConstraints);
        this.statusPanel.add(this.statusFiguresPanel);
        this.headPanel.add((Component)this.statusPanel, "West");
        this.logoPanel.setBackground(new Color(255, 255, 255));
        this.logoPanel.setLayout(new BorderLayout());
        this.logoLbl.setHorizontalAlignment(0);
        this.logoLbl.setIcon(new ImageIcon(this.getClass().getResource("/org/opentcs/kernelcontrolcenter/res/logos/opentcs_logo.gif")));
        this.logoPanel.add((Component)this.logoLbl, "Center");
        this.headPanel.add((Component)this.logoPanel, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.overviewTabPanel.add((Component)this.headPanel, gridBagConstraints);
        this.logPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("detailPanel.panel_messages.border.title")));
        this.logPanel.setPreferredSize(new Dimension(468, 200));
        this.logPanel.setLayout(new BorderLayout());
        this.logTableScrollPane.setComponentPopupMenu(this.loggingTablePopupMenu);
        this.loggingTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Time stamp", "Message"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.loggingTable.setComponentPopupMenu(this.loggingTablePopupMenu);
        this.loggingTable.setSelectionMode(0);
        this.logTableScrollPane.setViewportView(this.loggingTable);
        this.logPanel.add((Component)this.logTableScrollPane, "Center");
        this.loggingTextArea.setEditable(false);
        this.loggingTextArea.setColumns(20);
        this.loggingTextArea.setFont(new Font("Courier New", 0, 12));
        this.loggingTextArea.setLineWrap(true);
        this.loggingTextArea.setRows(3);
        this.loggingTextArea.setComponentPopupMenu(this.logPopupMenu);
        this.logTextScrollPane.setViewportView(this.loggingTextArea);
        this.logPanel.add((Component)this.logTextScrollPane, "South");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.overviewTabPanel.add((Component)this.logPanel, gridBagConstraints);
        this.tabbedPane.addTab(bundle.getString("detailPanel.tab_generalStatus.text"), this.overviewTabPanel);
        this.add((Component)this.tabbedPane, "Center");
    }

    private void warningsCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        this.loggingTableModel.filterMessages(notification -> notification.getLevel().equals((Object)UserNotification.Level.IMPORTANT) || notification.getLevel().equals((Object)UserNotification.Level.NOTEWORTHY));
        this.warningsCheckBoxMenuItem.setSelected(true);
        this.errorsCheckBoxMenuItem.setSelected(false);
        this.everythingCheckBoxMenuItem.setSelected(false);
    }

    private void everythingCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        this.loggingTableModel.filterMessages(notification -> true);
        this.everythingCheckBoxMenuItem.setSelected(true);
        this.errorsCheckBoxMenuItem.setSelected(false);
        this.warningsCheckBoxMenuItem.setSelected(false);
    }

    private void errorsCheckBoxMenuItemActionPerformed(ActionEvent evt) {
        this.loggingTableModel.filterMessages(notification -> notification.getLevel().equals((Object)UserNotification.Level.IMPORTANT));
        this.errorsCheckBoxMenuItem.setSelected(true);
        this.everythingCheckBoxMenuItem.setSelected(false);
        this.warningsCheckBoxMenuItem.setSelected(false);
    }

    private void clearMenuItemActionPerformed(ActionEvent evt) {
        this.loggingTextArea.setText(DEFAULT_BORDER_TITLE);
    }

    private void chkBoxEnableActionPerformed(ActionEvent evt) {
        try {
            if (this.chkBoxEnable.isSelected()) {
                this.callWrapper.call(() -> this.servicePortal.getVehicleService().enableCommAdapter(this.vehicleEntry.getAttachmentInformation().getVehicleReference()));
            } else {
                this.callWrapper.call(() -> this.servicePortal.getVehicleService().disableCommAdapter(this.vehicleEntry.getAttachmentInformation().getVehicleReference()));
            }
        }
        catch (Exception ex) {
            LOG.warn("Error enabling/disabling comm adapter for {}", (Object)this.vehicleEntry.getVehicleName(), (Object)ex);
        }
    }

    private static /* synthetic */ void lambda$onEvent$0(ProcessModelEvent event, VehicleCommAdapterPanel panel) {
        panel.processModelChange(event.getAttributeChanged(), event.getUpdatedProcessModel());
    }

    private final class RowListener
    implements ListSelectionListener {
        private RowListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (event.getValueIsAdjusting()) {
                return;
            }
            if (DetailPanel.this.loggingTable.getSelectedRow() >= 0) {
                DetailPanel.this.outputLogNotification(DetailPanel.this.loggingTable.getSelectedRow());
            } else {
                DetailPanel.this.loggingTextArea.setText(DetailPanel.DEFAULT_BORDER_TITLE);
            }
        }
    }
}

