/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernelcontrolcenter.vehicles;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.opentcs.access.KernelServicePortal;
import org.opentcs.components.Lifecycle;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.customizations.ServiceCallWrapper;
import org.opentcs.data.model.Vehicle;
import org.opentcs.drivers.vehicle.management.AttachmentEvent;
import org.opentcs.drivers.vehicle.management.AttachmentInformation;
import org.opentcs.drivers.vehicle.management.ProcessModelEvent;
import org.opentcs.drivers.vehicle.management.VehicleProcessModelTO;
import org.opentcs.kernelcontrolcenter.vehicles.LocalVehicleEntry;
import org.opentcs.util.CallWrapper;
import org.opentcs.util.event.EventHandler;
import org.opentcs.util.event.EventSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalVehicleEntryPool
implements EventHandler,
Lifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(LocalVehicleEntryPool.class);
    private final KernelServicePortal servicePortal;
    private final CallWrapper callWrapper;
    private final EventSource eventSource;
    private final Map<String, LocalVehicleEntry> entries = new TreeMap<String, LocalVehicleEntry>();
    private boolean initialized;

    @Inject
    public LocalVehicleEntryPool(KernelServicePortal servicePortal, @ServiceCallWrapper CallWrapper callWrapper, @ApplicationEventBus EventSource eventSource) {
        this.servicePortal = Objects.requireNonNull(servicePortal, "servicePortal");
        this.callWrapper = Objects.requireNonNull(callWrapper, "callWrapper");
        this.eventSource = Objects.requireNonNull(eventSource, "eventSource");
    }

    public void initialize() {
        if (this.isInitialized()) {
            LOG.debug("Already initialized.");
            return;
        }
        this.eventSource.subscribe((EventHandler)this);
        try {
            Set vehicles = (Set)this.callWrapper.call(() -> this.servicePortal.getVehicleService().fetchObjects(Vehicle.class));
            for (Vehicle vehicle : vehicles) {
                AttachmentInformation ai = (AttachmentInformation)this.callWrapper.call(() -> this.servicePortal.getVehicleService().fetchAttachmentInformation(vehicle.getReference()));
                VehicleProcessModelTO processModel = (VehicleProcessModelTO)this.callWrapper.call(() -> this.servicePortal.getVehicleService().fetchProcessModel(vehicle.getReference()));
                LocalVehicleEntry entry = new LocalVehicleEntry(ai, processModel);
                this.entries.put(vehicle.getName(), entry);
            }
        }
        catch (Exception ex) {
            LOG.warn("Error initializing local vehicle entry pool", (Throwable)ex);
            this.entries.clear();
            return;
        }
        LOG.debug("Initialized vehicle entry pool: {}", this.entries);
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void terminate() {
        if (!this.isInitialized()) {
            LOG.debug("Not initialized.");
            return;
        }
        this.eventSource.unsubscribe((EventHandler)this);
        this.entries.clear();
        this.initialized = false;
    }

    public void onEvent(Object event) {
        if (event instanceof ProcessModelEvent) {
            ProcessModelEvent e = (ProcessModelEvent)event;
            LocalVehicleEntry entry = this.getEntryFor(e.getUpdatedProcessModel().getVehicleName());
            if (entry == null) {
                return;
            }
            entry.setProcessModel(e.getUpdatedProcessModel());
        } else if (event instanceof AttachmentEvent) {
            AttachmentEvent e = (AttachmentEvent)event;
            LocalVehicleEntry entry = this.getEntryFor(e.getVehicleName());
            if (entry == null) {
                return;
            }
            entry.setAttachmentInformation(e.getUpdatedAttachmentInformation());
        }
    }

    @Nonnull
    public Map<String, LocalVehicleEntry> getEntries() {
        return this.entries;
    }

    @Nullable
    public LocalVehicleEntry getEntryFor(String vehicleName) {
        return vehicleName == null ? null : this.entries.get(vehicleName);
    }
}

