/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernelcontrolcenter.vehicles;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;

final class SingleCellEditor
implements TableCellEditor {
    private final Map<Integer, TableCellEditor> editors;
    private TableCellEditor editor;
    private final TableCellEditor defaultEditor;
    private final JTable table;

    public SingleCellEditor(JTable table) {
        this.table = table;
        this.editors = new HashMap<Integer, TableCellEditor>();
        this.defaultEditor = new DefaultCellEditor(new JTextField());
    }

    public void setEditorAt(int row, TableCellEditor rowEditor) {
        this.editors.put(row, rowEditor);
    }

    @Override
    public Component getTableCellEditorComponent(JTable whichTable, Object value, boolean isSelected, int row, int column) {
        return this.editor.getTableCellEditorComponent(whichTable, value, isSelected, row, column);
    }

    @Override
    public Object getCellEditorValue() {
        return this.editor.getCellEditorValue();
    }

    @Override
    public boolean stopCellEditing() {
        return this.editor.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        this.editor.cancelCellEditing();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof KeyEvent) {
            return false;
        }
        this.selectEditor((MouseEvent)anEvent);
        return this.editor.isCellEditable(anEvent);
    }

    @Override
    public void addCellEditorListener(CellEditorListener l) {
        this.editor.addCellEditorListener(l);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l) {
        this.editor.removeCellEditorListener(l);
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        this.selectEditor((MouseEvent)anEvent);
        return this.editor.shouldSelectCell(anEvent);
    }

    public void selectEditor(MouseEvent e) {
        int row = e == null ? this.table.getSelectionModel().getAnchorSelectionIndex() : this.table.rowAtPoint(e.getPoint());
        this.editor = this.editors.get(row);
        if (this.editor == null) {
            this.editor = this.defaultEditor;
        }
        this.table.changeSelection(row, this.table.getColumn("Adapter").getModelIndex(), false, false);
    }
}

