/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernelcontrolcenter.vehicles;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.opentcs.components.kernel.services.VehicleService;
import org.opentcs.drivers.vehicle.VehicleCommAdapterDescription;
import org.opentcs.drivers.vehicle.management.AttachmentInformation;
import org.opentcs.drivers.vehicle.management.VehicleProcessModelTO;
import org.opentcs.kernelcontrolcenter.vehicles.LocalVehicleEntry;
import org.opentcs.util.CallWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VehicleTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(VehicleTableModel.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("i18n/org/opentcs/kernelcontrolcenter/Bundle");
    private static final String[] COLUMN_NAMES = new String[]{BUNDLE.getString("vehicleTableModel.column_vehicle.headerText"), BUNDLE.getString("vehicleTableModel.column_state.headerText"), BUNDLE.getString("vehicleTableModel.column_adapter.headerText"), BUNDLE.getString("vehicleTableModel.column_enabled.headerText"), BUNDLE.getString("vehicleTableModel.column_position.headerText")};
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{String.class, String.class, VehicleCommAdapterDescription.class, Boolean.class, String.class};
    private static final int VEHICLE_COLUMN = 0;
    private static final int STATE_COLUMNN = 1;
    private static final int ADAPTER_COLUMN = 2;
    private static final int ENABLED_COLUMN = 3;
    private static final int POSITION_COLUMN = 4;
    private final List<LocalVehicleEntry> entries = new ArrayList<LocalVehicleEntry>();
    public static final String ADAPTER_COLUMN_IDENTIFIER = COLUMN_NAMES[2];
    public static final String POSITION_COLUMN_IDENTIFIER = COLUMN_NAMES[4];
    private final VehicleService vehicleService;
    private final CallWrapper callWrapper;

    public VehicleTableModel(VehicleService vehicleService, CallWrapper callWrapper) {
        this.vehicleService = Objects.requireNonNull(vehicleService, "vehicleService");
        this.callWrapper = Objects.requireNonNull(callWrapper, "callWrapper");
    }

    public void addData(LocalVehicleEntry newEntry) {
        this.entries.add(newEntry);
        this.fireTableRowsInserted(this.entries.size(), this.entries.size());
    }

    public LocalVehicleEntry getDataAt(int row) {
        if (row >= 0) {
            return this.entries.get(row);
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.entries.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        LocalVehicleEntry entry = this.entries.get(rowIndex);
        switch (columnIndex) {
            case 2: {
                break;
            }
            case 3: {
                try {
                    if (((Boolean)aValue).booleanValue()) {
                        this.callWrapper.call(() -> this.vehicleService.enableCommAdapter(entry.getAttachmentInformation().getVehicleReference()));
                        break;
                    }
                    this.callWrapper.call(() -> this.vehicleService.disableCommAdapter(entry.getAttachmentInformation().getVehicleReference()));
                }
                catch (Exception ex) {
                    LOG.warn("Error enabling/disabling comm adapter for {}", (Object)entry.getVehicleName(), (Object)ex);
                }
                break;
            }
            case 4: {
                break;
            }
            default: {
                LOG.warn("Unhandled column index: {}", (Object)columnIndex);
            }
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.entries.size()) {
            return null;
        }
        LocalVehicleEntry entry = this.entries.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return entry.getVehicleName();
            }
            case 1: {
                return this.getVehicleState(entry);
            }
            case 2: {
                return entry.getAttachmentInformation().getAttachedCommAdapter();
            }
            case 3: {
                return entry.getProcessModel().isCommAdapterEnabled();
            }
            case 4: {
                return entry.getProcessModel().getVehiclePosition();
            }
        }
        LOG.warn("Unhandled column index: {}", (Object)columnIndex);
        return "Invalid column index " + columnIndex;
    }

    @Override
    public String getColumnName(int columnIndex) {
        try {
            return COLUMN_NAMES[columnIndex];
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            LOG.warn("Invalid columnIndex", (Throwable)exc);
            return "Invalid column index " + columnIndex;
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_CLASSES[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                LocalVehicleEntry entry = this.entries.get(rowIndex);
                return entry.getAttachedCommAdapterDescription().isSimVehicleCommAdapter() && entry.getProcessModel().isCommAdapterEnabled();
            }
        }
        return false;
    }

    public List<LocalVehicleEntry> getVehicleEntries() {
        return this.entries;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!(evt.getSource() instanceof LocalVehicleEntry)) {
            return;
        }
        if (!this.isRelevantUpdate(evt)) {
            return;
        }
        LocalVehicleEntry entry = (LocalVehicleEntry)evt.getSource();
        for (int index = 0; index < this.entries.size(); ++index) {
            if (entry != this.entries.get(index)) continue;
            int myIndex = index;
            SwingUtilities.invokeLater(() -> this.fireTableRowsUpdated(myIndex, myIndex));
        }
    }

    private String getVehicleState(LocalVehicleEntry entry) {
        return entry.getProcessModel().getVehicleState().name();
    }

    private boolean isRelevantUpdate(PropertyChangeEvent evt) {
        if (Objects.equals(evt.getPropertyName(), LocalVehicleEntry.Attribute.ATTACHMENT_INFORMATION.name())) {
            AttachmentInformation oldInfo = (AttachmentInformation)evt.getOldValue();
            AttachmentInformation newInfo = (AttachmentInformation)evt.getNewValue();
            return !oldInfo.getAttachedCommAdapter().equals((Object)newInfo.getAttachedCommAdapter());
        }
        if (Objects.equals(evt.getPropertyName(), LocalVehicleEntry.Attribute.PROCESS_MODEL.name())) {
            VehicleProcessModelTO oldTo = (VehicleProcessModelTO)evt.getOldValue();
            VehicleProcessModelTO newTo = (VehicleProcessModelTO)evt.getNewValue();
            return oldTo.isCommAdapterEnabled() != newTo.isCommAdapterEnabled() || oldTo.getVehicleState() != newTo.getVehicleState() || !Objects.equals(oldTo.getVehiclePosition(), newTo.getVehiclePosition());
        }
        return false;
    }
}

