/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernelcontrolcenter;

import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import java.io.File;
import java.util.List;
import java.util.Locale;
import javax.inject.Singleton;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.opentcs.access.KernelServicePortal;
import org.opentcs.access.SslParameterSet;
import org.opentcs.access.rmi.KernelServicePortalBuilder;
import org.opentcs.access.rmi.factories.NullSocketFactoryProvider;
import org.opentcs.access.rmi.factories.SecureSocketFactoryProvider;
import org.opentcs.access.rmi.factories.SocketFactoryProvider;
import org.opentcs.common.DefaultPortalManager;
import org.opentcs.common.KernelClientApplication;
import org.opentcs.common.PortalManager;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.customizations.ApplicationHome;
import org.opentcs.customizations.ConfigurableInjectionModule;
import org.opentcs.customizations.ServiceCallWrapper;
import org.opentcs.kernelcontrolcenter.KernelControlCenterApplication;
import org.opentcs.kernelcontrolcenter.exchange.DefaultServiceCallWrapper;
import org.opentcs.kernelcontrolcenter.exchange.SslConfiguration;
import org.opentcs.kernelcontrolcenter.util.KernelControlCenterConfiguration;
import org.opentcs.kernelcontrolcenter.vehicles.LocalVehicleEntryPool;
import org.opentcs.util.CallWrapper;
import org.opentcs.util.event.EventBus;
import org.opentcs.util.event.EventHandler;
import org.opentcs.util.event.EventSource;
import org.opentcs.util.event.SimpleEventBus;
import org.opentcs.util.gui.dialog.ConnectionParamSet;
import org.opentcs.virtualvehicle.AdapterPanelComponentsFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultKernelControlCenterInjectionModule
extends ConfigurableInjectionModule {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultKernelControlCenterInjectionModule.class);

    protected void configure() {
        File applicationHome = new File(System.getProperty("opentcs.home", "."));
        this.bind(File.class).annotatedWith(ApplicationHome.class).toInstance((Object)applicationHome);
        this.bind(LocalVehicleEntryPool.class).in(Singleton.class);
        this.bind(KernelClientApplication.class).to(KernelControlCenterApplication.class).in(Singleton.class);
        this.install(new FactoryModuleBuilder().build(AdapterPanelComponentsFactory.class));
        this.configureEventBus();
        this.configureKernelControlCenterDependencies();
        this.configureExchangeInjectionModules();
    }

    private void configureEventBus() {
        SimpleEventBus newEventBus = new SimpleEventBus();
        this.bind(EventHandler.class).annotatedWith(ApplicationEventBus.class).toInstance((Object)newEventBus);
        this.bind(EventSource.class).annotatedWith(ApplicationEventBus.class).toInstance((Object)newEventBus);
        this.bind(EventBus.class).annotatedWith(ApplicationEventBus.class).toInstance((Object)newEventBus);
    }

    private void configureExchangeInjectionModules() {
        this.bind(PortalManager.class).to(DefaultPortalManager.class).in(Singleton.class);
    }

    private void configureKernelControlCenterDependencies() {
        KernelControlCenterConfiguration configuration = (KernelControlCenterConfiguration)this.getConfigBindingProvider().get("kernelcontrolcenter", KernelControlCenterConfiguration.class);
        this.bind(KernelControlCenterConfiguration.class).toInstance((Object)configuration);
        this.configureKernelControlCenter(configuration);
        this.configureSocketConnections();
        this.bind(CallWrapper.class).annotatedWith(ServiceCallWrapper.class).to(DefaultServiceCallWrapper.class).in(Singleton.class);
        this.bind((TypeLiteral)new TypeLiteral<List<ConnectionParamSet>>(){}).toInstance(configuration.connectionBookmarks());
    }

    private void configureSocketConnections() {
        SecureSocketFactoryProvider socketFactoryProvider;
        SslConfiguration sslConfiguration = (SslConfiguration)this.getConfigBindingProvider().get("ssl", SslConfiguration.class);
        SslParameterSet sslParamSet = new SslParameterSet("PKCS12", null, null, new File(sslConfiguration.truststoreFile()), sslConfiguration.truststorePassword());
        this.bind(SslParameterSet.class).toInstance((Object)sslParamSet);
        if (sslConfiguration.enable()) {
            socketFactoryProvider = new SecureSocketFactoryProvider(sslParamSet);
        } else {
            LOG.warn("SSL encryption disabled, connections will not be secured!");
            socketFactoryProvider = new NullSocketFactoryProvider();
        }
        this.bind(KernelServicePortal.class).toInstance((Object)new KernelServicePortalBuilder("Alice", "xyz").setSocketFactoryProvider((SocketFactoryProvider)socketFactoryProvider).build());
    }

    private void configureKernelControlCenter(KernelControlCenterConfiguration configuration) {
        Locale.setDefault(Locale.forLanguageTag(configuration.locale()));
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            LOG.warn("Could not set look-and-feel", (Throwable)ex);
        }
        ToolTipManager.sharedInstance().setDismissDelay(30000);
    }
}

