/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernelcontrolcenter;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.opentcs.configuration.ConfigurationBindingProvider;
import org.opentcs.configuration.cfg4j.Cfg4jConfigurationBindingProvider;
import org.opentcs.customizations.controlcenter.ControlCenterInjectionModule;
import org.opentcs.kernelcontrolcenter.DefaultKernelControlCenterInjectionModule;
import org.opentcs.kernelcontrolcenter.KernelControlCenterApplication;
import org.opentcs.util.Environment;
import org.opentcs.util.logging.UncaughtExceptionLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunKernelControlCenter {
    private static final Logger LOG = LoggerFactory.getLogger(RunKernelControlCenter.class);

    private RunKernelControlCenter() {
    }

    public static void main(String[] args) {
        System.setSecurityManager(new SecurityManager());
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new UncaughtExceptionLogger(false));
        Environment.logSystemInfo();
        Injector injector = Guice.createInjector((Module[])new Module[]{RunKernelControlCenter.customConfigurationModule()});
        ((KernelControlCenterApplication)injector.getInstance(KernelControlCenterApplication.class)).initialize();
    }

    private static Module customConfigurationModule() {
        ConfigurationBindingProvider bindingProvider = RunKernelControlCenter.configurationBindingProvider();
        DefaultKernelControlCenterInjectionModule kernelControlCenterInjectionModule = new DefaultKernelControlCenterInjectionModule();
        kernelControlCenterInjectionModule.setConfigBindingProvider(bindingProvider);
        return Modules.override((Module[])new Module[]{kernelControlCenterInjectionModule}).with(RunKernelControlCenter.findRegisteredModules(bindingProvider));
    }

    private static List<ControlCenterInjectionModule> findRegisteredModules(ConfigurationBindingProvider bindingProvider) {
        ArrayList<ControlCenterInjectionModule> registeredModules = new ArrayList<ControlCenterInjectionModule>();
        for (ControlCenterInjectionModule module : ServiceLoader.load(ControlCenterInjectionModule.class)) {
            LOG.info("Integrating injection module {} (source: {})", (Object)module.getClass().getName(), (Object)module.getClass().getProtectionDomain().getCodeSource());
            module.setConfigBindingProvider(bindingProvider);
            registeredModules.add(module);
        }
        return registeredModules;
    }

    private static ConfigurationBindingProvider configurationBindingProvider() {
        return new Cfg4jConfigurationBindingProvider(Paths.get(System.getProperty("opentcs.base", "."), "config", "opentcs-kernelcontrolcenter-defaults-baseline.properties").toAbsolutePath(), new Path[]{Paths.get(System.getProperty("opentcs.base", "."), "config", "opentcs-kernelcontrolcenter-defaults-custom.properties").toAbsolutePath(), Paths.get(System.getProperty("opentcs.home", "."), "config", "opentcs-kernelcontrolcenter.properties").toAbsolutePath()});
    }
}

