/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernelcontrolcenter.exchange;

import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import org.opentcs.access.Kernel;
import org.opentcs.access.KernelServicePortal;
import org.opentcs.access.KernelStateTransitionEvent;
import org.opentcs.common.ClientConnectionMode;
import org.opentcs.common.KernelClientApplication;
import org.opentcs.common.PortalManager;
import org.opentcs.components.Lifecycle;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.customizations.ServiceCallWrapper;
import org.opentcs.util.Assertions;
import org.opentcs.util.CallWrapper;
import org.opentcs.util.CyclicTask;
import org.opentcs.util.event.EventBus;
import org.opentcs.util.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KernelEventFetcher
implements EventHandler,
Lifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(KernelEventFetcher.class);
    private final long eventFetchInterval = 1L;
    private final long eventFetchTimeout = 1000L;
    private final KernelClientApplication application;
    private final KernelServicePortal servicePortal;
    private final CallWrapper callWrapper;
    private final EventBus eventBus;
    private EventFetcherTask eventFetcherTask;
    private boolean initialized;

    @Inject
    public KernelEventFetcher(KernelClientApplication application, KernelServicePortal servicePortal, @ServiceCallWrapper CallWrapper callWrapper, @ApplicationEventBus EventBus eventBus) {
        this.application = Objects.requireNonNull(application, "application");
        this.servicePortal = Objects.requireNonNull(servicePortal, "servicePortal");
        this.callWrapper = Objects.requireNonNull(callWrapper, "callWrapper");
        this.eventBus = Objects.requireNonNull(eventBus, "eventBus");
    }

    public void initialize() {
        if (this.isInitialized()) {
            return;
        }
        this.eventBus.subscribe((EventHandler)this);
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void terminate() {
        if (!this.isInitialized()) {
            return;
        }
        this.eventBus.unsubscribe((EventHandler)this);
        this.initialized = false;
    }

    public void onEvent(Object event) {
        if (event == PortalManager.ConnectionState.DISCONNECTING) {
            this.onKernelDisconnect();
        } else if (event instanceof ClientConnectionMode) {
            ClientConnectionMode applicationState = (ClientConnectionMode)event;
            switch (applicationState) {
                case ONLINE: {
                    this.onKernelConnect();
                    break;
                }
                case OFFLINE: {
                    this.onKernelDisconnect();
                    break;
                }
                default: {
                    LOG.debug("Unhandled portal connection state: {}", (Object)applicationState.name());
                }
            }
        }
    }

    private void onKernelConnect() {
        if (this.eventFetcherTask != null) {
            return;
        }
        this.eventFetcherTask = new EventFetcherTask(1L, 1000L);
        Thread eventFetcherThread = new Thread((Runnable)((Object)this.eventFetcherTask), this.getClass().getName() + "-fetcherTask");
        eventFetcherThread.start();
    }

    private void onKernelDisconnect() {
        if (this.eventFetcherTask == null) {
            return;
        }
        this.eventFetcherTask.terminateAndWait();
        this.eventFetcherTask = null;
    }

    private class EventFetcherTask
    extends CyclicTask {
        private final long timeout;

        private EventFetcherTask(long interval, long timeout) {
            super(interval);
            this.timeout = Assertions.checkInRange((long)timeout, (long)1L, (long)Long.MAX_VALUE, (String)"timeout");
        }

        protected void runActualTask() {
            boolean shutDown = false;
            try {
                LOG.debug("Fetching remote kernel for events");
                List events = (List)KernelEventFetcher.this.callWrapper.call(() -> KernelEventFetcher.this.servicePortal.fetchEvents(this.timeout));
                for (Object event : events) {
                    LOG.debug("Processing fetched event: {}", event);
                    KernelEventFetcher.this.eventBus.onEvent(event);
                    if (!(event instanceof KernelStateTransitionEvent)) continue;
                    KernelStateTransitionEvent stateEvent = (KernelStateTransitionEvent)event;
                    shutDown = stateEvent.getEnteredState() == Kernel.State.SHUTDOWN;
                }
            }
            catch (Exception exc) {
                LOG.error("Exception fetching events", (Throwable)exc);
            }
            if (shutDown) {
                KernelEventFetcher.this.application.offline();
            }
        }
    }
}

