/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernelcontrolcenter.peripherals;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.opentcs.data.model.Location;
import org.opentcs.data.model.TCSResourceReference;
import org.opentcs.drivers.peripherals.PeripheralCommAdapterDescription;
import org.opentcs.drivers.peripherals.PeripheralProcessModel;

public class LocalPeripheralEntry {
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final TCSResourceReference<Location> location;
    private PeripheralCommAdapterDescription attachedCommAdapter;
    private PeripheralProcessModel processModel;

    public LocalPeripheralEntry(@Nonnull TCSResourceReference<Location> location, @Nonnull PeripheralCommAdapterDescription attachedCommAdapter, @Nonnull PeripheralProcessModel processModel) {
        this.location = Objects.requireNonNull(location, "location");
        this.attachedCommAdapter = Objects.requireNonNull(attachedCommAdapter, "attachedCommAdapter");
        this.processModel = Objects.requireNonNull(processModel, "processModel");
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    @Nonnull
    public TCSResourceReference<Location> getLocation() {
        return this.location;
    }

    @Nonnull
    public PeripheralCommAdapterDescription getAttachedCommAdapter() {
        return this.attachedCommAdapter;
    }

    public void setAttachedCommAdapter(@Nonnull PeripheralCommAdapterDescription attachedCommAdapter) {
        PeripheralCommAdapterDescription oldAttachedCommAdapter = this.attachedCommAdapter;
        this.attachedCommAdapter = Objects.requireNonNull(attachedCommAdapter, "attachedCommAdapter");
        this.pcs.firePropertyChange(Attribute.ATTACHED_COMM_ADAPTER.name(), oldAttachedCommAdapter, attachedCommAdapter);
    }

    @Nonnull
    public PeripheralProcessModel getProcessModel() {
        return this.processModel;
    }

    public void setProcessModel(@Nonnull PeripheralProcessModel processModel) {
        PeripheralProcessModel oldProcessModel = this.processModel;
        this.processModel = Objects.requireNonNull(processModel, "processModel");
        this.pcs.firePropertyChange(Attribute.PROCESS_MODEL.name(), oldProcessModel, processModel);
    }

    public static enum Attribute {
        PROCESS_MODEL,
        ATTACHED_COMM_ADAPTER;

    }
}

