/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernelcontrolcenter.peripherals;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.TitledBorder;
import org.opentcs.components.Lifecycle;
import org.opentcs.drivers.peripherals.management.PeripheralCommAdapterPanel;
import org.opentcs.drivers.peripherals.management.PeripheralCommAdapterPanelFactory;
import org.opentcs.kernelcontrolcenter.peripherals.LocalPeripheralEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeripheralDetailPanel
extends JPanel
implements PropertyChangeListener,
Lifecycle {
    private static final Logger LOG = LoggerFactory.getLogger(PeripheralDetailPanel.class);
    private static final String DEFAULT_BORDER_TITLE = "";
    private final List<PeripheralCommAdapterPanel> customPanelList = new ArrayList<PeripheralCommAdapterPanel>();
    private final Set<PeripheralCommAdapterPanelFactory> panelFactories;
    private LocalPeripheralEntry peripheralEntry;
    private boolean initialized;
    private JLabel noPeripheralDeviceLabel;
    private JPanel noPeripheralDevicePanel;
    private JTabbedPane tabbedPane;

    @Inject
    public PeripheralDetailPanel(Set<PeripheralCommAdapterPanelFactory> panelFactories) {
        this.panelFactories = Objects.requireNonNull(panelFactories, "panelFactories");
        this.initComponents();
        this.detachFromEntry();
    }

    public void initialize() {
        if (this.isInitialized()) {
            return;
        }
        for (PeripheralCommAdapterPanelFactory panelFactory : this.panelFactories) {
            panelFactory.initialize();
        }
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void terminate() {
        if (!this.isInitialized()) {
            return;
        }
        this.detachFromEntry();
        for (PeripheralCommAdapterPanelFactory panelFactory : this.panelFactories) {
            panelFactory.terminate();
        }
        this.initialized = false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!(evt.getSource() instanceof LocalPeripheralEntry)) {
            return;
        }
        LocalPeripheralEntry entry = (LocalPeripheralEntry)evt.getSource();
        if (!Objects.equals(entry, this.peripheralEntry)) {
            return;
        }
        if (Objects.equals(evt.getPropertyName(), LocalPeripheralEntry.Attribute.PROCESS_MODEL.name())) {
            for (PeripheralCommAdapterPanel panel : this.customPanelList) {
                panel.processModelChanged(entry.getProcessModel());
            }
        }
    }

    public void attachToEntry(LocalPeripheralEntry newPeripheralEntry) {
        Objects.requireNonNull(newPeripheralEntry, "newPeripheralEntry");
        if (this.peripheralEntry != newPeripheralEntry) {
            this.detachFromEntry();
        }
        this.peripheralEntry = newPeripheralEntry;
        this.setBorderTitle(this.peripheralEntry.getProcessModel().getLocation().getName());
        this.removeAll();
        this.add(this.tabbedPane);
        this.updateCustomPanels();
        this.validate();
        if (!this.customPanelList.isEmpty()) {
            this.tabbedPane.setSelectedIndex(0);
        }
        this.peripheralEntry.addPropertyChangeListener(this);
    }

    private void detachFromEntry() {
        if (this.peripheralEntry != null) {
            this.peripheralEntry.removePropertyChangeListener(this);
            this.removeAndClearCustomPanels();
            this.peripheralEntry = null;
        }
        this.setBorderTitle(DEFAULT_BORDER_TITLE);
        this.removeAll();
        this.add(this.noPeripheralDevicePanel);
        this.validate();
    }

    private void removeAndClearCustomPanels() {
        for (PeripheralCommAdapterPanel panel : this.customPanelList) {
            LOG.debug("Removing {} from tabbedPane.", (Object)panel);
            this.tabbedPane.remove((Component)panel);
        }
        this.customPanelList.clear();
    }

    private void updateCustomPanels() {
        this.removeAndClearCustomPanels();
        if (this.peripheralEntry == null) {
            return;
        }
        for (PeripheralCommAdapterPanelFactory panelFactory : this.panelFactories) {
            this.customPanelList.addAll(panelFactory.getPanelsFor(this.peripheralEntry.getAttachedCommAdapter(), this.peripheralEntry.getLocation(), this.peripheralEntry.getProcessModel()));
        }
        for (PeripheralCommAdapterPanel curPanel : this.customPanelList) {
            LOG.debug("Adding {} with title {} to tabbedPane.", (Object)curPanel, (Object)curPanel.getTitle());
            this.tabbedPane.addTab(curPanel.getTitle(), (Component)curPanel);
        }
    }

    private void setBorderTitle(String title) {
        Objects.requireNonNull(title, "title");
        ((TitledBorder)this.getBorder()).setTitle(title);
        this.repaint();
    }

    private void initComponents() {
        this.noPeripheralDevicePanel = new JPanel();
        this.noPeripheralDeviceLabel = new JLabel();
        this.tabbedPane = new JTabbedPane();
        this.noPeripheralDevicePanel.setLayout(new BorderLayout());
        this.noPeripheralDeviceLabel.setFont(this.noPeripheralDeviceLabel.getFont().deriveFont((float)this.noPeripheralDeviceLabel.getFont().getSize() + 3.0f));
        this.noPeripheralDeviceLabel.setHorizontalAlignment(0);
        ResourceBundle bundle = ResourceBundle.getBundle("i18n/org/opentcs/kernelcontrolcenter/Bundle");
        this.noPeripheralDeviceLabel.setText(bundle.getString("peripheralDetailPanel.label_noPeripheralDeviceAttached.text"));
        this.noPeripheralDevicePanel.add((Component)this.noPeripheralDeviceLabel, "Center");
        this.setBorder(BorderFactory.createTitledBorder(DEFAULT_BORDER_TITLE));
        this.setLayout(new BorderLayout());
        this.tabbedPane.setTabLayoutPolicy(1);
        this.add((Component)this.tabbedPane, "Center");
    }
}

