/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernelcontrolcenter.peripherals;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.opentcs.access.KernelServicePortal;
import org.opentcs.drivers.peripherals.PeripheralCommAdapterDescription;
import org.opentcs.drivers.peripherals.PeripheralProcessModel;
import org.opentcs.drivers.peripherals.management.PeripheralAttachmentInformation;
import org.opentcs.kernelcontrolcenter.peripherals.LocalPeripheralEntry;
import org.opentcs.util.Assertions;
import org.opentcs.util.CallWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeripheralTableModel
extends AbstractTableModel
implements PropertyChangeListener {
    public static final int COLUMN_LOCATION = 0;
    public static final int COLUMN_ADAPTER = 1;
    public static final int COLUMN_ENABLED = 2;
    private static final Logger LOG = LoggerFactory.getLogger(PeripheralTableModel.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("i18n/org/opentcs/kernelcontrolcenter/Bundle");
    private static final String[] COLUMN_NAMES = new String[]{BUNDLE.getString("peripheralTableModel.column_location.headerText"), BUNDLE.getString("peripheralTableModel.column_adapter.headerText"), BUNDLE.getString("peripheralTableModel.column_enabled.headerText")};
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{String.class, PeripheralCommAdapterDescription.class, Boolean.class};
    private final KernelServicePortal servicePortal;
    private final CallWrapper callWrapper;
    private final List<LocalPeripheralEntry> entries = new ArrayList<LocalPeripheralEntry>();

    public PeripheralTableModel(KernelServicePortal servicePortal, CallWrapper callWrapper) {
        this.servicePortal = Objects.requireNonNull(servicePortal, "servicePortal");
        this.callWrapper = Objects.requireNonNull(callWrapper, "callWrapper");
    }

    public void addData(LocalPeripheralEntry entry) {
        this.entries.add(entry);
        this.fireTableRowsInserted(this.entries.size() - 1, this.entries.size() - 1);
    }

    public LocalPeripheralEntry getDataAt(int index) {
        Assertions.checkArgument((index >= 0 && index < this.entries.size() ? 1 : 0) != 0, (String)"index must be in 0..%d: %d", (Object[])new Object[]{this.entries.size(), index});
        return this.entries.get(index);
    }

    @Override
    public int getRowCount() {
        return this.entries.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.entries.size()) {
            return null;
        }
        LocalPeripheralEntry entry = this.entries.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return entry.getProcessModel().getLocation().getName();
            }
            case 1: {
                return entry.getAttachedCommAdapter();
            }
            case 2: {
                return entry.getProcessModel().isCommAdapterEnabled();
            }
        }
        throw new IllegalArgumentException("Invalid column index: " + columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Objects.requireNonNull(aValue, "aValue");
        LocalPeripheralEntry entry = this.entries.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                try {
                    if (((Boolean)aValue).booleanValue()) {
                        this.callWrapper.call(() -> this.servicePortal.getPeripheralService().enableCommAdapter(entry.getLocation()));
                        break;
                    }
                    this.callWrapper.call(() -> this.servicePortal.getPeripheralService().disableCommAdapter(entry.getLocation()));
                }
                catch (Exception ex) {
                    LOG.warn("Error enabling/disabling peripheral comm adapter for {}", (Object)entry.getLocation().getName(), (Object)ex);
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid column index: " + columnIndex);
            }
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return false;
            }
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_CLASSES[columnIndex];
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.isRelevantUpdate(evt)) {
            return;
        }
        LocalPeripheralEntry entry = (LocalPeripheralEntry)evt.getSource();
        int index = this.entries.indexOf(entry);
        SwingUtilities.invokeLater(() -> this.fireTableRowsUpdated(index, index));
    }

    private boolean isRelevantUpdate(PropertyChangeEvent evt) {
        if (!(evt.getSource() instanceof LocalPeripheralEntry)) {
            return false;
        }
        if (Objects.equals(evt.getPropertyName(), LocalPeripheralEntry.Attribute.ATTACHED_COMM_ADAPTER.name())) {
            PeripheralAttachmentInformation oldInfo = (PeripheralAttachmentInformation)evt.getOldValue();
            PeripheralAttachmentInformation newInfo = (PeripheralAttachmentInformation)evt.getNewValue();
            return !oldInfo.getAttachedCommAdapter().equals((Object)newInfo.getAttachedCommAdapter());
        }
        if (Objects.equals(evt.getPropertyName(), LocalPeripheralEntry.Attribute.PROCESS_MODEL.name())) {
            PeripheralProcessModel oldTo = (PeripheralProcessModel)evt.getOldValue();
            PeripheralProcessModel newTo = (PeripheralProcessModel)evt.getNewValue();
            return oldTo.isCommAdapterEnabled() != newTo.isCommAdapterEnabled();
        }
        return false;
    }
}

