/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernelcontrolcenter.peripherals;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import org.opentcs.access.Kernel;
import org.opentcs.access.KernelServicePortal;
import org.opentcs.common.peripherals.NullPeripheralCommAdapterDescription;
import org.opentcs.components.kernelcontrolcenter.ControlCenterPanel;
import org.opentcs.customizations.ServiceCallWrapper;
import org.opentcs.kernelcontrolcenter.peripherals.LocalPeripheralEntry;
import org.opentcs.kernelcontrolcenter.peripherals.LocalPeripheralEntryPool;
import org.opentcs.kernelcontrolcenter.peripherals.PeripheralDetailPanel;
import org.opentcs.kernelcontrolcenter.peripherals.PeripheralTableModel;
import org.opentcs.util.Assertions;
import org.opentcs.util.CallWrapper;
import org.opentcs.util.gui.StringTableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeripheralsPanel
extends ControlCenterPanel {
    private static final Logger LOG = LoggerFactory.getLogger(PeripheralsPanel.class);
    private final KernelServicePortal servicePortal;
    private final CallWrapper callWrapper;
    private final LocalPeripheralEntryPool peripheralEntryPool;
    private final PeripheralDetailPanel detailPanel;
    private TableRowSorter<PeripheralTableModel> sorter;
    private boolean initialized;
    private JPanel filterPanel;
    private JCheckBox hideDetachedLocationsCheckBox;
    private JScrollPane jScrollPane1;
    private JPanel listPanel;
    private JPanel peripheralDetailsPanel;
    private JTable peripheralTable;

    @Inject
    public PeripheralsPanel(@Nonnull KernelServicePortal servicePortal, @Nonnull @ServiceCallWrapper CallWrapper callWrapper, @Nonnull LocalPeripheralEntryPool peripheralEntryPool, @Nonnull PeripheralDetailPanel detailPanel) {
        this.servicePortal = Objects.requireNonNull(servicePortal, "servicePortal");
        this.callWrapper = Objects.requireNonNull(callWrapper, "callWrapper");
        this.peripheralEntryPool = Objects.requireNonNull(peripheralEntryPool, "peripheralEntryPool");
        this.detailPanel = Objects.requireNonNull(detailPanel, "detailPanel");
        this.initComponents();
        this.peripheralDetailsPanel.add(detailPanel);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize() {
        Kernel.State kernelState;
        if (this.isInitialized()) {
            return;
        }
        try {
            kernelState = (Kernel.State)this.callWrapper.call(() -> this.servicePortal.getState());
        }
        catch (Exception ex) {
            LOG.warn("Error getting the kernel state", (Throwable)ex);
            return;
        }
        Assertions.checkState((boolean)Kernel.State.OPERATING.equals((Object)kernelState), (String)"Cannot work in kernel state %s", (Object[])new Object[]{kernelState});
        this.peripheralEntryPool.initialize();
        this.detailPanel.initialize();
        EventQueue.invokeLater(() -> this.initPeripheralTable());
        this.initialized = true;
    }

    public void terminate() {
        if (!this.isInitialized()) {
            return;
        }
        this.detailPanel.terminate();
        this.peripheralEntryPool.terminate();
        this.initialized = false;
    }

    private void initPeripheralTable() {
        PeripheralTableModel model = new PeripheralTableModel(this.servicePortal, this.callWrapper);
        this.peripheralTable.setModel(model);
        this.peripheralTable.getColumnModel().getColumn(1).setCellRenderer((TableCellRenderer)new StringTableCellRenderer(description -> description.getDescription()));
        this.sorter = new TableRowSorter<PeripheralTableModel>(model);
        this.peripheralTable.setRowSorter(this.sorter);
        this.peripheralEntryPool.getEntries().forEach((location, entry) -> {
            model.addData((LocalPeripheralEntry)entry);
            entry.addPropertyChangeListener(model);
        });
        this.updateRowFilter();
    }

    private void updateRowFilter() {
        this.sorter.setRowFilter(RowFilter.andFilter(this.toRegexFilters()));
    }

    private List<RowFilter<PeripheralTableModel, Integer>> toRegexFilters() {
        ArrayList<RowFilter<PeripheralTableModel, Integer>> result = new ArrayList<RowFilter<PeripheralTableModel, Integer>>();
        result.add(RowFilter.regexFilter(".*", 1));
        if (this.hideDetachedLocationsCheckBox.isSelected()) {
            result.add(RowFilter.notFilter(RowFilter.regexFilter(NullPeripheralCommAdapterDescription.class.getSimpleName(), 1)));
        }
        return result;
    }

    private void initComponents() {
        this.listPanel = new JPanel();
        this.filterPanel = new JPanel();
        this.hideDetachedLocationsCheckBox = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.peripheralTable = new JTable();
        this.peripheralDetailsPanel = new JPanel();
        this.setLayout(new BoxLayout((Container)((Object)this), 2));
        this.listPanel.setBorder(BorderFactory.createTitledBorder("Peripheral devices in model"));
        this.listPanel.setMaximumSize(new Dimension(464, Integer.MAX_VALUE));
        this.listPanel.setMinimumSize(new Dimension(464, 425));
        this.listPanel.setPreferredSize(new Dimension(464, 424));
        this.listPanel.setLayout(new BorderLayout());
        this.filterPanel.setLayout(new FlowLayout(0));
        this.hideDetachedLocationsCheckBox.setSelected(true);
        ResourceBundle bundle = ResourceBundle.getBundle("i18n/org/opentcs/kernelcontrolcenter/Bundle");
        this.hideDetachedLocationsCheckBox.setText(bundle.getString("peripheralsPanel.checkBox_hideDetachedLocations.text"));
        this.hideDetachedLocationsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PeripheralsPanel.this.hideDetachedLocationsCheckBoxActionPerformed(evt);
            }
        });
        this.filterPanel.add(this.hideDetachedLocationsCheckBox);
        this.listPanel.add((Component)this.filterPanel, "North");
        this.peripheralTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PeripheralsPanel.this.peripheralTableMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.peripheralTable);
        this.listPanel.add((Component)this.jScrollPane1, "Center");
        this.add(this.listPanel);
        this.peripheralDetailsPanel.setBorder(BorderFactory.createTitledBorder("Peripheral details"));
        this.peripheralDetailsPanel.setPreferredSize(new Dimension(800, 23));
        this.peripheralDetailsPanel.setLayout(new BorderLayout());
        this.add(this.peripheralDetailsPanel);
        this.getAccessibleContext().setAccessibleName(bundle.getString("peripheralsPanel.accessibleName"));
    }

    private void peripheralTableMouseClicked(MouseEvent evt) {
        int index;
        if (evt.getClickCount() == 2 && (index = this.peripheralTable.getSelectedRow()) >= 0) {
            PeripheralTableModel model = (PeripheralTableModel)this.peripheralTable.getModel();
            LocalPeripheralEntry selectedEntry = model.getDataAt(this.peripheralTable.convertRowIndexToModel(index));
            this.detailPanel.attachToEntry(selectedEntry);
        }
    }

    private void hideDetachedLocationsCheckBoxActionPerformed(ActionEvent evt) {
        this.updateRowFilter();
    }
}

