/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernelcontrolcenter.vehicles;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.opentcs.access.Kernel;
import org.opentcs.access.KernelServicePortal;
import org.opentcs.components.kernelcontrolcenter.ControlCenterPanel;
import org.opentcs.customizations.ServiceCallWrapper;
import org.opentcs.data.model.Point;
import org.opentcs.drivers.vehicle.AdapterCommand;
import org.opentcs.drivers.vehicle.VehicleCommAdapterDescription;
import org.opentcs.drivers.vehicle.commands.InitPositionCommand;
import org.opentcs.drivers.vehicle.management.AttachmentInformation;
import org.opentcs.drivers.vehicle.management.VehicleProcessModelTO;
import org.opentcs.kernelcontrolcenter.vehicles.AdapterFactoryCellRenderer;
import org.opentcs.kernelcontrolcenter.vehicles.CommAdapterComboBox;
import org.opentcs.kernelcontrolcenter.vehicles.DetailPanel;
import org.opentcs.kernelcontrolcenter.vehicles.LocalVehicleEntry;
import org.opentcs.kernelcontrolcenter.vehicles.LocalVehicleEntryPool;
import org.opentcs.kernelcontrolcenter.vehicles.SingleCellEditor;
import org.opentcs.kernelcontrolcenter.vehicles.VehicleCommAdapterFactoryTableCellRenderer;
import org.opentcs.kernelcontrolcenter.vehicles.VehicleTableModel;
import org.opentcs.util.Assertions;
import org.opentcs.util.CallWrapper;
import org.opentcs.util.Comparators;
import org.opentcs.util.gui.BoundsPopupMenuListener;
import org.opentcs.util.gui.StringListCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DriverGUI
extends ControlCenterPanel {
    private static final Logger LOG = LoggerFactory.getLogger(DriverGUI.class);
    private final ResourceBundle bundle = ResourceBundle.getBundle("i18n/org/opentcs/kernelcontrolcenter/Bundle");
    private final KernelServicePortal servicePortal;
    private final CallWrapper callWrapper;
    private final LocalVehicleEntryPool vehicleEntryPool;
    private final DetailPanel detailPanel;
    private boolean initialized;
    private JMenuItem disableAllMenuItem;
    private JMenuItem disableAllSelectedMenuItem;
    private JMenu driverMenu;
    private JMenuItem enableAllMenuItem;
    private JMenuItem enableAllSelectedMenuItem;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator4;
    private JPanel listDisplayPanel;
    private JMenuItem noDriversMenuItem;
    private JPanel vehicleDetailPanel;
    private JPopupMenu vehicleListPopupMenu;
    private JTable vehicleTable;

    @Inject
    public DriverGUI(@Nonnull KernelServicePortal servicePortal, @Nonnull @ServiceCallWrapper CallWrapper callWrapper, @Nonnull LocalVehicleEntryPool vehicleEntryPool, @Nonnull DetailPanel detailPanel) {
        this.servicePortal = Objects.requireNonNull(servicePortal, "servicePortal");
        this.callWrapper = Objects.requireNonNull(callWrapper, "callWrapper");
        this.vehicleEntryPool = Objects.requireNonNull(vehicleEntryPool, "vehicleEntryPool");
        this.detailPanel = Objects.requireNonNull(detailPanel, "detailPanel");
        this.initComponents();
        this.vehicleTable.setDefaultRenderer(VehicleCommAdapterDescription.class, new VehicleCommAdapterFactoryTableCellRenderer());
        this.vehicleDetailPanel.add(detailPanel);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize() {
        Kernel.State kernelState;
        if (this.initialized) {
            LOG.debug("Already initialized.");
            return;
        }
        try {
            kernelState = (Kernel.State)this.callWrapper.call(() -> this.servicePortal.getState());
        }
        catch (Exception ex) {
            LOG.warn("Error getting the kernel state", (Throwable)ex);
            return;
        }
        Assertions.checkState((boolean)Kernel.State.OPERATING.equals((Object)kernelState), (String)"Cannot work in kernel state %s", (Object[])new Object[]{kernelState});
        this.vehicleEntryPool.initialize();
        this.detailPanel.initialize();
        EventQueue.invokeLater(() -> this.initVehicleList());
        this.initialized = true;
    }

    public void terminate() {
        if (!this.initialized) {
            LOG.debug("Not initialized.");
            return;
        }
        this.detailPanel.terminate();
        this.vehicleEntryPool.terminate();
        this.initialized = false;
    }

    private void initVehicleList() {
        this.vehicleTable.setModel(new VehicleTableModel(this.servicePortal.getVehicleService(), this.callWrapper));
        VehicleTableModel model = (VehicleTableModel)this.vehicleTable.getModel();
        this.vehicleEntryPool.getEntries().forEach((vehicleName, entry) -> {
            model.addData((LocalVehicleEntry)entry);
            entry.addPropertyChangeListener(model);
        });
        this.vehicleTable.getComponentPopupMenu().setEnabled(!model.getVehicleEntries().isEmpty());
        this.initAdapterComboBoxes();
    }

    private void initAdapterComboBoxes() {
        SingleCellEditor adapterCellEditor = new SingleCellEditor(this.vehicleTable);
        SingleCellEditor pointsCellEditor = new SingleCellEditor(this.vehicleTable);
        int index = 0;
        for (LocalVehicleEntry entry : this.vehicleEntryPool.getEntries().values()) {
            this.initCommAdaptersComboBox(entry, index, adapterCellEditor);
            this.initPointsComboBox(index, pointsCellEditor);
            ++index;
        }
        this.vehicleTable.getColumn(VehicleTableModel.adapterColumnIdentifier()).setCellEditor(adapterCellEditor);
        this.vehicleTable.getColumn(VehicleTableModel.positionColumnIdentifier()).setCellEditor(pointsCellEditor);
    }

    private void initCommAdaptersComboBox(LocalVehicleEntry vehicleEntry, int rowIndex, SingleCellEditor adapterCellEditor) {
        AttachmentInformation ai;
        CommAdapterComboBox comboBox = new CommAdapterComboBox();
        try {
            ai = (AttachmentInformation)this.callWrapper.call(() -> this.servicePortal.getVehicleService().fetchAttachmentInformation(vehicleEntry.getAttachmentInformation().getVehicleReference()));
        }
        catch (Exception ex) {
            LOG.warn("Error fetching attachment information for {}", (Object)vehicleEntry.getVehicleName(), (Object)ex);
            return;
        }
        ai.getAvailableCommAdapters().forEach(factory -> comboBox.addItem(factory));
        comboBox.setSelectedItem(vehicleEntry.getAttachmentInformation().getAttachedCommAdapter());
        comboBox.setRenderer(new AdapterFactoryCellRenderer());
        comboBox.addPopupMenuListener((PopupMenuListener)new BoundsPopupMenuListener());
        comboBox.addItemListener(evt -> {
            if (evt.getStateChange() == 2) {
                return;
            }
            if (Objects.equals(evt.getItem(), vehicleEntry.getAttachedCommAdapterDescription())) {
                LOG.debug("{} is already attached to: {}", (Object)vehicleEntry.getVehicleName(), evt.getItem());
                return;
            }
            int reply = JOptionPane.showConfirmDialog(null, this.bundle.getString("driverGui.optionPane_driverChangeConfirmation.message"), this.bundle.getString("driverGui.optionPane_driverChangeConfirmation.title"), 0);
            if (reply == 1) {
                return;
            }
            VehicleCommAdapterDescription factory = comboBox.getSelectedItem();
            try {
                this.callWrapper.call(() -> this.servicePortal.getVehicleService().attachCommAdapter(vehicleEntry.getAttachmentInformation().getVehicleReference(), factory));
            }
            catch (Exception ex) {
                LOG.warn("Error attaching adapter {} to vehicle {}", new Object[]{factory, vehicleEntry.getVehicleName(), ex});
                return;
            }
            LOG.info("Attaching comm adapter {} to {}", (Object)factory, (Object)vehicleEntry.getVehicleName());
        });
        adapterCellEditor.setEditorAt(rowIndex, new DefaultCellEditor(comboBox));
        vehicleEntry.addPropertyChangeListener(comboBox);
    }

    private void initPointsComboBox(int rowIndex, SingleCellEditor pointsCellEditor) {
        Set points;
        JComboBox pointComboBox = new JComboBox();
        try {
            points = (Set)this.callWrapper.call(() -> this.servicePortal.getVehicleService().fetchObjects(Point.class));
        }
        catch (Exception ex) {
            LOG.warn("Error fetching points", (Throwable)ex);
            return;
        }
        points.stream().sorted(Comparators.objectsByName()).forEach(point -> pointComboBox.addItem(point));
        pointComboBox.setSelectedIndex(-1);
        pointComboBox.setRenderer(new StringListCellRenderer(x -> x == null ? "" : x.getName()));
        pointComboBox.addItemListener(e -> {
            try {
                if (e.getStateChange() == 1) {
                    Point newPoint = (Point)e.getItem();
                    LocalVehicleEntry vehicleEntry = this.vehicleEntryPool.getEntryFor(this.getSelectedVehicleName());
                    if (vehicleEntry.getAttachedCommAdapterDescription().isSimVehicleCommAdapter()) {
                        this.callWrapper.call(() -> this.servicePortal.getVehicleService().sendCommAdapterCommand(vehicleEntry.getAttachmentInformation().getVehicleReference(), (AdapterCommand)new InitPositionCommand(newPoint.getName())));
                    } else {
                        LOG.debug("Vehicle {}: Not a simulation adapter -> not setting initial position.", (Object)vehicleEntry.getVehicleName());
                    }
                }
            }
            catch (Exception ex) {
                LOG.warn("Error sending init position command", (Throwable)ex);
            }
        });
        pointsCellEditor.setEditorAt(rowIndex, new DefaultCellEditor(pointComboBox));
    }

    private void enableAllCommAdapters() {
        this.enableCommAdapters(this.vehicleEntryPool.getEntries().values());
    }

    private void enableSelectedCommAdapters() {
        this.enableCommAdapters(this.getSelectedVehicleEntries());
    }

    private void enableCommAdapters(Collection<LocalVehicleEntry> selectedEntries) {
        Collection entries = selectedEntries.stream().filter(entry -> !entry.getProcessModel().isCommAdapterEnabled()).collect(Collectors.toList());
        try {
            for (LocalVehicleEntry entry2 : entries) {
                this.callWrapper.call(() -> this.servicePortal.getVehicleService().enableCommAdapter(entry2.getAttachmentInformation().getVehicleReference()));
            }
        }
        catch (Exception ex) {
            LOG.warn("Error enabling comm adapter, canceling", (Throwable)ex);
        }
    }

    private void disableAllCommAdapters() {
        this.disableCommAdapters(this.vehicleEntryPool.getEntries().values());
    }

    private void disableSelectedCommAdapters() {
        this.disableCommAdapters(this.getSelectedVehicleEntries());
    }

    private void disableCommAdapters(Collection<LocalVehicleEntry> selectedEntries) {
        Collection entries = selectedEntries.stream().filter(entry -> entry.getProcessModel().isCommAdapterEnabled()).collect(Collectors.toList());
        try {
            for (LocalVehicleEntry entry2 : entries) {
                this.callWrapper.call(() -> this.servicePortal.getVehicleService().disableCommAdapter(entry2.getAttachmentInformation().getVehicleReference()));
            }
        }
        catch (Exception ex) {
            LOG.warn("Error disabling comm adapter, canceling", (Throwable)ex);
        }
    }

    private String getSelectedVehicleName() {
        VehicleTableModel model = (VehicleTableModel)this.vehicleTable.getModel();
        return model.getDataAt(this.vehicleTable.getSelectedRow()).getVehicleName();
    }

    private List<String> getSelectedVehicleNames() {
        ArrayList<String> selectedVehicleNames = new ArrayList<String>();
        VehicleTableModel model = (VehicleTableModel)this.vehicleTable.getModel();
        for (int selectedRow : this.vehicleTable.getSelectedRows()) {
            String selectedVehicleName = model.getDataAt(selectedRow).getVehicleName();
            selectedVehicleNames.add(selectedVehicleName);
        }
        return selectedVehicleNames;
    }

    private List<LocalVehicleEntry> getSelectedVehicleEntries() {
        ArrayList<LocalVehicleEntry> selectedEntries = new ArrayList<LocalVehicleEntry>();
        for (String selectedVehicleName : this.getSelectedVehicleNames()) {
            selectedEntries.add(this.vehicleEntryPool.getEntryFor(selectedVehicleName));
        }
        return selectedEntries;
    }

    private void createDriverMenu() {
        this.driverMenu.removeAll();
        HashSet availableDescriptions = new HashSet();
        this.vehicleEntryPool.getEntries().forEach((vehicleName, entry) -> availableDescriptions.addAll(entry.getAttachmentInformation().getAvailableCommAdapters()));
        for (VehicleCommAdapterDescription description : availableDescriptions) {
            boolean factorySupportsSelectedVehicles = this.getSelectedVehicleEntries().stream().map(entry -> entry.getAttachmentInformation().getAvailableCommAdapters()).allMatch(descriptions -> !Collections.disjoint(descriptions, availableDescriptions));
            ArrayList<String> vehiclesToAttach = new ArrayList();
            if (factorySupportsSelectedVehicles) {
                vehiclesToAttach = this.getSelectedVehicleNames();
            }
            AttachCommAdapterAction action = new AttachCommAdapterAction(vehiclesToAttach, description);
            JMenuItem menuItem = this.driverMenu.add(action);
            menuItem.setEnabled(!vehiclesToAttach.isEmpty());
        }
    }

    private void createPopupMenu() {
        StatesCounts stateCounts = this.getCommAdapterStateCountsFor(this.vehicleEntryPool.getEntries().values());
        this.enableAllMenuItem.setEnabled(stateCounts.disabledCount > 0);
        this.disableAllMenuItem.setEnabled(stateCounts.enabledCount > 0);
        stateCounts = this.getCommAdapterStateCountsFor(this.getSelectedVehicleEntries());
        this.enableAllSelectedMenuItem.setEnabled(stateCounts.disabledCount > 0);
        this.disableAllSelectedMenuItem.setEnabled(stateCounts.enabledCount > 0);
    }

    private StatesCounts getCommAdapterStateCountsFor(Collection<LocalVehicleEntry> entries) {
        StatesCounts stateCounts = new StatesCounts();
        for (LocalVehicleEntry entry : entries) {
            VehicleProcessModelTO processModel = entry.getProcessModel();
            if (processModel.isCommAdapterEnabled()) {
                ++stateCounts.enabledCount;
                continue;
            }
            ++stateCounts.disabledCount;
        }
        return stateCounts;
    }

    private void initComponents() {
        this.vehicleListPopupMenu = new JPopupMenu();
        this.driverMenu = new JMenu();
        this.noDriversMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.enableAllMenuItem = new JMenuItem();
        this.enableAllSelectedMenuItem = new JMenuItem();
        this.jSeparator4 = new JSeparator();
        this.disableAllMenuItem = new JMenuItem();
        this.disableAllSelectedMenuItem = new JMenuItem();
        this.listDisplayPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.vehicleTable = new JTable();
        this.vehicleDetailPanel = new JPanel();
        this.vehicleListPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                DriverGUI.this.vehicleListPopupMenuPopupMenuWillBecomeVisible(evt);
            }
        });
        ResourceBundle bundle = ResourceBundle.getBundle("i18n/org/opentcs/kernelcontrolcenter/Bundle");
        this.driverMenu.setText(bundle.getString("driverGui.popupMenu_vehicles.subMenu_driver.text"));
        this.driverMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuCanceled(MenuEvent evt) {
            }

            @Override
            public void menuDeselected(MenuEvent evt) {
            }

            @Override
            public void menuSelected(MenuEvent evt) {
                DriverGUI.this.driverMenuMenuSelected(evt);
            }
        });
        this.noDriversMenuItem.setText("No drivers available.");
        this.noDriversMenuItem.setEnabled(false);
        this.driverMenu.add(this.noDriversMenuItem);
        this.vehicleListPopupMenu.add(this.driverMenu);
        this.vehicleListPopupMenu.add(this.jSeparator1);
        this.enableAllMenuItem.setText(bundle.getString("driverGui.popupMenu_vehicles.menuItem_enableAll.text"));
        this.enableAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DriverGUI.this.enableAllMenuItemActionPerformed(evt);
            }
        });
        this.vehicleListPopupMenu.add(this.enableAllMenuItem);
        this.enableAllSelectedMenuItem.setText(bundle.getString("driverGui.popupMenu_vehicles.menuItem_enableSelected.text"));
        this.enableAllSelectedMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DriverGUI.this.enableAllSelectedMenuItemActionPerformed(evt);
            }
        });
        this.vehicleListPopupMenu.add(this.enableAllSelectedMenuItem);
        this.vehicleListPopupMenu.add(this.jSeparator4);
        this.disableAllMenuItem.setText(bundle.getString("driverGui.popupMenu_vehicles.menuItem_disableAll.text"));
        this.disableAllMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DriverGUI.this.disableAllMenuItemActionPerformed(evt);
            }
        });
        this.vehicleListPopupMenu.add(this.disableAllMenuItem);
        this.disableAllSelectedMenuItem.setText(bundle.getString("driverGui.popupMenu_vehicles.menuItem_disableSelected.text"));
        this.disableAllSelectedMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DriverGUI.this.disableAllSelectedMenuItemActionPerformed(evt);
            }
        });
        this.vehicleListPopupMenu.add(this.disableAllSelectedMenuItem);
        this.setLayout(new BoxLayout((Container)((Object)this), 0));
        this.listDisplayPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("driverGui.panel_vehicles.border.title")));
        this.listDisplayPanel.setMaximumSize(new Dimension(464, Integer.MAX_VALUE));
        this.listDisplayPanel.setMinimumSize(new Dimension(464, 425));
        this.listDisplayPanel.setLayout(new BorderLayout());
        this.vehicleTable.setComponentPopupMenu(this.vehicleListPopupMenu);
        this.vehicleTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DriverGUI.this.vehicleTableMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.vehicleTable);
        this.listDisplayPanel.add((Component)this.jScrollPane1, "Center");
        this.add(this.listDisplayPanel);
        this.vehicleDetailPanel.setBorder(BorderFactory.createTitledBorder(bundle.getString("driverGui.panel_vehicleDetails.border.title")));
        this.vehicleDetailPanel.setPreferredSize(new Dimension(800, 23));
        this.vehicleDetailPanel.setLayout(new BorderLayout());
        this.add(this.vehicleDetailPanel);
        this.vehicleDetailPanel.getAccessibleContext().setAccessibleName(bundle.getString("driverGui.panel_vehicleDetails.accessibleName"));
        this.getAccessibleContext().setAccessibleName(bundle.getString("driverGui.accessibleName"));
    }

    private void driverMenuMenuSelected(MenuEvent evt) {
        this.createDriverMenu();
    }

    private void enableAllMenuItemActionPerformed(ActionEvent evt) {
        this.enableAllCommAdapters();
    }

    private void enableAllSelectedMenuItemActionPerformed(ActionEvent evt) {
        this.enableSelectedCommAdapters();
    }

    private void disableAllMenuItemActionPerformed(ActionEvent evt) {
        this.disableAllCommAdapters();
    }

    private void disableAllSelectedMenuItemActionPerformed(ActionEvent evt) {
        this.disableSelectedCommAdapters();
    }

    private void vehicleListPopupMenuPopupMenuWillBecomeVisible(PopupMenuEvent evt) {
        this.createPopupMenu();
    }

    private void vehicleTableMouseClicked(MouseEvent evt) {
        int index;
        if (evt.getClickCount() == 2 && (index = this.vehicleTable.getSelectedRow()) >= 0) {
            VehicleTableModel model = (VehicleTableModel)this.vehicleTable.getModel();
            LocalVehicleEntry clickedEntry = model.getDataAt(index);
            DetailPanel detailPanel = (DetailPanel)this.vehicleDetailPanel.getComponent(0);
            detailPanel.attachToVehicle(clickedEntry);
        }
    }

    private class AttachCommAdapterAction
    extends AbstractAction {
        private final List<String> vehicleNames;
        private final VehicleCommAdapterDescription commAdapterDescription;

        private AttachCommAdapterAction(List<String> vehicleNames, VehicleCommAdapterDescription commAdapterDescription) {
            super(commAdapterDescription.getDescription());
            this.vehicleNames = Objects.requireNonNull(vehicleNames, "vehicleNames");
            this.commAdapterDescription = Objects.requireNonNull(commAdapterDescription, "factory");
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            for (String vehicleName : this.vehicleNames) {
                DriverGUI.this.servicePortal.getVehicleService().attachCommAdapter(DriverGUI.this.vehicleEntryPool.getEntryFor(vehicleName).getAttachmentInformation().getVehicleReference(), this.commAdapterDescription);
            }
        }
    }

    private class StatesCounts {
        private int enabledCount;
        private int disabledCount;

        StatesCounts() {
        }
    }
}

