/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernelcontrolcenter.vehicles;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.opentcs.drivers.vehicle.VehicleCommAdapterDescription;
import org.opentcs.drivers.vehicle.management.AttachmentInformation;
import org.opentcs.drivers.vehicle.management.VehicleProcessModelTO;

public class LocalVehicleEntry {
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private AttachmentInformation attachmentInformation;
    private VehicleProcessModelTO processModel;

    public LocalVehicleEntry(AttachmentInformation attachmentInformation, VehicleProcessModelTO processModel) {
        this.attachmentInformation = Objects.requireNonNull(attachmentInformation, "attachmentInformation");
        this.processModel = Objects.requireNonNull(processModel, "processModel");
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    @Nonnull
    public AttachmentInformation getAttachmentInformation() {
        return this.attachmentInformation;
    }

    @Nonnull
    public VehicleProcessModelTO getProcessModel() {
        return this.processModel;
    }

    @Nonnull
    public String getVehicleName() {
        return this.attachmentInformation.getVehicleReference().getName();
    }

    @Nonnull
    public VehicleCommAdapterDescription getAttachedCommAdapterDescription() {
        return this.attachmentInformation.getAttachedCommAdapter();
    }

    public void setAttachmentInformation(@Nonnull AttachmentInformation attachmentInformation) {
        AttachmentInformation oldAttachmentInformation = this.attachmentInformation;
        this.attachmentInformation = Objects.requireNonNull(attachmentInformation, "attachmentInformation");
        this.pcs.firePropertyChange(Attribute.ATTACHMENT_INFORMATION.name(), oldAttachmentInformation, attachmentInformation);
    }

    public void setProcessModel(@Nonnull VehicleProcessModelTO processModel) {
        VehicleProcessModelTO oldProcessModel = this.processModel;
        this.processModel = Objects.requireNonNull(processModel, "processModel");
        this.pcs.firePropertyChange(Attribute.PROCESS_MODEL.name(), oldProcessModel, processModel);
    }

    public static enum Attribute {
        PROCESS_MODEL,
        ATTACHMENT_INFORMATION;

    }
}

