/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.kernelcontrolcenter.vehicles;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.table.AbstractTableModel;
import org.opentcs.data.notification.UserNotification;

final class LogTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_NAMES = new String[]{ResourceBundle.getBundle("i18n/org/opentcs/kernelcontrolcenter/Bundle").getString("logTableModel.column_timeStamp.headerText"), ResourceBundle.getBundle("i18n/org/opentcs/kernelcontrolcenter/Bundle").getString("logTableModel.column_message.headerText")};
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{String.class, String.class};
    private final DateTimeFormatter dateFormat = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());
    private final Set<UserNotification> values = new TreeSet<UserNotification>((n1, n2) -> n1.getTimestamp().compareTo(n2.getTimestamp()));
    private List<UserNotification> filteredValues = new ArrayList<UserNotification>();
    private Predicate<UserNotification> filterPredicate = notification -> true;

    LogTableModel() {
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < 0 || row >= this.filteredValues.size()) {
            return null;
        }
        switch (column) {
            case 0: {
                return this.dateFormat.format(this.filteredValues.get(row).getTimestamp());
            }
            case 1: {
                return this.filteredValues.get(row).getText();
            }
        }
        return new IllegalArgumentException("Column out of bounds.");
    }

    public void addRow(UserNotification notification) {
        Objects.requireNonNull(notification, "notification");
        this.values.add(notification);
        this.updateFilteredValues();
        this.fireTableDataChanged();
    }

    public void removeRow(UserNotification notification) {
        if (this.values.contains(notification)) {
            this.values.remove(notification);
            this.updateFilteredValues();
            this.fireTableDataChanged();
        }
    }

    public void clear() {
        if (!this.values.isEmpty()) {
            this.values.clear();
            this.updateFilteredValues();
            this.fireTableDataChanged();
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_CLASSES[columnIndex];
    }

    public UserNotification getRow(int row) {
        return this.filteredValues.get(row);
    }

    public void filterMessages(Predicate<UserNotification> predicate) {
        this.filterPredicate = Objects.requireNonNull(predicate, "predicate");
        this.updateFilteredValues();
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.filteredValues.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int columnIndex) {
        try {
            return COLUMN_NAMES[columnIndex];
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            return "ERROR";
        }
    }

    private void updateFilteredValues() {
        this.filteredValues = this.values.stream().filter(this.filterPredicate).collect(Collectors.toList());
    }
}

