/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing;

import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.io.File;
import java.util.List;
import java.util.Locale;
import javax.inject.Singleton;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.opentcs.access.KernelServicePortal;
import org.opentcs.access.SslParameterSet;
import org.opentcs.access.rmi.KernelServicePortalBuilder;
import org.opentcs.access.rmi.factories.NullSocketFactoryProvider;
import org.opentcs.access.rmi.factories.SecureSocketFactoryProvider;
import org.opentcs.access.rmi.factories.SocketFactoryProvider;
import org.opentcs.components.plantoverview.LocationTheme;
import org.opentcs.customizations.ApplicationHome;
import org.opentcs.customizations.plantoverview.PlantOverviewInjectionModule;
import org.opentcs.drivers.LowLevelCommunicationEvent;
import org.opentcs.guing.application.ApplicationInjectionModule;
import org.opentcs.guing.components.ComponentsInjectionModule;
import org.opentcs.guing.exchange.ExchangeInjectionModule;
import org.opentcs.guing.exchange.SslConfiguration;
import org.opentcs.guing.model.ModelInjectionModule;
import org.opentcs.guing.persistence.DefaultPersistenceInjectionModule;
import org.opentcs.guing.transport.TransportInjectionModule;
import org.opentcs.guing.util.ElementNamingSchemeConfiguration;
import org.opentcs.guing.util.PlantOverviewApplicationConfiguration;
import org.opentcs.guing.util.PlantOverviewModelingApplicationConfiguration;
import org.opentcs.guing.util.UtilInjectionModule;
import org.opentcs.util.ClassMatcher;
import org.opentcs.util.gui.dialog.ConnectionParamSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPlantOverviewInjectionModule
extends PlantOverviewInjectionModule {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultPlantOverviewInjectionModule.class);

    protected void configure() {
        File applicationHome = new File(System.getProperty("opentcs.home", "."));
        this.bind(File.class).annotatedWith(ApplicationHome.class).toInstance((Object)applicationHome);
        this.configurePlantOverviewDependencies();
        this.install((Module)new ApplicationInjectionModule());
        this.install((Module)new ComponentsInjectionModule());
        this.install((Module)new ExchangeInjectionModule());
        this.install((Module)new ModelInjectionModule());
        this.install((Module)new DefaultPersistenceInjectionModule());
        this.install((Module)new TransportInjectionModule());
        this.install((Module)new UtilInjectionModule());
        this.pluggablePanelFactoryBinder();
        this.objectHistoryEntryFormatterBinder();
    }

    private void configurePlantOverviewDependencies() {
        PlantOverviewApplicationConfiguration baseConfiguration = (PlantOverviewApplicationConfiguration)this.getConfigBindingProvider().get("plantoverviewapp", PlantOverviewApplicationConfiguration.class);
        PlantOverviewModelingApplicationConfiguration configuration = (PlantOverviewModelingApplicationConfiguration)this.getConfigBindingProvider().get("plantoverviewapp", PlantOverviewModelingApplicationConfiguration.class);
        this.bind(PlantOverviewApplicationConfiguration.class).toInstance((Object)baseConfiguration);
        this.bind(PlantOverviewModelingApplicationConfiguration.class).toInstance((Object)configuration);
        this.configurePlantOverview(configuration);
        this.configureThemes(configuration);
        this.configureSocketConnections();
        this.configureNamingConfiguration();
        this.bind((TypeLiteral)new TypeLiteral<List<ConnectionParamSet>>(){}).toInstance((Object)baseConfiguration.connectionBookmarks());
    }

    private void configureNamingConfiguration() {
        ElementNamingSchemeConfiguration configuration = (ElementNamingSchemeConfiguration)this.getConfigBindingProvider().get("elementnamingscheme", ElementNamingSchemeConfiguration.class);
        this.bind(ElementNamingSchemeConfiguration.class).toInstance((Object)configuration);
    }

    private void configureSocketConnections() {
        SecureSocketFactoryProvider socketFactoryProvider;
        SslConfiguration sslConfiguration = (SslConfiguration)this.getConfigBindingProvider().get("ssl", SslConfiguration.class);
        SslParameterSet sslParamSet = new SslParameterSet("PKCS12", null, null, new File(sslConfiguration.truststoreFile()), sslConfiguration.truststorePassword());
        this.bind(SslParameterSet.class).toInstance((Object)sslParamSet);
        if (sslConfiguration.enable()) {
            socketFactoryProvider = new SecureSocketFactoryProvider(sslParamSet);
        } else {
            LOG.warn("SSL encryption disabled, connections will not be secured!");
            socketFactoryProvider = new NullSocketFactoryProvider();
        }
        this.bind(KernelServicePortal.class).toInstance((Object)new KernelServicePortalBuilder("Alice", "xyz").setSocketFactoryProvider((SocketFactoryProvider)socketFactoryProvider).setEventFilter(new ClassMatcher(new Class[]{LowLevelCommunicationEvent.class}).negate()).build());
    }

    private void configureThemes(PlantOverviewModelingApplicationConfiguration configuration) {
        this.bind(LocationTheme.class).to(configuration.locationThemeClass()).in(Singleton.class);
    }

    private void configurePlantOverview(PlantOverviewModelingApplicationConfiguration configuration) {
        Locale.setDefault(Locale.forLanguageTag(configuration.locale()));
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException ex) {
            LOG.warn("Could not set look-and-feel", (Throwable)ex);
        }
        ToolTipManager.sharedInstance().setDismissDelay(30000);
    }
}

