/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.application;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.event.CFocusListener;
import bibliothek.gui.dock.common.event.CVetoClosingEvent;
import bibliothek.gui.dock.common.event.CVetoClosingListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.event.UndoableEditListener;
import org.jhotdraw.app.AbstractView;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.gui.URIChooser;
import org.jhotdraw.util.ReversedList;
import org.opentcs.access.Kernel;
import org.opentcs.access.KernelRuntimeException;
import org.opentcs.access.KernelServicePortal;
import org.opentcs.access.SharedKernelServicePortal;
import org.opentcs.access.SharedKernelServicePortalProvider;
import org.opentcs.components.kernel.services.ServiceUnavailableException;
import org.opentcs.components.plantoverview.PlantModelExporter;
import org.opentcs.components.plantoverview.PlantModelImporter;
import org.opentcs.components.plantoverview.PluggablePanel;
import org.opentcs.components.plantoverview.PluggablePanelFactory;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.customizations.plantoverview.ApplicationFrame;
import org.opentcs.guing.application.ApplicationState;
import org.opentcs.guing.application.ComponentsManager;
import org.opentcs.guing.application.GuiManager;
import org.opentcs.guing.application.ModelRestorationProgressStatus;
import org.opentcs.guing.application.OperationMode;
import org.opentcs.guing.application.PluginPanelManager;
import org.opentcs.guing.application.ProgressIndicator;
import org.opentcs.guing.application.ProgressStatus;
import org.opentcs.guing.application.StartupProgressStatus;
import org.opentcs.guing.application.StatusPanel;
import org.opentcs.guing.application.ViewManagerModeling;
import org.opentcs.guing.application.action.ToolBarManager;
import org.opentcs.guing.application.action.ViewActionMap;
import org.opentcs.guing.components.dockable.CStackDockStation;
import org.opentcs.guing.components.dockable.DockingManagerModeling;
import org.opentcs.guing.components.dockable.DrawingViewFocusHandler;
import org.opentcs.guing.components.drawing.DrawingViewFactory;
import org.opentcs.guing.components.drawing.DrawingViewScrollPane;
import org.opentcs.guing.components.drawing.OpenTCSDrawingEditor;
import org.opentcs.guing.components.drawing.OpenTCSDrawingView;
import org.opentcs.guing.components.drawing.course.Origin;
import org.opentcs.guing.components.drawing.course.OriginChangeListener;
import org.opentcs.guing.components.drawing.figures.FigureConstants;
import org.opentcs.guing.components.drawing.figures.LabeledFigure;
import org.opentcs.guing.components.drawing.figures.SimpleLineConnection;
import org.opentcs.guing.components.drawing.figures.TCSFigure;
import org.opentcs.guing.components.layer.LayerEditorEventHandler;
import org.opentcs.guing.components.layer.LayerManager;
import org.opentcs.guing.components.properties.AttributesContent;
import org.opentcs.guing.components.properties.SelectionPropertiesComponent;
import org.opentcs.guing.components.properties.event.AttributesChangeEvent;
import org.opentcs.guing.components.properties.event.AttributesChangeListener;
import org.opentcs.guing.components.properties.panel.PropertiesPanelFactory;
import org.opentcs.guing.components.properties.type.AbstractProperty;
import org.opentcs.guing.components.properties.type.LengthProperty;
import org.opentcs.guing.components.tree.BlocksTreeViewManager;
import org.opentcs.guing.components.tree.ComponentsTreeViewManager;
import org.opentcs.guing.components.tree.TreeViewManager;
import org.opentcs.guing.components.tree.elements.ContextObject;
import org.opentcs.guing.components.tree.elements.UserObject;
import org.opentcs.guing.components.tree.elements.UserObjectContext;
import org.opentcs.guing.components.tree.elements.UserObjectUtil;
import org.opentcs.guing.event.BlockChangeEvent;
import org.opentcs.guing.event.BlockChangeListener;
import org.opentcs.guing.event.DrawingEditorEvent;
import org.opentcs.guing.event.DrawingEditorListener;
import org.opentcs.guing.event.ModelNameChangeEvent;
import org.opentcs.guing.event.OperationModeChangeEvent;
import org.opentcs.guing.event.ResetInteractionToolCommand;
import org.opentcs.guing.event.SystemModelTransitionEvent;
import org.opentcs.guing.model.ModelComponent;
import org.opentcs.guing.model.PropertiesCollection;
import org.opentcs.guing.model.SystemModel;
import org.opentcs.guing.model.elements.BlockModel;
import org.opentcs.guing.model.elements.LayoutModel;
import org.opentcs.guing.model.elements.LinkModel;
import org.opentcs.guing.model.elements.LocationModel;
import org.opentcs.guing.model.elements.LocationTypeModel;
import org.opentcs.guing.model.elements.PathModel;
import org.opentcs.guing.model.elements.PointModel;
import org.opentcs.guing.model.elements.VehicleModel;
import org.opentcs.guing.persistence.ModelManager;
import org.opentcs.guing.persistence.ModelManagerModeling;
import org.opentcs.guing.util.Colors;
import org.opentcs.guing.util.ModelComponentFactory;
import org.opentcs.guing.util.PanelRegistry;
import org.opentcs.guing.util.UniqueNameGenerator;
import org.opentcs.guing.util.UserMessageHelper;
import org.opentcs.thirdparty.jhotdraw.application.action.edit.UndoRedoManager;
import org.opentcs.thirdparty.jhotdraw.application.action.file.CloseFileAction;
import org.opentcs.thirdparty.jhotdraw.application.toolbar.PaletteToolBarBorder;
import org.opentcs.thirdparty.jhotdraw.components.drawing.OpenTCSDrawingViewModeling;
import org.opentcs.thirdparty.jhotdraw.util.ResourceBundleUtil;
import org.opentcs.util.event.EventBus;
import org.opentcs.util.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTCSView
extends AbstractView
implements GuiManager,
ComponentsManager,
PluginPanelManager,
EventHandler {
    public static final String NAME = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.modeling.miscellaneous").getString("openTcsView.applicationName.text");
    public static final String MODELNAME_PROPERTY = "modelName";
    private static final Logger LOG = LoggerFactory.getLogger(OpenTCSView.class);
    private final ResourceBundleUtil bundle = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.modeling.miscellaneous");
    private final ApplicationState appState;
    private final UndoRedoManager fUndoRedoManager;
    private final OpenTCSDrawingEditor fDrawingEditor;
    private final JFrame fFrame;
    private final ViewManagerModeling viewManager;
    private final TreeViewManager fComponentsTreeManager;
    private final TreeViewManager fBlocksTreeManager;
    private final SelectionPropertiesComponent fPropertiesComponent;
    private final ModelManagerModeling fModelManager;
    private final ProgressIndicator progressIndicator;
    private final DockingManagerModeling dockingManager;
    private final PanelRegistry panelRegistry;
    private final SharedKernelServicePortalProvider portalProvider;
    private final StatusPanel statusPanel;
    private final ModelComponentFactory modelComponentFactory;
    private final UserMessageHelper userMessageHelper;
    private final DrawingViewFactory drawingViewFactory;
    private final BlockChangeListener blockEventHandler = new BlockEventHandler();
    private final AttributesChangeListener attributesEventHandler = new AttributesEventHandler();
    private final UniqueNameGenerator modelCompNameGen;
    private final UserObjectUtil userObjectUtil;
    private final Provider<ViewActionMap> actionMapProvider;
    private final Provider<ToolBarManager> toolBarManagerProvider;
    private final PropertiesPanelFactory propertiesPanelFactory;
    private final EventBus eventBus;
    private final DrawingViewFocusHandler drawingViewFocusHandler;
    private final LayerManager layerManager;
    private final LayerEditorEventHandler layerEditorEventHandler;
    private ToolBarManager toolBarManager;

    @Inject
    public OpenTCSView(ApplicationState appState, @ApplicationFrame JFrame appFrame, ProgressIndicator progressIndicator, SharedKernelServicePortalProvider portalProvider, ViewManagerModeling viewManager, OpenTCSDrawingEditor tcsDrawingEditor, ModelManagerModeling modelManager, StatusPanel statusPanel, PanelRegistry panelRegistry, ModelComponentFactory modelComponentFactory, UserMessageHelper userMessageHelper, DrawingViewFactory drawingViewFactory, UniqueNameGenerator modelCompNameGen, UndoRedoManager undoRedoManager, ComponentsTreeViewManager componentsTreeManager, BlocksTreeViewManager blocksTreeManager, SelectionPropertiesComponent propertiesComponent, UserObjectUtil userObjectUtil, Provider<ViewActionMap> actionMapProvider, Provider<ToolBarManager> toolBarManagerProvider, PropertiesPanelFactory propertiesPanelFactory, @ApplicationEventBus EventBus eventBus, DockingManagerModeling dockingManager, DrawingViewFocusHandler drawingViewFocusHandler, LayerManager layerManager, LayerEditorEventHandler layerEditorEventHandler) {
        this.appState = Objects.requireNonNull(appState, "appState");
        this.fFrame = Objects.requireNonNull(appFrame, "appFrame");
        this.progressIndicator = Objects.requireNonNull(progressIndicator, "progressIndicator");
        this.portalProvider = Objects.requireNonNull(portalProvider, "portalProvider");
        this.viewManager = Objects.requireNonNull(viewManager, "viewManager");
        this.fDrawingEditor = Objects.requireNonNull(tcsDrawingEditor, "tcsDrawingEditor");
        this.fModelManager = Objects.requireNonNull(modelManager, "modelManager");
        this.statusPanel = Objects.requireNonNull(statusPanel, "statusPanel");
        this.panelRegistry = Objects.requireNonNull(panelRegistry, "panelRegistry");
        this.modelComponentFactory = Objects.requireNonNull(modelComponentFactory, "modelComponentFactory");
        this.userMessageHelper = Objects.requireNonNull(userMessageHelper, "userMessageHelper");
        this.drawingViewFactory = Objects.requireNonNull(drawingViewFactory, "drawingViewFactory");
        this.modelCompNameGen = Objects.requireNonNull(modelCompNameGen, "modelCompNameGen");
        this.fUndoRedoManager = Objects.requireNonNull(undoRedoManager, "undoRedoManager");
        this.fComponentsTreeManager = (TreeViewManager)Objects.requireNonNull(componentsTreeManager, "componentsTreeManager");
        this.fBlocksTreeManager = (TreeViewManager)Objects.requireNonNull(blocksTreeManager, "blocksTreeManager");
        this.fPropertiesComponent = Objects.requireNonNull(propertiesComponent, "propertiesComponent");
        this.userObjectUtil = Objects.requireNonNull(userObjectUtil, "userObjectUtil");
        this.actionMapProvider = Objects.requireNonNull(actionMapProvider, "actionMapProvider");
        this.toolBarManagerProvider = Objects.requireNonNull(toolBarManagerProvider, "toolBarManagerProvider");
        this.propertiesPanelFactory = Objects.requireNonNull(propertiesPanelFactory, "propertiesPanelFactory");
        this.eventBus = Objects.requireNonNull(eventBus, "eventBus");
        this.dockingManager = Objects.requireNonNull(dockingManager, "dockingManager");
        this.drawingViewFocusHandler = Objects.requireNonNull(drawingViewFocusHandler, "drawingViewFocusHandler");
        this.layerManager = Objects.requireNonNull(layerManager, "layerManager");
        this.layerEditorEventHandler = Objects.requireNonNull(layerEditorEventHandler, "layerEditorEventHandler");
    }

    public void init() {
        this.eventBus.subscribe((EventHandler)this);
        this.progressIndicator.setProgress((ProgressStatus)StartupProgressStatus.INITIALIZED);
        this.fDrawingEditor.addDrawingEditorListener((DrawingEditorListener)this.layerEditorEventHandler);
        this.fDrawingEditor.addDrawingEditorListener((DrawingEditorListener)new DrawingEditorEventHandler(this.fModelManager));
        this.eventBus.subscribe((EventHandler)this.fComponentsTreeManager);
        this.progressIndicator.setProgress((ProgressStatus)StartupProgressStatus.INITIALIZE_MODEL);
        this.setSystemModel(this.fModelManager.getModel());
        this.fPropertiesComponent.setPropertiesContent((AttributesContent)this.propertiesPanelFactory.createPropertiesTableContent((JPanel)((Object)this)));
        this.setActionMap((ActionMap)this.actionMapProvider.get());
        this.toolBarManager = (ToolBarManager)this.toolBarManagerProvider.get();
        this.eventBus.subscribe((EventHandler)this.toolBarManager);
        this.eventBus.subscribe((EventHandler)this.fPropertiesComponent);
        this.eventBus.subscribe((EventHandler)this.fUndoRedoManager);
        this.eventBus.subscribe((EventHandler)this.fDrawingEditor);
        this.layerManager.initialize();
        this.initializeFrame();
        this.viewManager.init();
        this.createEmptyModel();
        this.setModelingState();
    }

    public void stop() {
        LOG.info("GUI terminating...");
        this.eventBus.unsubscribe((EventHandler)this);
        System.exit(0);
    }

    public void clear() {
    }

    public void onEvent(Object event) {
        if (event instanceof SystemModelTransitionEvent) {
            this.handleSystemModelTransition((SystemModelTransitionEvent)event);
        }
    }

    private void handleSystemModelTransition(SystemModelTransitionEvent evt) {
        switch (evt.getStage()) {
            case LOADED: {
                this.setHasUnsavedChanges(false);
                this.setModelNameProperty(this.fModelManager.getModel().getName());
                break;
            }
        }
    }

    public void showPluginPanel(PluggablePanelFactory factory, boolean visible) {
        PluggablePanel panel;
        String id = factory.getClass().getName();
        SingleCDockable dockable = this.dockingManager.getCControl().getSingleDockable(id);
        if (dockable != null) {
            panel = (PluggablePanel)dockable.getFocusComponent();
            panel.terminate();
            if (!this.dockingManager.getCControl().removeDockable(dockable)) {
                LOG.warn("Couldn't remove dockable for plugin panel factory '{}'", (Object)factory);
                return;
            }
        }
        if (!visible) {
            return;
        }
        if (factory.providesPanel(Kernel.State.MODELLING)) {
            panel = factory.createPanel(Kernel.State.MODELLING);
            final DefaultSingleCDockable factoryDockable = this.dockingManager.createFloatingDockable(factory.getClass().getName(), factory.getPanelDescription(), (JComponent)panel);
            factoryDockable.addVetoClosingListener(new CVetoClosingListener(){

                public void closing(CVetoClosingEvent event) {
                }

                public void closed(CVetoClosingEvent event) {
                    panel.terminate();
                    OpenTCSView.this.dockingManager.getCControl().removeDockable((SingleCDockable)factoryDockable);
                }
            });
            panel.initialize();
        }
    }

    public DefaultSingleCDockable addDrawingView() {
        DrawingViewScrollPane newScrollPane = this.drawingViewFactory.createDrawingView(this.fModelManager.getModel(), this.toolBarManager.getSelectionToolButton(), this.toolBarManager.getDragToolButton(), this.toolBarManager.getButtonCreateLink(), this.toolBarManager.getButtonCreatePath());
        int drawingViewIndex = this.viewManager.getNextDrawingViewIndex();
        String title = this.bundle.getString("openTcsView.panel_operatingDrawingView.title") + " " + drawingViewIndex;
        DefaultSingleCDockable newDockable = this.dockingManager.createDockable("drivingCourse" + drawingViewIndex, title, (JComponent)newScrollPane, true);
        this.viewManager.addDrawingView(newDockable, newScrollPane);
        int lastIndex = Math.max(0, drawingViewIndex - 1);
        this.dockingManager.addTabTo(newDockable, "course_tab_pane", lastIndex);
        newDockable.addVetoClosingListener((CVetoClosingListener)new DrawingViewClosingListener(newDockable));
        newDockable.addFocusListener((CFocusListener)this.drawingViewFocusHandler);
        newScrollPane.getDrawingView().getComponent().dispatchEvent(new FocusEvent((Component)((Object)this), 1004));
        this.firePropertyChange("focusGained", null, newDockable);
        return newDockable;
    }

    public void resetWindowArrangement() {
        for (DefaultSingleCDockable dock : new ArrayList(this.viewManager.getDrawingViewMap().keySet())) {
            this.removeDrawingView(dock);
        }
        this.dockingManager.reset();
        this.closeOpenedPluginPanels();
        this.viewManager.reset();
        this.initializeFrame();
        this.viewManager.init();
        new Thread(() -> this.setModelingState()).start();
    }

    public void createEmptyModel() {
        CloseFileAction action = (CloseFileAction)this.getActionMap().get("file.close");
        if (action != null) {
            action.actionPerformed(new ActionEvent((Object)this, 1001, "modelClosing"));
            if (action.getFileSavedStatus() == 2) {
                return;
            }
        }
        this.eventBus.onEvent((Object)new SystemModelTransitionEvent((Object)this, SystemModelTransitionEvent.Stage.UNLOADING, this.fModelManager.getModel()));
        this.eventBus.onEvent((Object)new SystemModelTransitionEvent((Object)this, SystemModelTransitionEvent.Stage.UNLOADED, this.fModelManager.getModel()));
        LOG.debug("Creating new driving course model...");
        this.fModelManager.createEmptyModel();
        this.eventBus.onEvent((Object)new SystemModelTransitionEvent((Object)this, SystemModelTransitionEvent.Stage.LOADING, this.fModelManager.getModel()));
        this.setSystemModel(this.fModelManager.getModel());
        this.eventBus.onEvent((Object)new SystemModelTransitionEvent((Object)this, SystemModelTransitionEvent.Stage.LOADED, this.fModelManager.getModel()));
        this.fDrawingEditor.initializeViewport();
    }

    public void loadCurrentKernelModel() {
        try (SharedKernelServicePortal sharedPortal = this.portalProvider.register();){
            this.loadCurrentKernelModel(sharedPortal.getPortal());
        }
        catch (ServiceUnavailableException exc) {
            LOG.info("Kernel unavailable, aborting.", (Throwable)exc);
        }
    }

    private void loadCurrentKernelModel(KernelServicePortal portal) {
        if (this.hasUnsavedChanges() && !this.showUnsavedChangesDialog()) {
            return;
        }
        this.restoreModel(portal);
    }

    private void restoreModel(@Nullable KernelServicePortal portal) {
        this.progressIndicator.initialize();
        this.progressIndicator.setProgress((ProgressStatus)ModelRestorationProgressStatus.CLEANUP);
        this.eventBus.onEvent((Object)new SystemModelTransitionEvent((Object)this, SystemModelTransitionEvent.Stage.UNLOADING, this.fModelManager.getModel()));
        this.progressIndicator.setProgress((ProgressStatus)ModelRestorationProgressStatus.START_LOADING_MODEL);
        this.eventBus.onEvent((Object)new SystemModelTransitionEvent((Object)this, SystemModelTransitionEvent.Stage.UNLOADED, this.fModelManager.getModel()));
        if (portal == null) {
            this.fModelManager.restoreModel();
        } else {
            this.fModelManager.restoreModel(portal);
            this.statusPanel.setLogMessage(Level.INFO, this.bundle.getFormatted("openTcsView.message_modelLoaded.text", new Object[]{this.fModelManager.getModel().getName()}));
        }
        this.progressIndicator.setProgress((ProgressStatus)ModelRestorationProgressStatus.SET_UP_MODEL_VIEW);
        this.eventBus.onEvent((Object)new SystemModelTransitionEvent((Object)this, SystemModelTransitionEvent.Stage.LOADING, this.fModelManager.getModel()));
        this.setSystemModel(this.fModelManager.getModel());
        this.progressIndicator.setProgress((ProgressStatus)ModelRestorationProgressStatus.SET_UP_DIRECTORY_TREE);
        this.progressIndicator.setProgress((ProgressStatus)ModelRestorationProgressStatus.SET_UP_WORKING_AREA);
        ModelComponent layoutComponent = this.fModelManager.getModel().getMainFolder(SystemModel.FolderKey.LAYOUT);
        layoutComponent.addAttributesChangeListener(this.attributesEventHandler);
        this.eventBus.onEvent((Object)new SystemModelTransitionEvent((Object)this, SystemModelTransitionEvent.Stage.LOADED, this.fModelManager.getModel()));
        this.updateModelName();
        this.progressIndicator.terminate();
    }

    private void setModelNameProperty(String modelName) {
        this.fModelManager.getModel().setName(modelName);
        this.eventBus.onEvent((Object)new ModelNameChangeEvent((Object)this, modelName));
    }

    public void updateModelName() {
        String newName = this.fModelManager.getModel().getName();
        this.eventBus.onEvent((Object)new ModelNameChangeEvent((Object)this, newName));
    }

    public void addBackgroundBitmap(File file) {
        this.viewManager.setBitmapToModellingView(file);
    }

    public List<UserObject> restoreModelComponents(List<UserObject> userObjects) {
        ArrayList<UserObject> restoredUserObjects = new ArrayList<UserObject>();
        for (UserObject userObject : userObjects) {
            Figure figure;
            ModelComponent modelComponent = userObject.getModelComponent();
            ModelComponent folder = this.fModelManager.getModel().getFolder(modelComponent);
            if (folder == null) {
                return null;
            }
            if (folder.contains(modelComponent)) {
                try {
                    figure = this.fModelManager.getModel().getFigure(modelComponent);
                    if (figure != null) {
                        LabeledFigure clonedFigure;
                        if (figure instanceof LabeledFigure) {
                            clonedFigure = (LabeledFigure)figure.clone();
                            AffineTransform tx = new AffineTransform();
                            tx.translate(50.0, 50.0);
                            clonedFigure.transform(tx);
                            this.getActiveDrawingView().getDrawing().add((Figure)clonedFigure);
                            modelComponent = (ModelComponent)clonedFigure.get(FigureConstants.MODEL);
                        } else if (figure instanceof TCSFigure) {
                            clonedFigure = (TCSFigure)figure.clone();
                            modelComponent = clonedFigure.getModel();
                        }
                    } else {
                        modelComponent = modelComponent.clone();
                    }
                }
                catch (CloneNotSupportedException ex) {
                    LOG.warn("clone() not supported for {}", (Object)modelComponent.getName());
                }
            }
            if ((figure = this.fModelManager.getModel().getFigure(modelComponent)) != null && !this.getActiveDrawingView().getDrawing().contains(figure)) {
                this.getActiveDrawingView().getDrawing().add(figure);
            }
            this.addModelComponent(folder, modelComponent);
            UserObjectContext.ContextType type = null;
            if (userObject instanceof ContextObject) {
                ContextObject co = (ContextObject)userObject;
                type = co.getContextType();
            }
            UserObjectContext context = this.userObjectUtil.createContext(type);
            restoredUserObjects.add(this.userObjectUtil.createUserObject(modelComponent, context));
        }
        return restoredUserObjects;
    }

    public void write(URI f, URIChooser chooser) throws IOException {
    }

    public void read(URI f, URIChooser chooser) throws IOException {
    }

    public boolean canSaveTo(URI file) {
        return new File(file).getName().endsWith(".xml");
    }

    public URI getURI() {
        String modelName = this.fModelManager.getModel().getName();
        try {
            this.uri = new URI(modelName);
        }
        catch (URISyntaxException ex) {
            LOG.warn("URISyntaxException in getURI({})", (Object)modelName, (Object)ex);
        }
        return this.uri;
    }

    private List<OpenTCSDrawingView> getDrawingViews() {
        ArrayList<OpenTCSDrawingView> views = new ArrayList<OpenTCSDrawingView>();
        for (DrawingViewScrollPane scrollPane : this.viewManager.getDrawingViewMap().values()) {
            views.add(scrollPane.getDrawingView());
        }
        return views;
    }

    public void selectModelComponent(ModelComponent modelComponent) {
        this.fPropertiesComponent.setModel(modelComponent);
        OpenTCSDrawingView drawingView = this.fDrawingEditor.getActiveView();
        drawingView.clearSelection();
        Figure figure = this.findFigure(modelComponent);
        if (figure != null) {
            drawingView.toggleSelection(figure);
        }
    }

    public void addSelectedModelComponent(ModelComponent modelComponent) {
        Set components = this.fComponentsTreeManager.getSelectedItems();
        if (components.size() > 1) {
            components.add(modelComponent);
            OpenTCSDrawingView drawingView = this.fDrawingEditor.getActiveView();
            drawingView.clearSelection();
            LinkedList<Figure> figures = new LinkedList<Figure>();
            for (ModelComponent comp : components) {
                Figure figure = this.findFigure(comp);
                if (figure == null) continue;
                figures.add(figure);
            }
            drawingView.addToSelection(figures);
            this.fPropertiesComponent.setModel((ModelComponent)new PropertiesCollection((Collection)components));
            this.fComponentsTreeManager.selectItems(components);
        } else {
            this.selectModelComponent(modelComponent);
        }
    }

    public boolean treeComponentRemoved(ModelComponent model) {
        boolean componentRemoved = false;
        boolean componentRemovedFromFolder = false;
        if (model instanceof PointModel || model instanceof LocationModel) {
            LabeledFigure lf = (LabeledFigure)this.fModelManager.getModel().getFigure(model);
            this.fDrawingEditor.getActiveView().getDrawing().remove((Figure)lf);
            componentRemoved = true;
        } else if ((model instanceof LinkModel || model instanceof PathModel) && !(model.getParent() instanceof BlockModel)) {
            SimpleLineConnection figure = (SimpleLineConnection)this.fModelManager.getModel().getFigure(model);
            this.fDrawingEditor.getActiveView().getDrawing().remove((Figure)figure);
            componentRemoved = true;
        } else if (model instanceof VehicleModel) {
            componentRemoved = true;
        } else if (model instanceof LocationTypeModel) {
            for (LocationModel lm : this.fModelManager.getModel().getLocationModels()) {
                if (lm.getLocationType() != model) continue;
                JOptionPane.showMessageDialog((Component)((Object)this), this.bundle.getString("openTcsView.optionPane_cannotDeleteLocationType.message"), this.bundle.getString("openTcsView.optionPane_cannotDeleteLocationType.title"), 0);
                return false;
            }
            componentRemoved = true;
        }
        ModelComponent folder = this.fModelManager.getModel().getFolder(model);
        if (folder != null) {
            componentRemovedFromFolder = this.removeModelComponent(folder, model);
        }
        return componentRemoved || componentRemovedFromFolder;
    }

    public void figureSelected(ModelComponent modelComponent) {
        modelComponent.addAttributesChangeListener(this.attributesEventHandler);
        this.fPropertiesComponent.setModel(modelComponent);
        Figure figure = this.findFigure(modelComponent);
        OpenTCSDrawingView drawingView = this.fDrawingEditor.getActiveView();
        if (figure != null) {
            drawingView.clearSelection();
            drawingView.addToSelection(figure);
            drawingView.scrollTo(figure);
        }
    }

    public void loadModel() {
        if (this.hasUnsavedChanges() && !this.showUnsavedChangesDialog()) {
            return;
        }
        if (!this.fModelManager.loadModel(null)) {
            return;
        }
        this.restoreModel(null);
        this.setHasUnsavedChanges(false);
    }

    public void importModel(PlantModelImporter importer) {
        Objects.requireNonNull(importer, "importer");
        if (this.hasUnsavedChanges() && !this.showUnsavedChangesDialog()) {
            return;
        }
        if (!this.fModelManager.importModel(importer)) {
            return;
        }
        this.restoreModel(null);
        this.setHasUnsavedChanges(false);
    }

    private boolean showUnsavedChangesDialog() {
        CloseFileAction action = (CloseFileAction)this.getActionMap().get("file.close");
        action.actionPerformed(new ActionEvent((Object)this, 1001, "modelClosing"));
        switch (action.getFileSavedStatus()) {
            case 0: {
                super.setHasUnsavedChanges(false);
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        return false;
    }

    public boolean persistModel() {
        boolean bl;
        block8: {
            SharedKernelServicePortal sharedPortal = this.portalProvider.register();
            try {
                bl = this.persistModel(sharedPortal.getPortal());
                if (sharedPortal == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (sharedPortal != null) {
                        try {
                            sharedPortal.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ServiceUnavailableException exc) {
                    LOG.warn("Exception persisting model", (Throwable)exc);
                    return false;
                }
            }
            sharedPortal.close();
        }
        return bl;
    }

    private boolean persistModel(KernelServicePortal portal) {
        if (this.hasUnsavedChanges()) {
            JOptionPane.showMessageDialog(null, this.bundle.getString("openTcsView.optionPane_saveModelBeforeKernelPersist.message"));
            if (this.fModelManager.persistModel(true)) {
                this.setHasUnsavedChanges(false);
                String modelName = this.fModelManager.getModel().getName();
                this.setModelNameProperty(modelName);
                return this.persistModel(portal);
            }
            return false;
        }
        try {
            if (portal.getState() != Kernel.State.OPERATING && this.userMessageHelper.showConfirmDialog(this.bundle.getString("openTcsView.dialog_saveModelConfirmation.title"), this.bundle.getString("openTcsView.dialog_saveModelConfirmation.message"), UserMessageHelper.Type.QUESTION) != UserMessageHelper.ReturnType.OK) {
                return false;
            }
            boolean didSave = this.fModelManager.persistModel(portal);
            if (didSave) {
                String modelName = this.fModelManager.getModel().getName();
                this.setModelNameProperty(modelName);
                this.setHasUnsavedChanges(false);
                String persistMsg = this.bundle.getFormatted("openTcsView.message_modelSaved.text", new Object[]{modelName});
                this.statusPanel.setLogMessage(Level.INFO, persistMsg);
            }
            return didSave;
        }
        catch (KernelRuntimeException e) {
            LOG.warn("Exception persisting model {}", (Object)this.fModelManager.getModel().getName(), (Object)e);
            this.statusPanel.setLogMessage(Level.WARNING, e.getMessage());
            return false;
        }
    }

    public boolean saveModel() {
        boolean saved = this.fModelManager.persistModel(false);
        if (saved) {
            String modelName = this.fModelManager.getModel().getName();
            this.setModelNameProperty(modelName);
            this.setHasUnsavedChanges(false);
        }
        return saved;
    }

    public boolean saveModelAs() {
        boolean saved = this.fModelManager.persistModel(true);
        if (saved) {
            String modelName = this.fModelManager.getModel().getName();
            this.setModelNameProperty(modelName);
            this.setHasUnsavedChanges(false);
        }
        return saved;
    }

    public void exportModel(PlantModelExporter exporter) {
        this.fModelManager.exportModel(exporter);
    }

    public ModelComponent createModelComponent(Class<? extends ModelComponent> clazz) {
        LocationTypeModel model;
        Objects.requireNonNull(clazz, "clazz");
        if (clazz == VehicleModel.class) {
            VehicleModel vehicleModel = this.modelComponentFactory.createVehicleModel();
            vehicleModel.getPropertyRouteColor().setColor(Colors.unusedVehicleColor(this.fModelManager.getModel().getVehicleModels()));
            model = vehicleModel;
        } else if (clazz == LocationTypeModel.class) {
            model = this.modelComponentFactory.createLocationTypeModel();
        } else if (clazz == BlockModel.class) {
            BlockModel blockModel = this.modelComponentFactory.createBlockModel();
            blockModel.getPropertyColor().setColor(Colors.unusedBlockColor(this.fModelManager.getModel().getBlockModels()));
            model = blockModel;
        } else {
            throw new IllegalArgumentException("Unhandled component class: " + clazz);
        }
        this.addModelComponent(this.fModelManager.getModel().getFolder((ModelComponent)model), (ModelComponent)model);
        return model;
    }

    private OpenTCSDrawingView getActiveDrawingView() {
        return this.fDrawingEditor.getActiveView();
    }

    private void removeDrawingView(DefaultSingleCDockable dock) {
        if (!this.viewManager.getDrawingViewMap().containsKey(dock)) {
            return;
        }
        this.fDrawingEditor.remove((DrawingView)((DrawingViewScrollPane)this.viewManager.getDrawingViewMap().get(dock)).getDrawingView());
        this.viewManager.removeDockable(dock);
        this.dockingManager.removeDockable((SingleCDockable)dock);
    }

    private JPanel wrapViewComponent() {
        JToolBar toolBar = new JToolBar();
        JPanel toolBarPanel = new JPanel();
        toolBarPanel.setLayout(new BoxLayout(toolBarPanel, 2));
        toolBar.setBorder((Border)new PaletteToolBarBorder());
        LinkedList<JToolBar> lToolBars = new LinkedList<JToolBar>();
        JPanel wholeComponentPanel = new JPanel(new BorderLayout());
        wholeComponentPanel.add((Component)toolBarPanel, "North");
        wholeComponentPanel.add(this.getComponent());
        lToolBars.add(toolBar);
        JPanel viewComponent = wholeComponentPanel;
        for (JToolBar curToolBar : new ReversedList(this.toolBarManager.getToolBars())) {
            JPanel curToolBarPanel = new JPanel();
            curToolBarPanel.setLayout(new BoxLayout(curToolBarPanel, 2));
            JPanel wrappingPanel = new JPanel(new BorderLayout());
            curToolBar.setBorder((Border)new PaletteToolBarBorder());
            curToolBarPanel.add(curToolBar);
            wrappingPanel.add((Component)curToolBarPanel, "North");
            wrappingPanel.add(viewComponent);
            lToolBars.add(curToolBar);
            viewComponent = wrappingPanel;
        }
        for (JToolBar bar : lToolBars) {
            this.configureToolBarButtons(bar);
        }
        return viewComponent;
    }

    private void configureToolBarButtons(JToolBar bar) {
        Dimension dimButton = new Dimension(32, 34);
        for (Component comp : bar.getComponents()) {
            if (!(comp instanceof JButton) && !(comp instanceof JToggleButton)) continue;
            JComponent tbButton = (JComponent)comp;
            tbButton.setMaximumSize(dimButton);
            tbButton.setPreferredSize(dimButton);
            tbButton.setBorder(new EtchedBorder());
        }
    }

    private void closeOpenedPluginPanels() {
        for (PluggablePanelFactory factory : this.panelRegistry.getFactories()) {
            this.showPluginPanel(factory, false);
        }
    }

    private void setModelingState() {
        this.appState.setOperationMode(OperationMode.MODELLING);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                OpenTCSView.this.eventBus.onEvent((Object)new OperationModeChangeEvent((Object)this, OperationMode.UNDEFINED, OperationMode.MODELLING));
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(run);
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InterruptedException | InvocationTargetException ex) {
                LOG.error("Unexpected exception ", (Throwable)ex);
            }
        }
        this.eventBus.onEvent((Object)new ResetInteractionToolCommand((Object)this));
    }

    private void addModelComponent(ModelComponent folder, ModelComponent modelComponent) {
        LocationModel location;
        if (folder.contains(modelComponent)) {
            return;
        }
        if (this.requiresName(modelComponent)) {
            if (modelComponent.getName().isEmpty() || this.modelCompNameGen.hasString(modelComponent.getName())) {
                String name = this.modelCompNameGen.getUniqueString(modelComponent.getClass());
                modelComponent.setName(name);
                this.modelCompNameGen.addString(name);
            } else {
                this.modelCompNameGen.addString(modelComponent.getName());
            }
        }
        if (modelComponent instanceof LocationModel && (location = (LocationModel)modelComponent).getLocationType() == null) {
            List types = this.fModelManager.getModel().getLocationTypeModels();
            LocationTypeModel type = types.isEmpty() ? (LocationTypeModel)this.createModelComponent(LocationTypeModel.class) : (LocationTypeModel)types.get(0);
            location.setLocationType(type);
            location.updateTypeProperty(this.fModelManager.getModel().getLocationTypeModels());
        }
        folder.add(modelComponent);
        this.fComponentsTreeManager.addItem((Object)folder, modelComponent);
        modelComponent.addAttributesChangeListener(this.attributesEventHandler);
        if (modelComponent instanceof LocationTypeModel) {
            List types = this.fModelManager.getModel().getLocationTypeModels();
            for (LocationModel location2 : this.fModelManager.getModel().getLocationModels()) {
                location2.updateTypeProperty(types);
            }
        }
        if (modelComponent instanceof BlockModel) {
            BlockModel blockModel = (BlockModel)modelComponent;
            this.fBlocksTreeManager.addItem((Object)folder, modelComponent);
            blockModel.addBlockChangeListener(this.blockEventHandler);
            for (DrawingView drawView : this.fDrawingEditor.getDrawingViews()) {
                ((OpenTCSDrawingViewModeling)drawView).blockAdded(blockModel);
            }
        } else if (modelComponent instanceof VehicleModel) {
            // empty if block
        }
        this.selectModelComponent(modelComponent);
        this.setHasUnsavedChanges(true);
    }

    private boolean requiresName(ModelComponent model) {
        return model instanceof PointModel || model instanceof PathModel || model instanceof LocationTypeModel || model instanceof LocationModel || model instanceof BlockModel || model instanceof LayoutModel || model instanceof VehicleModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeModelComponent(ModelComponent folder, ModelComponent model) {
        if (!folder.contains(model)) {
            return false;
        }
        boolean componentRemoved = false;
        ModelComponent modelComponent = model;
        synchronized (modelComponent) {
            if (!BlockModel.class.isInstance(folder)) {
                ModelComponent modelComponent2 = folder;
                synchronized (modelComponent2) {
                    folder.remove(model);
                }
                model.removeAttributesChangeListener(this.attributesEventHandler);
                componentRemoved = true;
            }
            this.fPropertiesComponent.reset();
            if (model instanceof BlockModel) {
                BlockModel blockModel = (BlockModel)model;
                this.fBlocksTreeManager.removeItem((Object)blockModel);
                blockModel.blockRemoved();
                blockModel.removeBlockChangeListener(this.blockEventHandler);
            } else if (componentRemoved) {
                this.fComponentsTreeManager.removeItem((Object)model);
            }
            if (model instanceof LocationTypeModel) {
                for (LocationModel location : this.fModelManager.getModel().getLocationModels()) {
                    location.updateTypeProperty(this.fModelManager.getModel().getLocationTypeModels());
                }
            }
            this.modelCompNameGen.removeString(model.getName());
            this.setHasUnsavedChanges(true);
        }
        return componentRemoved;
    }

    private Figure findFigure(ModelComponent model) {
        return this.fModelManager.getModel().getFigure(model);
    }

    private void setSystemModel(SystemModel systemModel) {
        Objects.requireNonNull(systemModel, "systemModel");
        long timeBefore = System.currentTimeMillis();
        for (Object scrollPane : this.viewManager.getDrawingViewMap().values()) {
            scrollPane.originChanged(systemModel.getDrawingMethod().getOrigin());
        }
        this.modelCompNameGen.clear();
        this.fDrawingEditor.setSystemModel(systemModel);
        Drawing drawing = this.fDrawingEditor.getDrawing();
        drawing.addUndoableEditListener((UndoableEditListener)this.fUndoRedoManager);
        this.fComponentsTreeManager.restoreTreeView((ModelComponent)systemModel);
        this.fComponentsTreeManager.sortItems();
        this.fComponentsTreeManager.getTreeView().getTree().scrollRowToVisible(0);
        this.fBlocksTreeManager.restoreTreeView(systemModel.getMainFolder(SystemModel.FolderKey.BLOCKS));
        this.fBlocksTreeManager.getTreeView().sortRoot();
        this.fBlocksTreeManager.getTreeView().getTree().scrollRowToVisible(0);
        for (VehicleModel vehicle : systemModel.getVehicleModels()) {
            vehicle.addAttributesChangeListener(this.attributesEventHandler);
            this.modelCompNameGen.addString(vehicle.getName());
        }
        LayoutModel layout = systemModel.getLayoutModel();
        layout.addAttributesChangeListener(this.attributesEventHandler);
        this.modelCompNameGen.addString(layout.getName());
        for (PointModel point : systemModel.getPointModels()) {
            point.addAttributesChangeListener(this.attributesEventHandler);
            this.modelCompNameGen.addString(point.getName());
        }
        for (PathModel path : systemModel.getPathModels()) {
            path.addAttributesChangeListener(this.attributesEventHandler);
            this.modelCompNameGen.addString(path.getName());
        }
        for (LocationTypeModel locationType : systemModel.getLocationTypeModels()) {
            locationType.addAttributesChangeListener(this.attributesEventHandler);
            this.modelCompNameGen.addString(locationType.getName());
        }
        for (LocationModel location : systemModel.getLocationModels()) {
            location.addAttributesChangeListener(this.attributesEventHandler);
            this.modelCompNameGen.addString(location.getName());
        }
        for (LinkModel link : systemModel.getLinkModels()) {
            link.addAttributesChangeListener(this.attributesEventHandler);
            this.modelCompNameGen.addString(link.getName());
        }
        for (BlockModel block : systemModel.getBlockModels()) {
            block.addAttributesChangeListener(this.attributesEventHandler);
            block.addBlockChangeListener(this.blockEventHandler);
            this.modelCompNameGen.addString(block.getName());
        }
        LOG.debug("setSystemModel() took {} ms.", (Object)(System.currentTimeMillis() - timeBefore));
    }

    private void initializeFrame() {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(() -> this.initializeFrame());
            }
            catch (InterruptedException | InvocationTargetException e) {
                LOG.warn("Exception initializing frame", (Throwable)e);
            }
            return;
        }
        this.fFrame.getContentPane().removeAll();
        this.dockingManager.initializeDockables();
        this.fFrame.setLayout(new BorderLayout());
        this.fFrame.add((Component)this.wrapViewComponent(), "North");
        this.fFrame.add((Component)this.dockingManager.getCControl().getContentArea());
        this.fFrame.add((Component)this.statusPanel, "South");
        this.restoreDockables();
        this.toolBarManager.getDragToolButton().doClick();
        this.toolBarManager.getSelectionToolButton().doClick();
    }

    private void restoreDockables() {
        DefaultSingleCDockable modellingDockable = this.addDrawingView();
        this.viewManager.initModellingDockable(modellingDockable, this.bundle.getString("openTcsView.panel_modellingDrawingView.title"));
        ((CStackDockStation)this.dockingManager.getTabPane("course_tab_pane").getStation()).setFrontDockable((Dockable)this.viewManager.evaluateFrontDockable());
    }

    private class BlockEventHandler
    implements BlockChangeListener {
        public void courseElementsChanged(BlockChangeEvent event) {
            BlockModel block = (BlockModel)event.getSource();
            OpenTCSView.this.fBlocksTreeManager.removeChildren((Object)block);
            for (ModelComponent component : block.getChildComponents()) {
                OpenTCSView.this.fBlocksTreeManager.addItem((Object)block, component);
            }
            OpenTCSView.this.setHasUnsavedChanges(true);
        }

        public void colorChanged(BlockChangeEvent event) {
        }

        public void blockRemoved(BlockChangeEvent event) {
        }
    }

    private class AttributesEventHandler
    implements AttributesChangeListener {
        public void propertiesChanged(AttributesChangeEvent event) {
            if (event.getInitiator() == this) {
                return;
            }
            ModelComponent model = event.getModel();
            if (model.getPropertyName() != null && model.getPropertyName().hasChanged()) {
                OpenTCSView.this.fComponentsTreeManager.itemChanged((Object)model);
                OpenTCSView.this.fModelManager.getModel().getBlockModels().stream().filter(block -> this.blockAffectedByNameChange((BlockModel)block, model)).forEach(block -> this.updateBlockMembers((BlockModel)block));
            }
            if (model instanceof LayoutModel) {
                LengthProperty pScaleX = (LengthProperty)model.getProperty("scaleX");
                LengthProperty pScaleY = (LengthProperty)model.getProperty("scaleY");
                if (pScaleX.hasChanged() || pScaleY.hasChanged()) {
                    double scaleX = (Double)pScaleX.getValue();
                    double scaleY = (Double)pScaleY.getValue();
                    if (scaleX != 0.0 && scaleY != 0.0) {
                        OpenTCSView.this.fModelManager.getModel().getDrawingMethod().getOrigin().setScale(scaleX, scaleY);
                    }
                }
            }
            if (model instanceof LocationModel && model.getProperty("Type").hasChanged()) {
                AbstractProperty p = (AbstractProperty)model.getProperty("Type");
                LocationTypeModel type = OpenTCSView.this.fModelManager.getModel().getLocationTypeModel((String)p.getValue());
                ((LocationModel)model).setLocationType(type);
                if (model != event.getInitiator()) {
                    model.propertiesChanged((AttributesChangeListener)this);
                }
            }
            if (model instanceof LocationTypeModel) {
                for (LocationModel locModel : OpenTCSView.this.fModelManager.getModel().getLocationModels()) {
                    locModel.updateTypeProperty(OpenTCSView.this.fModelManager.getModel().getLocationTypeModels());
                }
            }
        }

        private boolean blockAffectedByNameChange(BlockModel block, ModelComponent model) {
            return block.getChildComponents().stream().anyMatch(member -> member.equals(model));
        }

        private void updateBlockMembers(BlockModel block) {
            ArrayList<String> members = new ArrayList<String>();
            for (ModelComponent component : block.getChildComponents()) {
                members.add(component.getName());
            }
            block.getPropertyElements().setItems(members);
        }
    }

    private class DrawingEditorEventHandler
    implements DrawingEditorListener {
        private final ModelManager modelManager;

        public DrawingEditorEventHandler(ModelManager modelManager) {
            this.modelManager = Objects.requireNonNull(modelManager, "modelManager");
        }

        public void figureAdded(DrawingEditorEvent event) {
            Origin ref;
            Figure figure = event.getFigure();
            ModelComponent model = (ModelComponent)figure.get(FigureConstants.MODEL);
            if (model == null) {
                return;
            }
            if (figure instanceof AttributesChangeListener) {
                model.addAttributesChangeListener((AttributesChangeListener)figure);
            }
            if (figure instanceof OriginChangeListener && (ref = this.modelManager.getModel().getDrawingMethod().getOrigin()) != null) {
                ref.addListener((OriginChangeListener)figure);
                figure.set(FigureConstants.ORIGIN, (Object)ref);
            }
            OpenTCSView.this.fModelManager.getModel().registerFigure(model, figure);
            ModelComponent folder = this.modelManager.getModel().getFolder(model);
            OpenTCSView.this.addModelComponent(folder, model);
            if (figure instanceof LabeledFigure) {
                ((LabeledFigure)figure).updateModel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void figureRemoved(DrawingEditorEvent e) {
            Figure figure = e.getFigure();
            if (figure == null) {
                return;
            }
            ModelComponent model = (ModelComponent)figure.get(FigureConstants.MODEL);
            if (model == null) {
                return;
            }
            ModelComponent modelComponent = model;
            synchronized (modelComponent) {
                ModelComponent folder;
                Origin ref;
                if (figure instanceof OriginChangeListener && (ref = (Origin)figure.get(FigureConstants.ORIGIN)) != null) {
                    ref.removeListener((OriginChangeListener)figure);
                    figure.set(FigureConstants.ORIGIN, null);
                }
                this.removeFromAllBlocks(model);
                ModelComponent modelComponent2 = folder = this.modelManager.getModel().getFolder(model);
                synchronized (modelComponent2) {
                    OpenTCSView.this.removeModelComponent(folder, model);
                }
            }
        }

        public void figureSelected(DrawingEditorEvent event) {
            if (event.getCount() == 0) {
                OpenTCSView.this.fComponentsTreeManager.selectItems(null);
                OpenTCSView.this.fBlocksTreeManager.selectItems(null);
            } else if (event.getCount() == 1) {
                ModelComponent model;
                Figure figure = event.getFigure();
                if (figure != null && (model = (ModelComponent)figure.get(FigureConstants.MODEL)) != null) {
                    model.addAttributesChangeListener(OpenTCSView.this.attributesEventHandler);
                    OpenTCSView.this.fPropertiesComponent.setModel(model);
                    OpenTCSView.this.fComponentsTreeManager.selectItem(model);
                    OpenTCSView.this.fBlocksTreeManager.selectItem(model);
                }
            } else {
                LinkedList<ModelComponent> models = new LinkedList<ModelComponent>();
                HashSet<ModelComponent> components = new HashSet<ModelComponent>();
                for (Figure figure : event.getFigures()) {
                    ModelComponent model = (ModelComponent)figure.get(FigureConstants.MODEL);
                    if (model == null) continue;
                    models.add(model);
                    components.add(model);
                }
                PropertiesCollection model = new PropertiesCollection(models);
                OpenTCSView.this.fComponentsTreeManager.selectItems(components);
                OpenTCSView.this.fBlocksTreeManager.selectItems(components);
                OpenTCSView.this.fPropertiesComponent.setModel((ModelComponent)model);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeFromAllBlocks(ModelComponent model) {
            ModelComponent mainFolder;
            ModelComponent modelComponent = mainFolder = this.modelManager.getModel().getMainFolder(SystemModel.FolderKey.BLOCKS);
            synchronized (modelComponent) {
                for (ModelComponent blockModelComp : mainFolder.getChildComponents()) {
                    BlockModel block = (BlockModel)blockModelComp;
                    ArrayList<ModelComponent> elementsToRemove = new ArrayList<ModelComponent>();
                    for (ModelComponent blockChildComp : block.getChildComponents()) {
                        if (model != blockChildComp) continue;
                        elementsToRemove.add(blockChildComp);
                    }
                    if (elementsToRemove.isEmpty()) continue;
                    for (ModelComponent mc : elementsToRemove) {
                        block.removeCourseElement(mc);
                    }
                    block.courseElementsChanged();
                }
            }
        }
    }

    private class DrawingViewClosingListener
    implements CVetoClosingListener {
        private final DefaultSingleCDockable newDockable;

        public DrawingViewClosingListener(DefaultSingleCDockable newDockable) {
            this.newDockable = newDockable;
        }

        public void closing(CVetoClosingEvent event) {
        }

        public void closed(CVetoClosingEvent event) {
            if (this.newDockable.isCloseable()) {
                OpenTCSView.this.removeDrawingView(this.newDockable);
            }
        }
    }
}

