/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.application.menus;

import com.google.inject.assistedinject.Assisted;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import javax.inject.Inject;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.guing.application.menus.MenuItemComponentsFactory;
import org.opentcs.guing.application.menus.ModelToLayoutCoordinateUndoActivity;
import org.opentcs.guing.components.drawing.OpenTCSDrawingEditor;
import org.opentcs.guing.components.drawing.figures.FigureConstants;
import org.opentcs.guing.components.drawing.figures.LabeledFigure;
import org.opentcs.guing.components.properties.event.AttributesChangeEvent;
import org.opentcs.guing.components.properties.event.AttributesChangeListener;
import org.opentcs.guing.components.properties.event.NullAttributesChangeListener;
import org.opentcs.guing.components.properties.type.CoordinateProperty;
import org.opentcs.guing.components.properties.type.ModelAttribute;
import org.opentcs.guing.components.properties.type.StringProperty;
import org.opentcs.guing.event.ResetInteractionToolCommand;
import org.opentcs.guing.model.ModelComponent;
import org.opentcs.guing.model.elements.LocationModel;
import org.opentcs.guing.model.elements.PointModel;
import org.opentcs.thirdparty.jhotdraw.application.action.edit.UndoRedoManager;
import org.opentcs.thirdparty.jhotdraw.util.ResourceBundleUtil;
import org.opentcs.util.event.EventHandler;

public class ModelToLayoutMenuItem
extends JMenuItem {
    private final DrawingEditor drawingEditor;
    private final UndoRedoManager undoRedoManager;
    private final EventHandler eventBus;
    private final MenuItemComponentsFactory componentsFactory;
    private final boolean copyAll;

    @Inject
    public ModelToLayoutMenuItem(OpenTCSDrawingEditor drawingEditor, UndoRedoManager undoRedoManager, @ApplicationEventBus EventHandler eventHandler, MenuItemComponentsFactory componentsFactory, @Assisted boolean copyAll) {
        super(ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.modeling.mainMenu").getString("modelToLayoutMenuItem.text"));
        this.drawingEditor = (DrawingEditor)Objects.requireNonNull(drawingEditor, "drawingEditor");
        this.undoRedoManager = Objects.requireNonNull(undoRedoManager, "undoRedoManager");
        this.eventBus = Objects.requireNonNull(eventHandler, "eventHandler");
        this.componentsFactory = Objects.requireNonNull(componentsFactory, "componentsFactory");
        this.copyAll = copyAll;
        this.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("org/opentcs/guing/res/symbols/menu/arrow-down-3.png")));
        this.setMargin(new Insets(0, 2, 0, 2));
        this.addActionListener();
    }

    private void addActionListener() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (Figure figure : ModelToLayoutMenuItem.this.copyAll ? ModelToLayoutMenuItem.this.getView().getDrawing().getFiguresFrontToBack() : ModelToLayoutMenuItem.this.getView().getSelectedFigures()) {
                    ModelComponent model = (ModelComponent)figure.get(FigureConstants.MODEL);
                    if (!(model instanceof PointModel) && !(model instanceof LocationModel)) continue;
                    ModelToLayoutMenuItem.this.updateLayoutX(model);
                    ModelToLayoutMenuItem.this.updateLayoutY(model);
                    LabeledFigure labeledFigure = (LabeledFigure)figure;
                    labeledFigure.propertiesChanged(new AttributesChangeEvent((AttributesChangeListener)new NullAttributesChangeListener(), model));
                    model.propertiesChanged((AttributesChangeListener)new NullAttributesChangeListener());
                    ModelToLayoutMenuItem.this.eventBus.onEvent((Object)new ResetInteractionToolCommand((Object)this));
                }
            }
        });
    }

    private DrawingView getView() {
        return this.drawingEditor.getActiveView();
    }

    private void updateLayoutY(ModelComponent model) {
        CoordinateProperty modelProperty = model instanceof PointModel ? (CoordinateProperty)model.getProperty("modelYPosition") : (CoordinateProperty)model.getProperty("modelYPosition");
        ModelToLayoutCoordinateUndoActivity cua = this.componentsFactory.createModelToLayoutCoordinateUndoActivity(modelProperty);
        cua.snapShotBeforeModification();
        modelProperty.setChangeState(ModelAttribute.ChangeState.DETAIL_CHANGED);
        StringProperty spy = model instanceof PointModel ? (StringProperty)model.getProperty("POSITION_Y") : (StringProperty)model.getProperty("POSITION_Y");
        spy.setText(String.valueOf(((Number)modelProperty.getValue()).intValue()));
        spy.markChanged();
        cua.snapShotAfterModification();
        this.undoRedoManager.addEdit((UndoableEdit)((Object)cua));
    }

    private void updateLayoutX(ModelComponent model) {
        CoordinateProperty modelProperty = model instanceof PointModel ? (CoordinateProperty)model.getProperty("modelXPosition") : (CoordinateProperty)model.getProperty("modelXPosition");
        ModelToLayoutCoordinateUndoActivity cua = this.componentsFactory.createModelToLayoutCoordinateUndoActivity(modelProperty);
        cua.snapShotBeforeModification();
        modelProperty.setChangeState(ModelAttribute.ChangeState.DETAIL_CHANGED);
        StringProperty spx = model instanceof PointModel ? (StringProperty)model.getProperty("POSITION_X") : (StringProperty)model.getProperty("POSITION_X");
        spx.setText(String.valueOf(((Number)modelProperty.getValue()).intValue()));
        spx.markChanged();
        cua.snapShotAfterModification();
        this.undoRedoManager.addEdit((UndoableEdit)((Object)cua));
    }
}

