/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.components.dockable;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CGrid;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.DefaultSingleCDockable;
import bibliothek.gui.dock.common.group.CGroupBehavior;
import bibliothek.gui.dock.common.intern.CDockable;
import java.util.Objects;
import javax.inject.Inject;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.opentcs.customizations.plantoverview.ApplicationFrame;
import org.opentcs.guing.components.dockable.AbstractDockingManager;
import org.opentcs.guing.components.dockable.CStack;
import org.opentcs.guing.components.dockable.CStackDockStation;
import org.opentcs.guing.components.layer.LayerGroupsPanel;
import org.opentcs.guing.components.layer.LayersPanel;
import org.opentcs.guing.components.properties.SelectionPropertiesComponent;
import org.opentcs.guing.components.tree.BlocksTreeViewManager;
import org.opentcs.guing.components.tree.ComponentsTreeViewManager;
import org.opentcs.thirdparty.jhotdraw.util.ResourceBundleUtil;

public class DockingManagerModeling
extends AbstractDockingManager {
    public static final String COURSE_TAB_PANE_ID = "course_tab_pane";
    public static final String TREE_TAB_PANE_ID = "tree_tab_pane";
    public static final String LAYER_TAB_PANE_ID = "layer_tab_pane";
    public static final String COMPONENTS_ID = "comp_dock";
    public static final String BLOCKS_ID = "block_dock";
    public static final String PROPERTIES_ID = "properties_id";
    public static final String LAYERS_ID = "layers_id";
    public static final String LAYER_GROUPS_ID = "layer_groups_id";
    private final ComponentsTreeViewManager componentsTreeViewManager;
    private final BlocksTreeViewManager blocksTreeViewManager;
    private final SelectionPropertiesComponent selectionPropertiesComponent;
    private final LayersPanel layersPanel;
    private final LayerGroupsPanel layerGroupsPanel;
    private CStack treeTabPane;
    private CStack courseTabPane;
    private CStack layerTabPane;

    @Inject
    public DockingManagerModeling(@ApplicationFrame JFrame applicationFrame, ComponentsTreeViewManager componentsTreeViewManager, BlocksTreeViewManager blocksTreeViewManager, SelectionPropertiesComponent selectionPropertiesComponent, LayersPanel layersPanel, LayerGroupsPanel layerGroupsPanel) {
        super(new CControl(applicationFrame));
        this.componentsTreeViewManager = Objects.requireNonNull(componentsTreeViewManager, "componentsTreeViewManager");
        this.blocksTreeViewManager = Objects.requireNonNull(blocksTreeViewManager, "blocksTreeViewManager");
        this.selectionPropertiesComponent = Objects.requireNonNull(selectionPropertiesComponent, "selectionPropertiesComponent");
        this.layersPanel = Objects.requireNonNull(layersPanel, "layersPanel");
        this.layerGroupsPanel = Objects.requireNonNull(layerGroupsPanel, "layerGroupsPanel");
    }

    public void reset() {
        this.removeDockable(BLOCKS_ID);
        this.removeDockable(COMPONENTS_ID);
        this.removeDockable(PROPERTIES_ID);
        this.removeDockable(LAYERS_ID);
        this.removeDockable(LAYER_GROUPS_ID);
        this.getCControl().removeStation((CStation)this.getTabPane(COURSE_TAB_PANE_ID));
        this.getCControl().removeStation((CStation)this.getTabPane(TREE_TAB_PANE_ID));
        this.getCControl().removeStation((CStation)this.getTabPane(LAYER_TAB_PANE_ID));
    }

    public void initializeDockables() {
        this.getCControl().setGroupBehavior(CGroupBehavior.TOPMOST);
        this.getCControl().putProperty(CControl.KEY_GOTO_NORMALIZED, null);
        this.getCControl().putProperty(CControl.KEY_GOTO_EXTERNALIZED, null);
        this.getCControl().putProperty(CControl.KEY_GOTO_MAXIMIZED, null);
        this.getCControl().putProperty(CControl.KEY_MAXIMIZE_CHANGE, null);
        ResourceBundleUtil bundle = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.modeling.panels.dockable");
        CGrid grid = new CGrid(this.getCControl());
        this.courseTabPane = new CStack(COURSE_TAB_PANE_ID);
        this.addTabPane(COURSE_TAB_PANE_ID, this.courseTabPane);
        this.treeTabPane = new CStack(TREE_TAB_PANE_ID);
        this.addTabPane(TREE_TAB_PANE_ID, this.treeTabPane);
        this.layerTabPane = new CStack(LAYER_TAB_PANE_ID);
        this.addTabPane(LAYER_TAB_PANE_ID, this.layerTabPane);
        DefaultSingleCDockable treeViewDock = this.createDockable(COMPONENTS_ID, bundle.getString("dockingManagerModeling.panel_components.title"), (JComponent)this.componentsTreeViewManager.getTreeView(), false);
        DefaultSingleCDockable treeBlocks = this.createDockable(BLOCKS_ID, bundle.getString("dockingManagerModeling.panel_blocks.title"), (JComponent)this.blocksTreeViewManager.getTreeView(), false);
        grid.add(0.0, 0.0, 250.0, 400.0, new CDockable[]{this.treeTabPane});
        grid.add(0.0, 400.0, 250.0, 300.0, new CDockable[]{this.createDockable(PROPERTIES_ID, bundle.getString("dockingManagerModeling.panel_properties.title"), (JComponent)this.selectionPropertiesComponent, false)});
        DefaultSingleCDockable layersDock = this.createDockable(LAYERS_ID, bundle.getString("dockingManagerModeling.panel_layers.title"), this.layersPanel, false);
        DefaultSingleCDockable layerGroupsDock = this.createDockable(LAYER_GROUPS_ID, bundle.getString("dockingManagerModeling.panel_layerGroups.title"), this.layerGroupsPanel, false);
        grid.add(0.0, 700.0, 250.0, 300.0, new CDockable[]{this.layerTabPane});
        grid.add(400.0, 0.0, 1000.0, 500.0, new CDockable[]{this.courseTabPane});
        this.getCControl().getContentArea().deploy(grid);
        this.addTabTo(treeViewDock, TREE_TAB_PANE_ID, 0);
        this.addTabTo(treeBlocks, TREE_TAB_PANE_ID, 1);
        this.addTabTo(layersDock, LAYER_TAB_PANE_ID, 0);
        this.addTabTo(layerGroupsDock, LAYER_TAB_PANE_ID, 1);
        ((CStackDockStation)this.treeTabPane.getStation()).setFrontDockable((Dockable)treeViewDock.intern());
        ((CStackDockStation)this.layerTabPane.getStation()).setFrontDockable((Dockable)layersDock.intern());
    }
}

