/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.util;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opentcs.guing.model.elements.BlockModel;
import org.opentcs.guing.model.elements.VehicleModel;

public class Colors {
    private Colors() {
    }

    public static final List<Color> defaultColors() {
        ArrayList<Color> colors = new ArrayList<Color>();
        colors.add(new Color(255, 0, 0));
        colors.add(new Color(0, 0, 255));
        colors.add(new Color(0, 255, 255));
        colors.add(new Color(255, 255, 0));
        colors.add(new Color(255, 0, 255));
        colors.add(new Color(153, 0, 204));
        colors.add(new Color(255, 102, 0));
        colors.add(new Color(204, 204, 255));
        colors.add(new Color(153, 153, 255));
        colors.add(new Color(0, 51, 153));
        colors.add(new Color(51, 204, 102));
        colors.add(new Color(0, 102, 51));
        colors.add(new Color(102, 255, 204));
        colors.add(new Color(255, 204, 0));
        colors.add(new Color(255, 153, 255));
        colors.add(new Color(255, 102, 102));
        return colors;
    }

    public static Color unusedBlockColor(List<BlockModel> blocks) {
        Objects.requireNonNull(blocks, "blocks");
        List<Color> colors = Colors.defaultColors();
        ArrayList<Color> usedColors = new ArrayList<Color>();
        for (BlockModel block : blocks) {
            usedColors.add(block.getPropertyColor().getColor());
        }
        for (Color color : colors) {
            if (usedColors.contains(color)) continue;
            return color;
        }
        return colors.get(0);
    }

    public static Color unusedVehicleColor(List<VehicleModel> vehicles) {
        Objects.requireNonNull(vehicles, "vehicles");
        List<Color> colors = Colors.defaultColors();
        ArrayList<Color> usedColors = new ArrayList<Color>();
        for (VehicleModel vehicle : vehicles) {
            usedColors.add(vehicle.getPropertyRouteColor().getColor());
        }
        for (Color color : colors) {
            if (usedColors.contains(color)) continue;
            return color;
        }
        return colors.get(0);
    }
}

