/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.application;

import bibliothek.gui.dock.common.DefaultSingleCDockable;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Objects;
import javax.inject.Inject;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.guing.application.AbstractViewManager;
import org.opentcs.guing.components.dockable.CStackDockStation;
import org.opentcs.guing.components.dockable.DockingManagerModeling;
import org.opentcs.guing.components.drawing.DrawingViewScrollPane;
import org.opentcs.guing.components.drawing.OpenTCSDrawingView;
import org.opentcs.util.event.EventSource;

public class ViewManagerModeling
extends AbstractViewManager {
    private final DockingManagerModeling dockingManager;
    private DefaultSingleCDockable drawingViewModellingDockable;

    @Inject
    public ViewManagerModeling(DockingManagerModeling dockingManager, @ApplicationEventBus EventSource eventSource) {
        super(eventSource);
        this.dockingManager = Objects.requireNonNull(dockingManager, "dockingManager");
    }

    public void init() {
        this.setPlantOverviewStateModelling();
    }

    public void reset() {
        super.reset();
        this.drawingViewModellingDockable = null;
    }

    public void initModellingDockable(DefaultSingleCDockable dockable, String title) {
        this.drawingViewModellingDockable = Objects.requireNonNull(dockable, "dockable");
        this.drawingViewModellingDockable.setTitleText(Objects.requireNonNull(title, "title"));
        this.drawingViewModellingDockable.setCloseable(false);
    }

    public void setBitmapToModellingView(File file) {
        ((DrawingViewScrollPane)this.getDrawingViewMap().get(this.drawingViewModellingDockable)).getDrawingView().addBackgroundBitmap(file);
    }

    private void setPlantOverviewStateModelling() {
        CStackDockStation station = (CStackDockStation)this.dockingManager.getTabPane("course_tab_pane").getStation();
        for (DefaultSingleCDockable dock : new ArrayList(this.getDrawingViewMap().keySet())) {
            if (dock == this.drawingViewModellingDockable) continue;
            dock.setCloseable(false);
            this.dockingManager.setDockableVisibility(dock.getUniqueId(), false);
        }
        this.dockingManager.showDockable(station, this.drawingViewModellingDockable, 0);
        OpenTCSDrawingView view = ((DrawingViewScrollPane)this.getDrawingViewMap().get(this.drawingViewModellingDockable)).getDrawingView();
        view.getComponent().dispatchEvent(new FocusEvent(view.getComponent(), 1004));
    }
}

