/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.application.action.app;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Objects;
import javax.inject.Inject;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.opentcs.access.SharedKernelServicePortalProvider;
import org.opentcs.customizations.plantoverview.ApplicationFrame;
import org.opentcs.guing.application.ApplicationState;
import org.opentcs.guing.application.OpenTCSView;
import org.opentcs.guing.util.ImageDirectory;
import org.opentcs.thirdparty.jhotdraw.util.ResourceBundleUtil;
import org.opentcs.util.Environment;

public class AboutAction
extends AbstractAction {
    public static final String ID = "application.about";
    private static final ResourceBundleUtil BUNDLE = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.modeling.mainMenu");
    private final ApplicationState appState;
    private final SharedKernelServicePortalProvider portalProvider;
    private final Component dialogParent;

    @Inject
    public AboutAction(ApplicationState appState, SharedKernelServicePortalProvider portalProvider, @ApplicationFrame Component dialogParent) {
        this.appState = Objects.requireNonNull(appState, "appState");
        this.portalProvider = Objects.requireNonNull(portalProvider, "portalProvider");
        this.dialogParent = Objects.requireNonNull(dialogParent, "dialogParent");
        this.putValue("Name", BUNDLE.getString("aboutAction.name"));
        this.putValue("MnemonicKey", 65);
        ImageIcon icon = ImageDirectory.getImageIcon((String)"/menu/help-contents.png");
        this.putValue("SmallIcon", icon);
        this.putValue("SwingLargeIconKey", icon);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this.dialogParent, "<html><p><b>" + OpenTCSView.NAME + "</b><br> " + BUNDLE.getFormatted("aboutAction.optionPane_applicationInformation.message.baselineVersion", new Object[]{Environment.getBaselineVersion()}) + "<br>" + BUNDLE.getFormatted("aboutAction.optionPane_applicationInformation.message.customization", new Object[]{Environment.getCustomizationName(), Environment.getCustomizationVersion()}) + "<br>" + BUNDLE.getString("aboutAction.optionPane_applicationInformation.message.copyright") + "<br>" + BUNDLE.getString("aboutAction.optionPane_applicationInformation.message.runningOn") + "<br>Java: " + System.getProperty("java.version") + ", " + System.getProperty("java.vendor") + "<br>JVM: " + System.getProperty("java.vm.version") + ", " + System.getProperty("java.vm.vendor") + "<br>OS: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + ", " + System.getProperty("os.arch") + "<br><b>Kernel</b><br>" + this.portalProvider.getPortalDescription() + "<br>" + BUNDLE.getFormatted("aboutAction.optionPane_applicationInformation.message.mode", new Object[]{this.appState.getOperationMode()}) + "</p></html>", BUNDLE.getString("aboutAction.optionPane_applicationInformation.title"), -1, new ImageIcon(this.getClass().getResource("/org/opentcs/guing/res/symbols/openTCS/openTCS.300x132.gif")));
    }
}

