/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.application.action.view;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.opentcs.guing.application.OpenTCSView;
import org.opentcs.thirdparty.jhotdraw.util.ResourceBundleUtil;

public class AddBitmapAction
extends AbstractAction {
    public static final String ID = "view.addBitmap";
    private static final ResourceBundleUtil BUNDLE = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.modeling.mainMenu");
    private final JFileChooser fc;
    private final OpenTCSView view;

    public AddBitmapAction(OpenTCSView view) {
        this.view = Objects.requireNonNull(view, "view");
        this.fc = new JFileChooser(System.getProperty("opentcs.home"));
        this.fc.setFileFilter(new FileNameExtensionFilter("Bitmaps (PNG, JPG, BMP, GIF)", "png", "jpg", "bmp", "gif"));
        this.fc.setFileSelectionMode(0);
        this.putValue("Name", BUNDLE.getString("addBitmapAction.name"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int returnVal = this.fc.showOpenDialog(null);
        if (returnVal == 0) {
            File file = this.fc.getSelectedFile();
            this.view.addBackgroundBitmap(file);
        }
    }
}

