/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.application.toolbar;

import com.google.inject.assistedinject.Assisted;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.inject.Inject;
import javax.swing.JOptionPane;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.tool.CreationTool;
import org.opentcs.guing.components.drawing.figures.LabeledFigure;
import org.opentcs.guing.components.drawing.figures.ModelBasedFigure;
import org.opentcs.guing.components.layer.ActiveLayerProvider;
import org.opentcs.thirdparty.jhotdraw.util.ResourceBundleUtil;

public class OpenTCSCreationTool
extends CreationTool {
    private static final ResourceBundleUtil BUNDLE = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.modeling.toolbar");
    private final ActiveLayerProvider activeLayerProvider;

    @Inject
    public OpenTCSCreationTool(ActiveLayerProvider activeLayerProvider, @Assisted Figure prototype) {
        super(prototype);
        this.activeLayerProvider = Objects.requireNonNull(activeLayerProvider, "activeLayerProvider");
    }

    public void mousePressed(MouseEvent evt) {
        if (!this.activeLayerProvider.getActiveLayer().getLayer().isVisible() || !this.activeLayerProvider.getActiveLayer().getLayerGroup().isVisible()) {
            JOptionPane.showMessageDialog(evt.getComponent(), BUNDLE.getString("openTcsCreationTool.optionPane_activeLayerNotVisible.message"), BUNDLE.getString("openTcsCreationTool.optionPane_activeLayerNotVisible.title"), 1);
            return;
        }
        super.mousePressed(evt);
    }

    protected Figure createFigure() {
        Figure figure = super.createFigure();
        if (figure instanceof ModelBasedFigure) {
            ((ModelBasedFigure)figure).getModel().getPropertyLayerWrapper().setValue((Object)this.activeLayerProvider.getActiveLayer());
        } else if (figure instanceof LabeledFigure) {
            ((LabeledFigure)figure).getPresentationFigure().getModel().getPropertyLayerWrapper().setValue((Object)this.activeLayerProvider.getActiveLayer());
        }
        return figure;
    }
}

