/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.components.layer;

import java.util.Objects;
import javax.inject.Inject;
import org.jhotdraw.draw.Figure;
import org.opentcs.guing.components.drawing.figures.FigureConstants;
import org.opentcs.guing.components.layer.LayerEditorModeling;
import org.opentcs.guing.event.DrawingEditorEvent;
import org.opentcs.guing.event.DrawingEditorListener;
import org.opentcs.guing.model.DrawnModelComponent;
import org.opentcs.guing.model.ModelComponent;

public class LayerEditorEventHandler
implements DrawingEditorListener {
    private final LayerEditorModeling layerEditor;

    @Inject
    public LayerEditorEventHandler(LayerEditorModeling layerEditor) {
        this.layerEditor = Objects.requireNonNull(layerEditor, "layerEditor");
    }

    public void figureAdded(DrawingEditorEvent e) {
        Figure figure = e.getFigure();
        ModelComponent model = (ModelComponent)figure.get(FigureConstants.MODEL);
        if (model instanceof DrawnModelComponent) {
            this.layerEditor.add((DrawnModelComponent)model);
        }
    }

    public void figureRemoved(DrawingEditorEvent e) {
        Figure figure = e.getFigure();
        ModelComponent model = (ModelComponent)figure.get(FigureConstants.MODEL);
        if (model instanceof DrawnModelComponent) {
            this.layerEditor.remove((DrawnModelComponent)model);
        }
    }

    public void figureSelected(DrawingEditorEvent e) {
    }
}

