/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.components.layer;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.jhotdraw.draw.AbstractFigure;
import org.jhotdraw.draw.Figure;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.data.model.visualization.Layer;
import org.opentcs.data.model.visualization.LayerGroup;
import org.opentcs.guing.application.ViewManager;
import org.opentcs.guing.components.drawing.OpenTCSDrawingView;
import org.opentcs.guing.components.layer.ActiveLayerProvider;
import org.opentcs.guing.components.layer.DefaultLayerManager;
import org.opentcs.guing.components.layer.LayerEditorModeling;
import org.opentcs.guing.components.layer.LayerGroupEditorModeling;
import org.opentcs.guing.components.layer.LayerWrapper;
import org.opentcs.guing.model.DrawnModelComponent;
import org.opentcs.guing.model.ModelComponent;
import org.opentcs.util.Assertions;
import org.opentcs.util.event.EventBus;

public class LayerManagerModeling
extends DefaultLayerManager
implements LayerEditorModeling,
LayerGroupEditorModeling,
ActiveLayerProvider {
    private LayerWrapper activeLayerWrapper;

    @Inject
    public LayerManagerModeling(ViewManager viewManager, @ApplicationEventBus EventBus eventBus) {
        super(viewManager, eventBus);
    }

    @Override
    public void createLayer() {
        Layer layer = this.createLayerWrapper().getLayer();
        this.getLayerChangeListener().layerAdded();
        this.setLayerActive(layer.getId());
    }

    @Override
    public void deleteLayer(int layerId) throws IllegalArgumentException {
        Assertions.checkArgument((this.getLayerWrapper(layerId) != null ? 1 : 0) != 0, (String)"A layer with layer ID '%d' doesn't exist.", (Object[])new Object[]{layerId});
        this.deleteLayerWrapper(layerId);
        this.getLayerChangeListener().layerRemoved();
        if (layerId == this.activeLayerWrapper.getLayer().getId()) {
            this.handleActiveLayerRemoved();
        }
    }

    @Override
    public void add(DrawnModelComponent modelComponent) {
        int layerId = modelComponent.getPropertyLayerWrapper().getValue().getLayer().getId();
        Assertions.checkArgument((this.getLayerWrapper(layerId) != null ? 1 : 0) != 0, (String)"A layer with layer ID '%d' doesn't exist.", (Object[])new Object[]{layerId});
        this.addComponent(modelComponent, layerId);
    }

    @Override
    public void remove(DrawnModelComponent modelComponent) {
        this.removeComponent(modelComponent);
    }

    @Override
    public void moveLayerDown(int layerId) {
        Assertions.checkArgument((this.getLayerWrapper(layerId) != null ? 1 : 0) != 0, (String)"A layer with layer ID '%d' doesn't exist.", (Object[])new Object[]{layerId});
        List<LayerWrapper> layerWrappersByOrdinal = this.getLayerWrappers().values().stream().sorted(Comparator.comparing(wrapper -> wrapper.getLayer().getOrdinal())).collect(Collectors.toList());
        if (layerId == ((LayerWrapper)layerWrappersByOrdinal.get(0)).getLayer().getId()) {
            return;
        }
        this.shiftLayerByOne(layerId, layerWrappersByOrdinal);
        this.getLayerChangeListener().layersChanged();
    }

    @Override
    public void moveLayerUp(int layerId) {
        Assertions.checkArgument((this.getLayerWrapper(layerId) != null ? 1 : 0) != 0, (String)"A layer with layer ID '%d' doesn't exist.", (Object[])new Object[]{layerId});
        List<LayerWrapper> layerWrappersByReverseOrdinal = this.getLayerWrappers().values().stream().sorted(Comparator.comparing(wrapper -> wrapper.getLayer().getOrdinal(), Comparator.reverseOrder())).collect(Collectors.toList());
        if (layerId == ((LayerWrapper)layerWrappersByReverseOrdinal.get(0)).getLayer().getId()) {
            return;
        }
        this.shiftLayerByOne(layerId, layerWrappersByReverseOrdinal);
        this.getLayerChangeListener().layersChanged();
    }

    @Override
    public void setLayerActive(int layerId) {
        Assertions.checkArgument((this.getLayerWrapper(layerId) != null ? 1 : 0) != 0, (String)"A layer with layer ID '%d' doesn't exist.", (Object[])new Object[]{layerId});
        this.activeLayerWrapper = this.getLayerWrapper(layerId);
        this.getLayerChangeListener().layersChanged();
    }

    @Override
    public void createLayerGroup() {
        int groupId = this.getNextAvailableLayerGroupId();
        this.addLayerGroup(new LayerGroup(groupId, "Group " + groupId, true));
        this.notifyGroupAdded();
    }

    @Override
    public void deleteLayerGroup(int groupId) throws IllegalArgumentException {
        Assertions.checkArgument((this.getLayerGroup(groupId) != null ? 1 : 0) != 0, (String)"A layer group with layer group ID '%d' doesn't exist.", (Object[])new Object[]{groupId});
        Set<Integer> layerAssignedToGroup = this.getLayerWrappers().values().stream().map(wrapper -> wrapper.getLayer()).filter(layer -> layer.getGroupId() == groupId).map(layer -> layer.getId()).collect(Collectors.toSet());
        layerAssignedToGroup.forEach(layerId -> this.deleteLayer((int)layerId));
        this.removeLayerGroup(groupId);
        this.notifyGroupRemoved();
    }

    @Override
    public void setLayerGroupId(int layerId, int groupId) {
        boolean visibleAfter;
        Assertions.checkArgument((this.getLayerWrapper(layerId) != null ? 1 : 0) != 0, (String)"A layer with layer ID '%d' doesn't exist.", (Object[])new Object[]{layerId});
        Assertions.checkArgument((this.getLayerGroup(groupId) != null ? 1 : 0) != 0, (String)"A layer group with layer group ID '%d' doesn't exist.", (Object[])new Object[]{groupId});
        LayerWrapper wrapper = this.getLayerWrapper(layerId);
        boolean visibleBefore = wrapper.getLayer().isVisible() && wrapper.getLayerGroup().isVisible();
        wrapper.setLayer(wrapper.getLayer().withGroupId(groupId));
        wrapper.setLayerGroup(this.getLayerGroup(groupId));
        boolean bl = visibleAfter = wrapper.getLayer().isVisible() && wrapper.getLayerGroup().isVisible();
        if (visibleBefore != visibleAfter) {
            this.layerVisibilityChanged(wrapper.getLayer(), visibleAfter);
        }
        this.getLayerChangeListener().layersChanged();
    }

    @Override
    public LayerWrapper getActiveLayer() {
        return this.activeLayerWrapper;
    }

    protected void reset() {
        super.reset();
    }

    protected void restoreLayers() {
        this.activeLayerWrapper = this.getLayerWrappers().values().stream().sorted(Comparator.comparing(wrapper -> wrapper.getLayer().getOrdinal(), Comparator.reverseOrder())).findFirst().get();
        super.restoreLayers();
    }

    private LayerWrapper createLayerWrapper() {
        int layerId = this.getNextAvailableLayerId();
        int layerOrdinal = this.getNextAvailableLayerOrdinal();
        LayerGroup group = (LayerGroup)this.getLayerGroups().values().iterator().next();
        Layer layer = new Layer(layerId, layerOrdinal, true, "Layer " + layerId, group.getId());
        LayerWrapper wrapper = new LayerWrapper(layer, group);
        this.getComponents().put(layerId, new HashSet());
        this.addLayerWrapper(wrapper);
        return wrapper;
    }

    private int getNextAvailableLayerId() {
        return this.getLayerWrappers().values().stream().mapToInt(wrapper -> wrapper.getLayer().getId()).max().getAsInt() + 1;
    }

    private int getNextAvailableLayerOrdinal() {
        return this.getLayerWrappers().values().stream().mapToInt(wrapper -> wrapper.getLayer().getOrdinal()).max().getAsInt() + 1;
    }

    private int getNextAvailableLayerGroupId() {
        return this.getLayerGroups().values().stream().mapToInt(group -> group.getId()).max().getAsInt() + 1;
    }

    private void deleteLayerWrapper(int layerId) {
        Set<OpenTCSDrawingView> drawingViews = this.getDrawingViews();
        drawingViews.forEach(drawingView -> drawingView.getDrawing().willChange());
        Set componentsToDelete = ((Set)this.getComponents().get(layerId)).stream().map(component -> component).collect(Collectors.toSet());
        drawingViews.forEach(drawingView -> drawingView.delete(componentsToDelete));
        drawingViews.forEach(drawingView -> drawingView.getDrawing().changed());
        this.getComponents().remove(layerId);
        this.removeLayerWrapper(layerId);
    }

    private Set<OpenTCSDrawingView> getDrawingViews() {
        return this.getViewManager().getDrawingViewMap().values().stream().map(scrollPane -> scrollPane.getDrawingView()).collect(Collectors.toSet());
    }

    private void handleActiveLayerRemoved() {
        List layersByOrdinal = this.getLayerWrappers().values().stream().map(wrapper -> wrapper.getLayer()).sorted(Comparator.comparing(layer -> layer.getOrdinal())).collect(Collectors.toList());
        Optional<Layer> layerUnderRemovedActiveLayer = layersByOrdinal.stream().takeWhile(layer -> layer.getOrdinal() < this.activeLayerWrapper.getLayer().getOrdinal()).reduce((layer1, layer2) -> layer2);
        if (layerUnderRemovedActiveLayer.isPresent()) {
            this.setLayerActive(layerUnderRemovedActiveLayer.get().getId());
        } else {
            this.setLayerActive(((Layer)layersByOrdinal.get(0)).getId());
        }
    }

    private void shiftLayerByOne(int layerId, List<LayerWrapper> layers) {
        LayerWrapper layerWrapper = this.getLayerWrapper(layerId);
        int layerWrapperBeforeIndex = layers.indexOf(layerWrapper) - 1;
        LayerWrapper layerWrapperBefore = layers.get(layerWrapperBeforeIndex);
        this.swapLayerOrdinals(layerWrapper, layerWrapperBefore);
        this.updateLayerComponentsInDrawing(layerWrapper.getLayer(), layerWrapperBefore.getLayer());
    }

    private void swapLayerOrdinals(LayerWrapper layerWrapper1, LayerWrapper layerWrapper2) {
        int ordinal1 = layerWrapper1.getLayer().getOrdinal();
        int ordinal2 = layerWrapper2.getLayer().getOrdinal();
        Layer oldLayer = layerWrapper1.getLayer();
        Layer newLayer = oldLayer.withOrdinal(ordinal2);
        layerWrapper1.setLayer(newLayer);
        oldLayer = layerWrapper2.getLayer();
        newLayer = oldLayer.withOrdinal(ordinal1);
        layerWrapper2.setLayer(newLayer);
    }

    private void updateLayerComponentsInDrawing(Layer ... layers) {
        HashSet componentsToUpdate = new HashSet();
        for (Layer layer : layers) {
            if (!layer.isVisible()) continue;
            componentsToUpdate.addAll((Collection)this.getComponents().get(layer.getId()));
        }
        Set drawings = this.getDrawings();
        drawings.forEach(drawing -> drawing.willChange());
        for (DrawnModelComponent modelComponent : componentsToUpdate) {
            AbstractFigure figure = (AbstractFigure)this.getSystemModel().getFigure((ModelComponent)modelComponent);
            drawings.forEach(drawing -> {
                drawing.basicRemove((Figure)figure);
                drawing.basicAdd((Figure)figure);
            });
        }
        drawings.forEach(drawing -> drawing.changed());
    }

    private void addLayerGroup(LayerGroup layerGroup) throws IllegalArgumentException {
        int groupId = layerGroup.getId();
        Assertions.checkArgument((this.getLayerGroup(groupId) == null ? 1 : 0) != 0, (String)"A layer group for group ID '%d' already exists in the model.", (Object[])new Object[]{groupId});
        this.getLayerGroups().put(groupId, layerGroup);
    }

    private void removeLayerGroup(int groupId) {
        this.getLayerGroups().remove(groupId);
    }

    private void addLayerWrapper(LayerWrapper layerWrapper) throws IllegalArgumentException {
        int layerId = layerWrapper.getLayer().getId();
        Assertions.checkArgument((this.getLayerWrapper(layerId) == null ? 1 : 0) != 0, (String)"A layer wrapper for layer ID '%d' already exists in the model.", (Object[])new Object[]{layerId});
        this.getLayerWrappers().put(layerId, layerWrapper);
    }

    private void removeLayerWrapper(int layerId) {
        this.getLayerWrappers().remove(layerId);
    }
}

