/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.persistence;

import java.awt.Component;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Provider;
import org.opentcs.access.KernelServicePortal;
import org.opentcs.guing.application.StatusPanel;
import org.opentcs.guing.model.ModelComponent;
import org.opentcs.guing.model.SystemModel;
import org.opentcs.guing.persistence.ModelExportAdapter;
import org.opentcs.guing.persistence.ModelValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelKernelPersistor {
    private static final Logger LOG = LoggerFactory.getLogger(ModelKernelPersistor.class);
    private final StatusPanel statusPanel;
    private final Provider<ModelValidator> validatorProvider;
    private final ModelExportAdapter modelExportAdapter;

    @Inject
    public ModelKernelPersistor(@Nonnull StatusPanel statusPanel, @Nonnull Provider<ModelValidator> validatorProvider, ModelExportAdapter modelExportAdapter) {
        this.statusPanel = Objects.requireNonNull(statusPanel, "statusPanel");
        this.validatorProvider = Objects.requireNonNull(validatorProvider, "validatorProvider");
        this.modelExportAdapter = Objects.requireNonNull(modelExportAdapter, "modelExportAdapter");
    }

    public boolean persist(SystemModel systemModel, KernelServicePortal portal, boolean ignoreValidationErrors) throws IllegalStateException {
        Objects.requireNonNull(systemModel, "systemModel");
        Objects.requireNonNull(portal, "plantModelService");
        LOG.debug("Validating model...");
        long timeBefore = System.currentTimeMillis();
        if (!this.valid(systemModel) && !ignoreValidationErrors) {
            return false;
        }
        LOG.debug("Validating took {} milliseconds.", (Object)(System.currentTimeMillis() - timeBefore));
        LOG.debug("Persisting model...");
        timeBefore = System.currentTimeMillis();
        portal.getPlantModelService().createPlantModel(this.modelExportAdapter.convert(systemModel));
        LOG.debug("Persisting to kernel took {} milliseconds.", (Object)(System.currentTimeMillis() - timeBefore));
        return true;
    }

    private boolean valid(SystemModel systemModel) {
        ModelValidator validator = (ModelValidator)this.validatorProvider.get();
        boolean valid = true;
        for (ModelComponent component : systemModel.getAll()) {
            valid &= validator.isValidWith(systemModel, component);
        }
        if (!valid) {
            HashSet<String> errors = new HashSet<String>(validator.getErrors());
            validator.showSavingValidationWarning((Component)this.statusPanel, errors);
        }
        return valid;
    }
}

