/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.persistence;

import com.google.common.base.Strings;
import java.awt.Component;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.opentcs.guing.components.properties.type.AngleProperty;
import org.opentcs.guing.components.properties.type.KeyValueSetProperty;
import org.opentcs.guing.components.properties.type.LengthProperty;
import org.opentcs.guing.components.properties.type.LocationTypeProperty;
import org.opentcs.guing.components.properties.type.PercentProperty;
import org.opentcs.guing.components.properties.type.Property;
import org.opentcs.guing.components.properties.type.SpeedProperty;
import org.opentcs.guing.components.properties.type.StringProperty;
import org.opentcs.guing.components.properties.type.StringSetProperty;
import org.opentcs.guing.model.ModelComponent;
import org.opentcs.guing.model.SystemModel;
import org.opentcs.guing.model.elements.BlockModel;
import org.opentcs.guing.model.elements.LayoutModel;
import org.opentcs.guing.model.elements.LinkModel;
import org.opentcs.guing.model.elements.LocationModel;
import org.opentcs.guing.model.elements.LocationTypeModel;
import org.opentcs.guing.model.elements.PathModel;
import org.opentcs.guing.model.elements.PointModel;
import org.opentcs.guing.model.elements.VehicleModel;
import org.opentcs.guing.util.TextAreaDialog;
import org.opentcs.thirdparty.jhotdraw.util.ResourceBundleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelValidator {
    private final ResourceBundleUtil bundle = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.modeling.modelValidation");
    private final List<String> errors = new LinkedList<String>();
    private static final Logger LOG = LoggerFactory.getLogger(ModelValidator.class);

    @Inject
    public ModelValidator() {
    }

    public final List<String> getErrors() {
        return new LinkedList<String>(this.errors);
    }

    public void resetErrors() {
        this.errors.clear();
    }

    public boolean isValidWith(SystemModel model, ModelComponent component) {
        if (model == null) {
            this.errorOccurred((ModelComponent)model, "modelValidator.error_modelNull.text", new Object[0]);
            return false;
        }
        if (component == null) {
            this.errorOccurred(component, "modelValidator.error_componentNull.text", new Object[0]);
            return false;
        }
        if (Strings.isNullOrEmpty((String)component.getName())) {
            this.errorOccurred(component, "modelValidator.error_componentNameInvalid.text", component.getName());
            return false;
        }
        if (this.nameExists(model, component)) {
            this.errorOccurred(component, "modelValidator.error_componentNameExists.text", component.getName());
            return false;
        }
        KeyValueSetProperty miscellaneous = (KeyValueSetProperty)component.getProperty("Miscellaneous");
        boolean valid = true;
        if (!(component instanceof LayoutModel)) {
            if (component instanceof PointModel) {
                valid = this.validatePoint(model, (PointModel)component);
            } else if (component instanceof PathModel) {
                valid = this.validatePath(model, (PathModel)component);
            } else if (!(component instanceof LocationTypeModel)) {
                if (component instanceof LocationModel) {
                    valid = this.validateLocation(model, (LocationModel)component);
                } else if (component instanceof LinkModel) {
                    valid = this.validateLink(model, (LinkModel)component);
                } else if (component instanceof BlockModel) {
                    valid = this.validateBlock(model, (BlockModel)component);
                } else if (component instanceof VehicleModel) {
                    valid = this.validateVehicle(model, (VehicleModel)component);
                } else {
                    LOG.warn("Unknown model component {} - skipping validation.", component.getClass());
                }
            }
        }
        return valid;
    }

    public void showLoadingValidationWarning(Component parent, Collection<String> content) {
        TextAreaDialog panel = new TextAreaDialog(parent, true, this.bundle.getString("modelValidator.dialog_validationWarning.message.loadingError"));
        panel.setContent(content);
        panel.setTitle(this.bundle.getString("modelValidator.dialog_validationWarning.title"));
        panel.setLocationRelativeTo(null);
        panel.setVisible(true);
    }

    public void showSavingValidationWarning(Component parent, Collection<String> content) {
        TextAreaDialog panel = new TextAreaDialog(parent, true, this.bundle.getString("modelValidator.dialog_validationWarning.message.savingError"));
        panel.setContent(content);
        panel.setTitle(this.bundle.getString("modelValidator.dialog_validationWarning.title"));
        panel.setLocationRelativeTo(null);
        panel.setVisible(true);
    }

    public String formatDeserializationErrors(ModelComponent component, Collection<String> errors) {
        return ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.modeling.modelValidation").getFormatted("modelValidator.error_deserialization.text", new Object[]{component.getName(), errors});
    }

    private void errorOccurred(ModelComponent component, String bundleKey, Object ... args) {
        String componentName = component == null ? "null" : component.getName();
        String message = componentName + ": " + this.bundle.getFormatted(bundleKey, args);
        LOG.info(message);
        this.errors.add(message);
    }

    private boolean validatePoint(SystemModel model, PointModel point) {
        boolean valid = true;
        AngleProperty orientationProperty = (AngleProperty)point.getProperty("vehicleOrientationAngle");
        if (!(orientationProperty.getValue() instanceof Double)) {
            LOG.warn("{}: Orientation angle property ('{}') is not a number. Setting it to 0.", (Object)point.getName(), orientationProperty.getValue());
            orientationProperty.setValueAndUnit(0.0, (Enum)AngleProperty.Unit.DEG);
        } else {
            Double angle = (Double)orientationProperty.getValue();
            if (angle < 0.0) {
                LOG.warn("{}: Orientation angle property is {} but has to be > 0. Transforming to positive angle.", (Object)point.getName(), orientationProperty.getValue());
                orientationProperty.setValueAndUnit(360.0 + angle % 360.0, (Enum)AngleProperty.Unit.DEG);
            }
        }
        point.setProperty("vehicleOrientationAngle", (Property)orientationProperty);
        return valid;
    }

    private boolean validatePath(SystemModel model, PathModel path) {
        SpeedProperty maxRevVelocityProperty;
        SpeedProperty maxVelocityProperty;
        LengthProperty lengthProperty;
        StringProperty endProperty;
        boolean valid = true;
        StringProperty startProperty = (StringProperty)path.getProperty("startComponent");
        if (!this.nameExists(model, startProperty.getText())) {
            this.errorOccurred((ModelComponent)model, "modelValidator.error_pathStartComponentNotExisting.text", startProperty.getText());
            valid = false;
        }
        if (!this.nameExists(model, (endProperty = (StringProperty)path.getProperty("endComponent")).getText())) {
            this.errorOccurred((ModelComponent)model, "modelValidator.error_pathEndComponentNotExisting.text", endProperty.getText());
            valid = false;
        }
        if ((Double)(lengthProperty = (LengthProperty)path.getProperty("length")).getValue() < 1.0) {
            LOG.warn("{}: Length property is {} but has to be > 0. Setting it to 1.", (Object)path.getName(), lengthProperty.getValue());
            lengthProperty.setValueAndUnit(1.0, (Enum)LengthProperty.Unit.MM);
            path.setProperty("length", (Property)lengthProperty);
        }
        if ((Double)(maxVelocityProperty = (SpeedProperty)path.getProperty("maxVelocity")).getValue() < 0.0) {
            LOG.warn("{}: Max. velocity property is {} but has to be >= 0. Setting it to 0.", (Object)path.getName(), maxVelocityProperty.getValue());
            maxVelocityProperty.setValueAndUnit(0.0, (Enum)SpeedProperty.Unit.MM_S);
            path.setProperty("maxVelocity", (Property)maxVelocityProperty);
        }
        if ((Double)(maxRevVelocityProperty = (SpeedProperty)path.getProperty("maxReverseVelocity")).getValue() < 0.0) {
            LOG.warn("{}: Max. reverse velocity property is {} but has to be >= 0. Setting it to 0.", (Object)path.getName(), maxRevVelocityProperty.getValue());
            maxRevVelocityProperty.setValueAndUnit(0.0, (Enum)SpeedProperty.Unit.MM_S);
            path.setProperty("maxVelocity", (Property)maxRevVelocityProperty);
        }
        return valid;
    }

    private boolean validateLocation(SystemModel model, LocationModel location) {
        boolean valid = true;
        LocationTypeProperty locTypeProperty = (LocationTypeProperty)location.getProperty("Type");
        boolean locTypeExists = model.getLocationTypeModels().stream().map(type -> type.getName()).anyMatch(typeName -> typeName.equals(locTypeProperty.getValue()));
        if (!locTypeExists) {
            this.errorOccurred((ModelComponent)location, "modelValidator.error_locationTypeInvalid.text", locTypeProperty.getValue());
            valid = false;
        }
        return valid;
    }

    private boolean validateLink(SystemModel model, LinkModel link) {
        StringProperty endProperty;
        boolean valid = true;
        StringProperty startProperty = (StringProperty)link.getProperty("startComponent");
        if (!this.nameExists(model, startProperty.getText())) {
            this.errorOccurred((ModelComponent)link, "modelValidator.error_linkStartComponentNotExisting.text", startProperty.getText());
            valid = false;
        }
        if (!this.nameExists(model, (endProperty = (StringProperty)link.getProperty("endComponent")).getText())) {
            this.errorOccurred((ModelComponent)link, "modelValidator.error_linkEndComponentNotExisting.text", endProperty.getText());
            valid = false;
        }
        return valid;
    }

    private boolean validateBlock(SystemModel model, BlockModel block) {
        boolean valid = true;
        StringSetProperty elementsProperty = (StringSetProperty)block.getProperty("blockElements");
        HashSet<String> elements = new HashSet<String>();
        for (String element : elementsProperty.getItems()) {
            if (elements.contains(element)) {
                this.errorOccurred((ModelComponent)block, "modelValidator.error_blockElementsDuplicate.text", element);
                valid = false;
            }
            elements.add(element);
            if (this.nameExists(model, element)) continue;
            this.errorOccurred((ModelComponent)block, "modelValidator.error_blockElementsBotExisting.text", element);
            valid = false;
        }
        return valid;
    }

    private boolean validateVehicle(SystemModel model, VehicleModel vehicle) {
        StringProperty nextPointProperty;
        String nextPoint;
        StringProperty currentPointProperty;
        String currentPoint;
        AngleProperty orientationProperty;
        PercentProperty energyLevelProperty;
        PercentProperty energyGoodProperty;
        PercentProperty energyCriticalProperty;
        boolean valid = true;
        LengthProperty lengthProperty = (LengthProperty)vehicle.getProperty("Length");
        if ((Double)lengthProperty.getValue() < 1.0) {
            LOG.warn("{}: Length property is {} but has to be > 0. Setting it to 1.", (Object)vehicle.getName(), lengthProperty.getValue());
            lengthProperty.setValueAndUnit(1.0, (Enum)LengthProperty.Unit.MM);
            vehicle.setProperty("Length", (Property)lengthProperty);
        }
        if ((Integer)(energyCriticalProperty = (PercentProperty)vehicle.getProperty("EnergyLevelCritical")).getValue() < 0 || (Integer)energyCriticalProperty.getValue() > 100) {
            LOG.warn("{}: Energy level critical is {} but has to be in range of [0..100]. Setting it to 0.", (Object)vehicle.getName(), energyCriticalProperty.getValue());
            energyCriticalProperty.setValueAndUnit(0.0, (Enum)PercentProperty.Unit.PERCENT);
            vehicle.setProperty("EnergyLevelCritical", (Property)energyCriticalProperty);
        }
        if ((Integer)(energyGoodProperty = (PercentProperty)vehicle.getProperty("EnergyLevelGood")).getValue() < 0 || (Integer)energyGoodProperty.getValue() > 100) {
            LOG.warn("{}: Energy level good is {} but has to be in range of [0..100]. Setting it to 100.", (Object)vehicle.getName(), energyGoodProperty.getValue());
            energyGoodProperty.setValueAndUnit(100.0, (Enum)PercentProperty.Unit.PERCENT);
            vehicle.setProperty("EnergyLevelGood", (Property)energyGoodProperty);
        }
        if ((Integer)energyGoodProperty.getValue() < (Integer)energyCriticalProperty.getValue()) {
            LOG.warn("{}: Energy level good('{}') has to be >= energy level critical('{}'). Setting it to {}.", new Object[]{vehicle.getName(), energyGoodProperty.getValue(), energyCriticalProperty.getValue(), energyCriticalProperty.getValue()});
            energyGoodProperty.setValueAndUnit(energyCriticalProperty.getValueByUnit((Enum)PercentProperty.Unit.PERCENT), (Enum)PercentProperty.Unit.PERCENT);
            vehicle.setProperty("EnergyLevelGood", (Property)energyGoodProperty);
        }
        if ((Integer)(energyLevelProperty = (PercentProperty)vehicle.getProperty("EnergyLevel")).getValue() < 0 || (Integer)energyLevelProperty.getValue() > 100) {
            LOG.warn("{}: Energy level is {} but has to be in range of [0..100]. Setting it to 50.");
            energyLevelProperty.setValueAndUnit(50.0, (Enum)PercentProperty.Unit.PERCENT);
            vehicle.setProperty("EnergyLevel", (Property)energyLevelProperty);
        }
        if ((Double)(orientationProperty = (AngleProperty)vehicle.getProperty("OrientationAngle")).getValue() < 0.0) {
            LOG.warn("{}: Orientation angle is {} but has to be >= 0. Setting it to 0.");
            orientationProperty.setValueAndUnit(0.0, (Enum)AngleProperty.Unit.DEG);
            vehicle.setProperty("OrientationAngle", (Property)orientationProperty);
        }
        if (!this.isNullOrEmptyPoint(currentPoint = (currentPointProperty = (StringProperty)vehicle.getProperty("Point")).getText()) && !this.nameExists(model, currentPoint)) {
            this.errorOccurred((ModelComponent)vehicle, "modelValidator.error_vehicleCurrentPointNotExisting.text", currentPointProperty.getText());
            valid = false;
        }
        if (!this.isNullOrEmptyPoint(nextPoint = (nextPointProperty = (StringProperty)vehicle.getProperty("NextPoint")).getText()) && !this.nameExists(model, nextPoint)) {
            this.errorOccurred((ModelComponent)vehicle, "modelValidator.error_vehicleNextPointNotExisting.text", nextPointProperty.getText());
            valid = false;
        }
        return valid;
    }

    private boolean checkPropertyExists(String propertyName, ModelComponent component) {
        Property property = component.getProperty(propertyName);
        if (property == null) {
            this.errorOccurred(component, "{} property does not exist.", propertyName);
            return false;
        }
        return true;
    }

    private boolean nameExists(SystemModel model, ModelComponent component) {
        if (Strings.isNullOrEmpty((String)component.getName())) {
            return false;
        }
        ModelComponent foundComponent = model.getModelComponent(component.getName());
        return foundComponent != null && foundComponent != component;
    }

    private boolean nameExists(SystemModel model, String name) {
        if (Strings.isNullOrEmpty((String)name)) {
            return false;
        }
        return model.getModelComponent(name) != null;
    }

    private boolean isNullOrEmptyPoint(String name) {
        return Strings.isNullOrEmpty((String)name) || name.equals("null");
    }
}

