/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.thirdparty.jhotdraw.application.action.draw;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.draw.event.FigureSelectionEvent;
import org.jhotdraw.undo.CompositeEdit;

public class DefaultAttributeAction
extends AbstractSelectedAction {
    private AttributeKey[] keys;
    private Map<AttributeKey, Object> fixedAttributes;

    public DefaultAttributeAction(DrawingEditor editor, AttributeKey key) {
        this(editor, key, null, null);
    }

    public DefaultAttributeAction(DrawingEditor editor, AttributeKey key, Map<AttributeKey, Object> fixedAttributes) {
        this(editor, new AttributeKey[]{key}, null, null, fixedAttributes);
    }

    public DefaultAttributeAction(DrawingEditor editor, AttributeKey[] keys) {
        this(editor, keys, null, null);
    }

    public DefaultAttributeAction(DrawingEditor editor, AttributeKey key, Icon icon) {
        this(editor, key, null, icon);
    }

    public DefaultAttributeAction(DrawingEditor editor, AttributeKey key, String name) {
        this(editor, key, name, null);
    }

    public DefaultAttributeAction(DrawingEditor editor, AttributeKey key, String name, Icon icon) {
        this(editor, new AttributeKey[]{key}, name, icon);
    }

    public DefaultAttributeAction(DrawingEditor editor, AttributeKey[] keys, String name, Icon icon) {
        this(editor, keys, name, icon, new HashMap<AttributeKey, Object>());
    }

    public DefaultAttributeAction(DrawingEditor editor, AttributeKey[] keys, String name, Icon icon, Map<AttributeKey, Object> fixedAttributes) {
        super(editor);
        this.keys = (AttributeKey[])keys.clone();
        this.putValue("Name", name);
        this.putValue("SmallIcon", icon);
        this.setEnabled(true);
        editor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals(DefaultAttributeAction.this.keys[0].getKey())) {
                    DefaultAttributeAction.this.putValue("attribute_" + DefaultAttributeAction.this.keys[0].getKey(), evt.getNewValue());
                }
            }
        });
        this.fixedAttributes = fixedAttributes;
        this.updateEnabledState();
    }

    public void actionPerformed(ActionEvent evt) {
        if (this.getView() != null && this.getView().getSelectionCount() > 0) {
            CompositeEdit edit = new CompositeEdit("");
            this.fireUndoableEditHappened((UndoableEdit)edit);
            this.changeAttribute();
            this.fireUndoableEditHappened((UndoableEdit)edit);
        }
    }

    public void changeAttribute() {
        CompositeEdit edit = new CompositeEdit("attributes");
        this.fireUndoableEditHappened((UndoableEdit)edit);
        DrawingEditor editor = this.getEditor();
        for (Figure figure : this.getView().getSelectedFigures()) {
            figure.willChange();
            for (AttributeKey key : this.keys) {
                figure.set(key, editor.getDefaultAttribute(key));
            }
            for (Map.Entry entry : this.fixedAttributes.entrySet()) {
                figure.set((AttributeKey)entry.getKey(), entry.getValue());
            }
            figure.changed();
        }
        this.fireUndoableEditHappened((UndoableEdit)edit);
    }

    public void selectionChanged(FigureSelectionEvent evt) {
    }
}

