/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.thirdparty.jhotdraw.application.toolbar;

import com.google.inject.assistedinject.Assisted;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Objects;
import javax.inject.Inject;
import javax.swing.JOptionPane;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.tool.ConnectionTool;
import org.opentcs.guing.components.drawing.figures.FigureConstants;
import org.opentcs.guing.components.drawing.figures.LabeledLocationFigure;
import org.opentcs.guing.components.drawing.figures.LinkConnection;
import org.opentcs.guing.components.drawing.figures.ModelBasedFigure;
import org.opentcs.guing.components.drawing.figures.SimpleLineConnection;
import org.opentcs.guing.components.layer.ActiveLayerProvider;
import org.opentcs.guing.components.layer.LayerWrapper;
import org.opentcs.guing.model.AbstractConnectableModelComponent;
import org.opentcs.guing.model.ConnectableModelComponent;
import org.opentcs.thirdparty.jhotdraw.util.ResourceBundleUtil;

public class OpenTCSConnectionTool
extends ConnectionTool {
    private static final ResourceBundleUtil BUNDLE = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.modeling.toolbar");
    private final ActiveLayerProvider activeLayerProvider;
    private final String presentationName;

    @Inject
    public OpenTCSConnectionTool(ActiveLayerProvider activeLayerProvider, @Assisted ConnectionFigure prototype) {
        super(prototype);
        this.activeLayerProvider = Objects.requireNonNull(activeLayerProvider, "activeLayerProvider");
        this.presentationName = BUNDLE.getString("openTcsConnectionTool.undo.presentationName");
    }

    public void mousePressed(MouseEvent evt) {
        if (!this.activeLayerProvider.getActiveLayer().getLayer().isVisible() || !this.activeLayerProvider.getActiveLayer().getLayer().isVisible()) {
            JOptionPane.showMessageDialog(evt.getComponent(), BUNDLE.getString("openTcsConnectionTool.optionPane_activeLayerNotVisible.message"), BUNDLE.getString("openTcsConnectionTool.optionPane_activeLayerNotVisible.title"), 1);
            return;
        }
        super.mousePressed(evt);
    }

    public void mouseReleased(MouseEvent event) {
        if (!this.isValidConnection()) {
            this.removeCreatedFigure();
            return;
        }
        this.createdFigure.willChange();
        this.createdFigure.setStartConnector(this.startConnector);
        this.createdFigure.setEndConnector(this.endConnector);
        if (this.createdFigure instanceof SimpleLineConnection) {
            ((SimpleLineConnection)this.createdFigure).getModel().updateName();
        }
        this.createdFigure.changed();
        ConnectionFigure addedFigure = this.createdFigure;
        final Drawing addedDrawing = this.getDrawing();
        this.getDrawing().fireUndoableEditHappened((UndoableEdit)new AbstractUndoableEdit((Figure)addedFigure){
            final /* synthetic */ Figure val$addedFigure;
            {
                this.val$addedFigure = figure;
            }

            @Override
            public String getPresentationName() {
                return OpenTCSConnectionTool.this.presentationName;
            }

            @Override
            public void undo() throws CannotUndoException {
                super.undo();
                addedDrawing.remove(this.val$addedFigure);
            }

            @Override
            public void redo() throws CannotRedoException {
                super.redo();
                addedDrawing.add(this.val$addedFigure);
            }
        });
        this.targetFigure = null;
        Point2D.Double cAnchor = this.startConnector.getAnchor();
        Rectangle r = new Rectangle(this.getView().drawingToView(cAnchor));
        r.grow(this.getAnchorWidth(), this.getAnchorWidth());
        this.fireAreaInvalidated(r);
        cAnchor = this.endConnector.getAnchor();
        r = new Rectangle(this.getView().drawingToView(cAnchor));
        r.grow(this.getAnchorWidth(), this.getAnchorWidth());
        this.fireAreaInvalidated(r);
        this.startConnector = null;
        this.endConnector = null;
        ConnectionFigure finishedFigure = this.createdFigure;
        this.createdFigure = null;
        this.creationFinished((Figure)finishedFigure);
    }

    protected ConnectionFigure createFigure() {
        ConnectionFigure figure = super.createFigure();
        if (figure instanceof ModelBasedFigure) {
            if (figure instanceof LinkConnection) {
                LayerWrapper locationLayer = ((LabeledLocationFigure)this.startConnector.getOwner()).getPresentationFigure().getModel().getPropertyLayerWrapper().getValue();
                ((ModelBasedFigure)figure).getModel().getPropertyLayerWrapper().setValue((Object)locationLayer);
            } else {
                ((ModelBasedFigure)figure).getModel().getPropertyLayerWrapper().setValue((Object)this.activeLayerProvider.getActiveLayer());
            }
        }
        return figure;
    }

    private void removeCreatedFigure() {
        if (this.createdFigure != null) {
            this.getDrawing().remove((Figure)this.createdFigure);
            Point2D.Double cAnchor = this.startConnector.getAnchor();
            Rectangle r = new Rectangle(this.getView().drawingToView(cAnchor));
            r.grow(this.getAnchorWidth(), this.getAnchorWidth());
            this.fireAreaInvalidated(r);
            r = new Rectangle(this.getView().drawingToView(cAnchor));
            r.grow(this.getAnchorWidth(), this.getAnchorWidth());
            this.fireAreaInvalidated(r);
            this.startConnector = null;
            this.endConnector = null;
            this.createdFigure = null;
        }
        if (this.isToolDoneAfterCreation()) {
            this.fireToolDone();
        }
    }

    private boolean isValidConnection() {
        return this.canConnect() && !this.connectionAlreadyPresent();
    }

    private boolean connectionAlreadyPresent() {
        AbstractConnectableModelComponent startComponent = (AbstractConnectableModelComponent)this.startConnector.getOwner().get(FigureConstants.MODEL);
        AbstractConnectableModelComponent endComponent = (AbstractConnectableModelComponent)this.endConnector.getOwner().get(FigureConstants.MODEL);
        return startComponent != null && endComponent != null && startComponent.hasConnectionTo((ConnectableModelComponent)endComponent);
    }

    private boolean canConnect() {
        return this.createdFigure != null && this.startConnector != null && this.endConnector != null && this.createdFigure.canConnect(this.startConnector, this.endConnector);
    }
}

