/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.modeleditor;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import org.opentcs.configuration.ConfigurationBindingProvider;
import org.opentcs.configuration.cfg4j.Cfg4jConfigurationBindingProvider;
import org.opentcs.customizations.plantoverview.PlantOverviewInjectionModule;
import org.opentcs.guing.common.util.CompatibilityChecker;
import org.opentcs.modeleditor.DefaultPlantOverviewInjectionModule;
import org.opentcs.modeleditor.application.PlantOverviewStarter;
import org.opentcs.util.Environment;
import org.opentcs.util.logging.UncaughtExceptionLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunModelEditor {
    private static final Logger LOG = LoggerFactory.getLogger(RunModelEditor.class);

    private RunModelEditor() {
    }

    public static void main(String[] args) {
        System.setSecurityManager(new SecurityManager());
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new UncaughtExceptionLogger(false));
        Environment.logSystemInfo();
        RunModelEditor.ensureVersionCompatibility();
        Injector injector = Guice.createInjector((Module[])new Module[]{RunModelEditor.customConfigurationModule()});
        ((PlantOverviewStarter)injector.getInstance(PlantOverviewStarter.class)).startPlantOverview();
    }

    private static void ensureVersionCompatibility() {
        String version = System.getProperty("java.version");
        if (!CompatibilityChecker.versionCompatibleWithDockingFrames((String)version)) {
            LOG.error("Version incompatible with Docking Frames: '{}'", (Object)version);
            CompatibilityChecker.showVersionIncompatibleWithDockingFramesMessage();
            System.exit(1);
        }
    }

    private static Module customConfigurationModule() {
        ConfigurationBindingProvider bindingProvider = RunModelEditor.configurationBindingProvider();
        DefaultPlantOverviewInjectionModule plantOverviewInjectionModule = new DefaultPlantOverviewInjectionModule();
        plantOverviewInjectionModule.setConfigBindingProvider(bindingProvider);
        return Modules.override((Module[])new Module[]{plantOverviewInjectionModule}).with(RunModelEditor.findRegisteredModules(bindingProvider));
    }

    private static List<PlantOverviewInjectionModule> findRegisteredModules(ConfigurationBindingProvider bindingProvider) {
        LinkedList<PlantOverviewInjectionModule> registeredModules = new LinkedList<PlantOverviewInjectionModule>();
        for (PlantOverviewInjectionModule module : ServiceLoader.load(PlantOverviewInjectionModule.class)) {
            LOG.info("Integrating injection module {} (source: {})", (Object)module.getClass().getName(), (Object)module.getClass().getProtectionDomain().getCodeSource());
            module.setConfigBindingProvider(bindingProvider);
            registeredModules.add(module);
        }
        return registeredModules;
    }

    private static ConfigurationBindingProvider configurationBindingProvider() {
        return new Cfg4jConfigurationBindingProvider(Paths.get(System.getProperty("opentcs.base", "."), "config", "opentcs-modeleditor-defaults-baseline.properties").toAbsolutePath(), new Path[]{Paths.get(System.getProperty("opentcs.base", "."), "config", "opentcs-modeleditor-defaults-custom.properties").toAbsolutePath(), Paths.get(System.getProperty("opentcs.home", "."), "config", "opentcs-modeleditor.properties").toAbsolutePath()});
    }
}

