/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.modeleditor.application.menus;

import com.google.inject.assistedinject.Assisted;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import javax.inject.Inject;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.guing.base.components.properties.event.AttributesChangeListener;
import org.opentcs.guing.base.components.properties.event.NullAttributesChangeListener;
import org.opentcs.guing.base.components.properties.type.CoordinateProperty;
import org.opentcs.guing.base.components.properties.type.LengthProperty;
import org.opentcs.guing.base.components.properties.type.StringProperty;
import org.opentcs.guing.base.model.ModelComponent;
import org.opentcs.guing.base.model.elements.LocationModel;
import org.opentcs.guing.base.model.elements.PointModel;
import org.opentcs.guing.common.components.drawing.OpenTCSDrawingEditor;
import org.opentcs.guing.common.components.drawing.figures.FigureConstants;
import org.opentcs.guing.common.event.ResetInteractionToolCommand;
import org.opentcs.modeleditor.application.menus.LayoutToModelCoordinateUndoActivity;
import org.opentcs.modeleditor.application.menus.MenuItemComponentsFactory;
import org.opentcs.thirdparty.guing.common.jhotdraw.application.action.edit.UndoRedoManager;
import org.opentcs.thirdparty.guing.common.jhotdraw.util.ResourceBundleUtil;
import org.opentcs.util.event.EventHandler;

public class LayoutToModelMenuItem
extends JMenuItem {
    private final DrawingEditor drawingEditor;
    private final UndoRedoManager undoRedoManager;
    private final EventHandler eventHandler;
    private final MenuItemComponentsFactory componentsFactory;
    private final boolean copyAll;

    @Inject
    public LayoutToModelMenuItem(OpenTCSDrawingEditor drawingEditor, UndoRedoManager undoRedoManager, @ApplicationEventBus EventHandler eventHandler, MenuItemComponentsFactory componentsFactory, @Assisted boolean copyAll) {
        super(ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.modeling.mainMenu").getString("layoutToModelMenuItem.text"));
        this.drawingEditor = (DrawingEditor)Objects.requireNonNull(drawingEditor, "drawingEditor");
        this.undoRedoManager = Objects.requireNonNull(undoRedoManager, "undoRedoManager");
        this.eventHandler = Objects.requireNonNull(eventHandler, "eventHandler");
        this.componentsFactory = Objects.requireNonNull(componentsFactory, "componentsFactory");
        this.copyAll = copyAll;
        this.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("org/opentcs/guing/res/symbols/menu/arrow-up-3.png")));
        this.setMargin(new Insets(0, 2, 0, 2));
        this.addActionListener();
    }

    private void addActionListener() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (Figure figure : LayoutToModelMenuItem.this.copyAll ? LayoutToModelMenuItem.this.getView().getDrawing().getFiguresFrontToBack() : LayoutToModelMenuItem.this.getView().getSelectedFigures()) {
                    ModelComponent model = (ModelComponent)figure.get(FigureConstants.MODEL);
                    if (!(model instanceof PointModel) && !(model instanceof LocationModel)) continue;
                    LayoutToModelMenuItem.this.updateModelX(model);
                    LayoutToModelMenuItem.this.updateModelY(model);
                    model.propertiesChanged((AttributesChangeListener)new NullAttributesChangeListener());
                    LayoutToModelMenuItem.this.eventHandler.onEvent((Object)new ResetInteractionToolCommand((Object)this));
                }
            }
        });
    }

    private DrawingView getView() {
        return this.drawingEditor.getActiveView();
    }

    private void updateModelY(ModelComponent model) throws IllegalArgumentException {
        CoordinateProperty modelProperty = model instanceof PointModel ? (CoordinateProperty)model.getProperty("modelYPosition") : (CoordinateProperty)model.getProperty("modelYPosition");
        LayoutToModelCoordinateUndoActivity cua = this.componentsFactory.createLayoutToModelCoordinateUndoActivity(modelProperty);
        cua.snapShotBeforeModification();
        StringProperty spy = model instanceof PointModel ? (StringProperty)model.getProperty("POSITION_Y") : (StringProperty)model.getProperty("POSITION_Y");
        if (!spy.getText().isEmpty()) {
            modelProperty.setValueAndUnit(Double.parseDouble(spy.getText()), (Enum)((LengthProperty.Unit)modelProperty.getUnit()));
            modelProperty.markChanged();
        }
        cua.snapShotAfterModification();
        this.undoRedoManager.addEdit((UndoableEdit)((Object)cua));
    }

    private void updateModelX(ModelComponent model) throws IllegalArgumentException {
        CoordinateProperty modelProperty = model instanceof PointModel ? (CoordinateProperty)model.getProperty("modelXPosition") : (CoordinateProperty)model.getProperty("modelXPosition");
        LayoutToModelCoordinateUndoActivity cua = this.componentsFactory.createLayoutToModelCoordinateUndoActivity(modelProperty);
        cua.snapShotBeforeModification();
        StringProperty spx = model instanceof PointModel ? (StringProperty)model.getProperty("POSITION_X") : (StringProperty)model.getProperty("POSITION_X");
        if (!spx.getText().isEmpty()) {
            modelProperty.setValueAndUnit(Double.parseDouble(spx.getText()), (Enum)((LengthProperty.Unit)modelProperty.getUnit()));
            modelProperty.markChanged();
        }
        cua.snapShotAfterModification();
        this.undoRedoManager.addEdit((UndoableEdit)((Object)cua));
    }
}

