/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.modeleditor.application.menus;

import com.google.inject.assistedinject.Assisted;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import javax.inject.Inject;
import org.opentcs.guing.base.components.properties.type.CoordinateProperty;
import org.opentcs.guing.base.components.properties.type.LengthProperty;
import org.opentcs.guing.base.components.properties.type.StringProperty;
import org.opentcs.guing.base.model.AbstractConnectableModelComponent;
import org.opentcs.guing.common.components.drawing.course.Origin;
import org.opentcs.guing.common.components.drawing.figures.FigureConstants;
import org.opentcs.guing.common.components.drawing.figures.TCSFigure;
import org.opentcs.guing.common.components.properties.CoordinateUndoActivity;
import org.opentcs.guing.common.persistence.ModelManager;
import org.opentcs.thirdparty.guing.common.jhotdraw.util.ResourceBundleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelToLayoutCoordinateUndoActivity
extends CoordinateUndoActivity {
    private static final Logger LOG = LoggerFactory.getLogger(ModelToLayoutCoordinateUndoActivity.class);

    @Inject
    public ModelToLayoutCoordinateUndoActivity(@Assisted CoordinateProperty property, ModelManager modelManager) {
        super(property, modelManager);
    }

    public String getPresentationName() {
        return ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.modeling.miscellaneous").getString("modelToLayoutCoordinateUndoActivity.presentationName");
    }

    protected void saveTransformBeforeModification() {
        AbstractConnectableModelComponent model = (AbstractConnectableModelComponent)this.property.getModel();
        StringProperty pxLayout = (StringProperty)model.getProperty("POSITION_X");
        StringProperty pyLayout = (StringProperty)model.getProperty("POSITION_Y");
        Origin origin = (Origin)this.bufferedFigure.get(FigureConstants.ORIGIN);
        TCSFigure pf = this.bufferedFigure.getPresentationFigure();
        double zoomScale = pf.getZoomPoint().scale();
        double xModel = this.pxModel.getValueByUnit((Enum)LengthProperty.Unit.MM) / (zoomScale * origin.getScaleX());
        double yModel = this.pyModel.getValueByUnit((Enum)LengthProperty.Unit.MM) / (-zoomScale * origin.getScaleY());
        String sx = (String)pxLayout.getComparableValue();
        double xLayout = Double.parseDouble(sx) / (zoomScale * origin.getScaleX());
        String sy = (String)pyLayout.getComparableValue();
        double yLayout = Double.parseDouble(sy) / (-zoomScale * origin.getScaleY());
        this.bufferedTransform.translate(xModel - xLayout, yModel - yLayout);
    }

    protected void saveTransformForUndo() {
        try {
            AffineTransform inverse = this.bufferedTransform.createInverse();
            this.bufferedFigure.willChange();
            this.bufferedFigure.transform(inverse);
            this.bufferedFigure.changed();
        }
        catch (NoninvertibleTransformException e) {
            LOG.warn("Exception inverting transform.", (Throwable)e);
        }
    }

    protected void saveTransformForRedo() {
        this.bufferedFigure.willChange();
        this.bufferedFigure.transform(this.bufferedTransform);
        this.bufferedFigure.changed();
    }
}

