/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.modeleditor.persistence;

import java.awt.Component;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Provider;
import org.opentcs.access.to.model.BlockCreationTO;
import org.opentcs.access.to.model.LocationCreationTO;
import org.opentcs.access.to.model.LocationTypeCreationTO;
import org.opentcs.access.to.model.PathCreationTO;
import org.opentcs.access.to.model.PlantModelCreationTO;
import org.opentcs.access.to.model.PointCreationTO;
import org.opentcs.access.to.model.VehicleCreationTO;
import org.opentcs.access.to.model.VisualLayoutCreationTO;
import org.opentcs.guing.base.components.properties.type.KeyValueProperty;
import org.opentcs.guing.base.components.properties.type.Property;
import org.opentcs.guing.base.model.ModelComponent;
import org.opentcs.guing.base.model.elements.BlockModel;
import org.opentcs.guing.base.model.elements.LayoutModel;
import org.opentcs.guing.base.model.elements.LinkModel;
import org.opentcs.guing.base.model.elements.LocationModel;
import org.opentcs.guing.base.model.elements.LocationTypeModel;
import org.opentcs.guing.base.model.elements.PathModel;
import org.opentcs.guing.base.model.elements.PointModel;
import org.opentcs.guing.base.model.elements.VehicleModel;
import org.opentcs.guing.common.application.StatusPanel;
import org.opentcs.guing.common.model.SystemModel;
import org.opentcs.modeleditor.persistence.ModelValidator;
import org.opentcs.modeleditor.persistence.unified.PlantModelElementConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelImportAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(ModelImportAdapter.class);
    private final Provider<SystemModel> systemModelProvider;
    private final PlantModelElementConverter elementConverter;
    private final ModelValidator validator;
    private final StatusPanel statusPanel;

    @Inject
    public ModelImportAdapter(Provider<SystemModel> systemModelProvider, PlantModelElementConverter elementConverter, ModelValidator validator, StatusPanel statusPanel) {
        this.systemModelProvider = Objects.requireNonNull(systemModelProvider, "systemModelProvider");
        this.elementConverter = Objects.requireNonNull(elementConverter, "elementConverter");
        this.validator = Objects.requireNonNull(validator, "validator");
        this.statusPanel = Objects.requireNonNull(statusPanel, "statusPanel");
    }

    @Nonnull
    public SystemModel convert(PlantModelCreationTO model) throws IllegalArgumentException {
        Objects.requireNonNull(model, "model");
        SystemModel systemModel = (SystemModel)this.systemModelProvider.get();
        systemModel.setName(model.getName());
        VisualLayoutCreationTO layoutTO = model.getVisualLayout();
        HashSet<String> collectedErrorMessages = new HashSet<String>();
        this.importVisualLayout(layoutTO, systemModel, collectedErrorMessages);
        this.importPoints(model, systemModel, collectedErrorMessages);
        this.importPaths(model, systemModel, collectedErrorMessages);
        this.importVehicles(model, systemModel, collectedErrorMessages);
        this.importLocationTypes(model, systemModel, collectedErrorMessages);
        this.importLocations(model, systemModel, collectedErrorMessages);
        this.importBlocks(model, systemModel, collectedErrorMessages);
        this.importProperties(model, systemModel);
        if (!collectedErrorMessages.isEmpty()) {
            this.validator.showLoadingValidationWarning((Component)this.statusPanel, collectedErrorMessages);
        }
        return systemModel;
    }

    private void importProperties(PlantModelCreationTO model, SystemModel systemModel) {
        for (Map.Entry property : model.getProperties().entrySet()) {
            systemModel.getPropertyMiscellaneous().addItem(new KeyValueProperty((ModelComponent)systemModel, (String)property.getKey(), (String)property.getValue()));
        }
    }

    private void importVisualLayout(VisualLayoutCreationTO layoutTO, SystemModel systemModel, Set<String> collectedErrorMessages) {
        LayoutModel layoutModel = this.elementConverter.importLayout(layoutTO);
        if (this.validModelComponent((ModelComponent)layoutModel, systemModel, collectedErrorMessages)) {
            this.updateLayoutInModel(layoutModel, systemModel);
        }
    }

    private void importBlocks(PlantModelCreationTO model, SystemModel systemModel, Set<String> collectedErrorMessages) {
        for (BlockCreationTO blockTO : model.getBlocks()) {
            BlockModel blockModel = this.elementConverter.importBlock(blockTO);
            if (!this.validModelComponent((ModelComponent)blockModel, systemModel, collectedErrorMessages)) continue;
            this.addBlockToModel(blockModel, systemModel);
        }
    }

    private void importLocations(PlantModelCreationTO model, SystemModel systemModel, Set<String> collectedErrorMessages) {
        for (LocationCreationTO locationTO : model.getLocations()) {
            LocationModel locationModel = this.elementConverter.importLocation(locationTO, model.getLocationTypes(), systemModel);
            if (!this.validModelComponent((ModelComponent)locationModel, systemModel, collectedErrorMessages)) continue;
            this.addLocationToModel(locationModel, systemModel);
            for (Map.Entry entry : locationTO.getLinks().entrySet()) {
                LinkModel linkModel = this.elementConverter.importLocationLink(locationTO, (String)entry.getKey(), (Set)entry.getValue(), systemModel);
                if (!this.validModelComponent((ModelComponent)linkModel, systemModel, collectedErrorMessages)) continue;
                this.addLinkToModel(linkModel, systemModel);
            }
        }
    }

    private void importLocationTypes(PlantModelCreationTO model, SystemModel systemModel, Set<String> collectedErrorMessages) {
        for (LocationTypeCreationTO locTypeTO : model.getLocationTypes()) {
            LocationTypeModel locTypeModel = this.elementConverter.importLocationType(locTypeTO);
            if (!this.validModelComponent((ModelComponent)locTypeModel, systemModel, collectedErrorMessages)) continue;
            this.addLocationTypeToModel(locTypeModel, systemModel);
        }
    }

    private void importVehicles(PlantModelCreationTO model, SystemModel systemModel, Set<String> collectedErrorMessages) {
        for (VehicleCreationTO vehicleTO : model.getVehicles()) {
            VehicleModel vehicleModel = this.elementConverter.importVehicle(vehicleTO);
            if (!this.validModelComponent((ModelComponent)vehicleModel, systemModel, collectedErrorMessages)) continue;
            this.addVehicleToModel(vehicleModel, systemModel);
        }
    }

    private void importPaths(PlantModelCreationTO model, SystemModel systemModel, Set<String> collectedErrorMessages) {
        for (PathCreationTO pathTO : model.getPaths()) {
            PathModel pathModel = this.elementConverter.importPath(pathTO, systemModel);
            if (!this.validModelComponent((ModelComponent)pathModel, systemModel, collectedErrorMessages)) continue;
            this.addPathToModel(pathModel, systemModel);
        }
    }

    private void importPoints(PlantModelCreationTO model, SystemModel systemModel, Set<String> collectedErrorMessages) {
        for (PointCreationTO pointTO : model.getPoints()) {
            PointModel pointModel = this.elementConverter.importPoint(pointTO, systemModel);
            if (!this.validModelComponent((ModelComponent)pointModel, systemModel, collectedErrorMessages)) continue;
            this.addPointToModel(pointModel, systemModel);
        }
    }

    private boolean validModelComponent(ModelComponent modelComponent, SystemModel systemModel, Set<String> collectedErrorMessages) {
        if (this.validator.isValidWith(systemModel, modelComponent)) {
            return true;
        }
        String deserializationError = this.validator.formatDeserializationErrors(modelComponent, this.validator.getErrors());
        this.validator.formatDeserializationErrors(modelComponent, this.validator.getErrors());
        this.validator.resetErrors();
        LOG.warn("Deserialization error: {}", (Object)deserializationError);
        collectedErrorMessages.add(deserializationError);
        return false;
    }

    private void addPointToModel(PointModel point, SystemModel systemModel) {
        systemModel.getMainFolder(SystemModel.FolderKey.POINTS).add((ModelComponent)point);
    }

    private void addPathToModel(PathModel path, SystemModel systemModel) {
        systemModel.getMainFolder(SystemModel.FolderKey.PATHS).add((ModelComponent)path);
    }

    private void addVehicleToModel(VehicleModel vehicle, SystemModel systemModel) {
        systemModel.getMainFolder(SystemModel.FolderKey.VEHICLES).add((ModelComponent)vehicle);
    }

    private void addLocationTypeToModel(LocationTypeModel locType, SystemModel systemModel) {
        systemModel.getMainFolder(SystemModel.FolderKey.LOCATION_TYPES).add((ModelComponent)locType);
    }

    private void addLocationToModel(LocationModel location, SystemModel systemModel) {
        systemModel.getMainFolder(SystemModel.FolderKey.LOCATIONS).add((ModelComponent)location);
    }

    private void addLinkToModel(LinkModel link, SystemModel systemModel) {
        systemModel.getMainFolder(SystemModel.FolderKey.LINKS).add((ModelComponent)link);
    }

    private void addBlockToModel(BlockModel block, SystemModel systemModel) {
        systemModel.getMainFolder(SystemModel.FolderKey.BLOCKS).add((ModelComponent)block);
    }

    private void updateLayoutInModel(LayoutModel layout, SystemModel systemModel) {
        ModelComponent layoutComponent = systemModel.getMainFolder(SystemModel.FolderKey.LAYOUT);
        for (Map.Entry property : layout.getProperties().entrySet()) {
            layoutComponent.setProperty((String)property.getKey(), (Property)property.getValue());
        }
    }
}

