/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.modeleditor.persistence.unified;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opentcs.access.to.model.BlockCreationTO;
import org.opentcs.access.to.model.LocationCreationTO;
import org.opentcs.access.to.model.LocationTypeCreationTO;
import org.opentcs.access.to.model.PathCreationTO;
import org.opentcs.access.to.model.PointCreationTO;
import org.opentcs.access.to.model.VehicleCreationTO;
import org.opentcs.access.to.model.VisualLayoutCreationTO;
import org.opentcs.access.to.peripherals.PeripheralOperationCreationTO;
import org.opentcs.data.model.Block;
import org.opentcs.data.model.Point;
import org.opentcs.data.model.visualization.Layer;
import org.opentcs.data.model.visualization.LayerGroup;
import org.opentcs.data.model.visualization.LocationRepresentation;
import org.opentcs.guing.base.components.layer.LayerWrapper;
import org.opentcs.guing.base.components.properties.type.AngleProperty;
import org.opentcs.guing.base.components.properties.type.KeyValueProperty;
import org.opentcs.guing.base.components.properties.type.LengthProperty;
import org.opentcs.guing.base.components.properties.type.PercentProperty;
import org.opentcs.guing.base.components.properties.type.SpeedProperty;
import org.opentcs.guing.base.model.ModelComponent;
import org.opentcs.guing.base.model.PeripheralOperationModel;
import org.opentcs.guing.base.model.elements.BlockModel;
import org.opentcs.guing.base.model.elements.LayoutModel;
import org.opentcs.guing.base.model.elements.LinkModel;
import org.opentcs.guing.base.model.elements.LocationModel;
import org.opentcs.guing.base.model.elements.LocationTypeModel;
import org.opentcs.guing.base.model.elements.PathModel;
import org.opentcs.guing.base.model.elements.PointModel;
import org.opentcs.guing.base.model.elements.VehicleModel;
import org.opentcs.guing.common.model.SystemModel;

public class PlantModelElementConverter {
    public PointModel importPoint(PointCreationTO pointTO, SystemModel systemModel) {
        Objects.requireNonNull(pointTO, "pointTO");
        Objects.requireNonNull(systemModel, "systemModel");
        PointModel model = new PointModel();
        model.setName(pointTO.getName());
        model.getPropertyModelPositionX().setValueAndUnit((double)pointTO.getPosition().getX(), (Enum)LengthProperty.Unit.MM);
        model.getPropertyModelPositionY().setValueAndUnit((double)pointTO.getPosition().getY(), (Enum)LengthProperty.Unit.MM);
        model.getPropertyVehicleOrientationAngle().setValueAndUnit(pointTO.getVehicleOrientationAngle(), (Enum)AngleProperty.Unit.DEG);
        model.getPropertyType().setValue((Object)this.mapPointType(pointTO.getType()));
        for (Map.Entry property : pointTO.getProperties().entrySet()) {
            model.getPropertyMiscellaneous().addItem(new KeyValueProperty((ModelComponent)model, (String)property.getKey(), (String)property.getValue()));
        }
        model.getPropertyLayoutPosX().setText(String.valueOf(pointTO.getLayout().getPosition().getX()));
        model.getPropertyLayoutPosY().setText(String.valueOf(pointTO.getLayout().getPosition().getY()));
        model.getPropertyPointLabelOffsetX().setText(String.valueOf(pointTO.getLayout().getLabelOffset().getX()));
        model.getPropertyPointLabelOffsetY().setText(String.valueOf(pointTO.getLayout().getLabelOffset().getY()));
        model.getPropertyPointLabelOrientationAngle().setText("");
        LayerWrapper layerWrapper = (LayerWrapper)systemModel.getLayoutModel().getPropertyLayerWrappers().getValue().get(pointTO.getLayout().getLayerId());
        model.getPropertyLayerWrapper().setValue((Object)layerWrapper);
        return model;
    }

    public PathModel importPath(PathCreationTO pathTO, SystemModel systemModel) {
        PathModel model = new PathModel();
        model.setName(pathTO.getName());
        model.getPropertyLength().setValueAndUnit((double)pathTO.getLength(), (Enum)LengthProperty.Unit.MM);
        model.getPropertyMaxVelocity().setValueAndUnit((double)pathTO.getMaxVelocity(), (Enum)SpeedProperty.Unit.MM_S);
        model.getPropertyMaxReverseVelocity().setValueAndUnit((double)pathTO.getMaxReverseVelocity(), (Enum)SpeedProperty.Unit.MM_S);
        model.getPropertyStartComponent().setText(pathTO.getSrcPointName());
        model.getPropertyEndComponent().setText(pathTO.getDestPointName());
        model.getPropertyLocked().setValue((Object)pathTO.isLocked());
        for (Map.Entry property : pathTO.getProperties().entrySet()) {
            model.getPropertyMiscellaneous().addItem(new KeyValueProperty((ModelComponent)model, (String)property.getKey(), (String)property.getValue()));
        }
        for (PeripheralOperationCreationTO operationTO : pathTO.getPeripheralOperations()) {
            model.getPropertyPeripheralOperations().getValue().add(new PeripheralOperationModel(operationTO.getLocationName(), operationTO.getOperation(), operationTO.getExecutionTrigger(), operationTO.isCompletionRequired()));
        }
        model.getPropertyPathConnType().setValue((Object)PathModel.Type.valueOf((String)pathTO.getLayout().getConnectionType().name()));
        model.getPropertyPathControlPoints().setText(pathTO.getLayout().getControlPoints().stream().map(controlPoint -> String.format("%d,%d", controlPoint.getX(), controlPoint.getY())).collect(Collectors.joining(";")));
        LayerWrapper layerWrapper = (LayerWrapper)systemModel.getLayoutModel().getPropertyLayerWrappers().getValue().get(pathTO.getLayout().getLayerId());
        model.getPropertyLayerWrapper().setValue((Object)layerWrapper);
        return model;
    }

    public VehicleModel importVehicle(VehicleCreationTO vehicleTO) {
        VehicleModel model = new VehicleModel();
        model.setName(vehicleTO.getName());
        model.getPropertyLength().setValueAndUnit((double)vehicleTO.getLength(), (Enum)LengthProperty.Unit.MM);
        model.getPropertyMaxVelocity().setValueAndUnit((double)vehicleTO.getMaxVelocity(), (Enum)SpeedProperty.Unit.MM_S);
        model.getPropertyMaxReverseVelocity().setValueAndUnit((double)vehicleTO.getMaxReverseVelocity(), (Enum)SpeedProperty.Unit.MM_S);
        model.getPropertyEnergyLevelCritical().setValueAndUnit((double)vehicleTO.getEnergyLevelCritical(), (Enum)PercentProperty.Unit.PERCENT);
        model.getPropertyEnergyLevelGood().setValueAndUnit((double)vehicleTO.getEnergyLevelGood(), (Enum)PercentProperty.Unit.PERCENT);
        model.getPropertyEnergyLevelFullyRecharged().setValueAndUnit((double)vehicleTO.getEnergyLevelFullyRecharged(), (Enum)PercentProperty.Unit.PERCENT);
        model.getPropertyEnergyLevelSufficientlyRecharged().setValueAndUnit((double)vehicleTO.getEnergyLevelSufficientlyRecharged(), (Enum)PercentProperty.Unit.PERCENT);
        for (Map.Entry property : vehicleTO.getProperties().entrySet()) {
            model.getPropertyMiscellaneous().addItem(new KeyValueProperty((ModelComponent)model, (String)property.getKey(), (String)property.getValue()));
        }
        model.getPropertyRouteColor().setColor(vehicleTO.getLayout().getRouteColor());
        return model;
    }

    public LocationTypeModel importLocationType(LocationTypeCreationTO locTypeTO) {
        LocationTypeModel model = new LocationTypeModel();
        model.setName(locTypeTO.getName());
        for (String string : locTypeTO.getAllowedOperations()) {
            model.getPropertyAllowedOperations().addItem(string);
        }
        for (String string : locTypeTO.getAllowedPeripheralOperations()) {
            model.getPropertyAllowedPeripheralOperations().addItem(string);
        }
        for (Map.Entry entry : locTypeTO.getProperties().entrySet()) {
            model.getPropertyMiscellaneous().addItem(new KeyValueProperty((ModelComponent)model, (String)entry.getKey(), (String)entry.getValue()));
        }
        model.getPropertyDefaultRepresentation().setLocationRepresentation(LocationRepresentation.valueOf((String)locTypeTO.getLayout().getLocationRepresentation().name()));
        return model;
    }

    public LocationModel importLocation(LocationCreationTO locationTO, Collection<LocationTypeCreationTO> locTypes, SystemModel systemModel) {
        LocationModel model = new LocationModel();
        model.setName(locationTO.getName());
        model.getPropertyModelPositionX().setValueAndUnit((double)locationTO.getPosition().getX(), (Enum)LengthProperty.Unit.MM);
        model.getPropertyModelPositionY().setValueAndUnit((double)locationTO.getPosition().getY(), (Enum)LengthProperty.Unit.MM);
        ArrayList<String> possibleLocationTypes = new ArrayList<String>();
        for (LocationTypeCreationTO locationTypeCreationTO : locTypes) {
            if (possibleLocationTypes.contains(locationTypeCreationTO.getName())) continue;
            possibleLocationTypes.add(locationTypeCreationTO.getName());
        }
        model.getPropertyType().setPossibleValues(possibleLocationTypes);
        model.getPropertyType().setValue((Object)locationTO.getTypeName());
        model.getPropertyLocked().setValue((Object)locationTO.isLocked());
        for (Map.Entry entry : locationTO.getProperties().entrySet()) {
            model.getPropertyMiscellaneous().addItem(new KeyValueProperty((ModelComponent)model, (String)entry.getKey(), (String)entry.getValue()));
        }
        model.getPropertyLayoutPositionX().setText(String.valueOf(locationTO.getLayout().getPosition().getX()));
        model.getPropertyLayoutPositionY().setText(String.valueOf(locationTO.getLayout().getPosition().getY()));
        model.getPropertyLabelOffsetX().setText(String.valueOf(locationTO.getLayout().getLabelOffset().getX()));
        model.getPropertyLabelOffsetY().setText(String.valueOf(locationTO.getLayout().getLabelOffset().getY()));
        model.getPropertyDefaultRepresentation().setLocationRepresentation(LocationRepresentation.valueOf((String)locationTO.getLayout().getLocationRepresentation().name()));
        model.getPropertyLabelOrientationAngle().setText("");
        LayerWrapper layerWrapper = (LayerWrapper)systemModel.getLayoutModel().getPropertyLayerWrappers().getValue().get(locationTO.getLayout().getLayerId());
        model.getPropertyLayerWrapper().setValue((Object)layerWrapper);
        return model;
    }

    public LinkModel importLocationLink(LocationCreationTO locationTO, String pointName, Set<String> operations, SystemModel systemModel) {
        LinkModel model = new LinkModel();
        model.setName(String.format("%s --- %s", pointName, locationTO.getName()));
        for (String operation : operations) {
            model.getPropertyAllowedOperations().addItem(operation);
        }
        model.getPropertyStartComponent().setText(pointName);
        model.getPropertyEndComponent().setText(locationTO.getName());
        LayerWrapper layerWrapper = (LayerWrapper)systemModel.getLayoutModel().getPropertyLayerWrappers().getValue().get(locationTO.getLayout().getLayerId());
        model.getPropertyLayerWrapper().setValue((Object)layerWrapper);
        return model;
    }

    public BlockModel importBlock(BlockCreationTO blockTO) {
        BlockModel model = new BlockModel();
        model.setName(blockTO.getName());
        model.getPropertyType().setValue((Object)this.mapBlockType(blockTO.getType()));
        for (String string : blockTO.getMemberNames()) {
            model.getPropertyElements().addItem(string);
        }
        for (Map.Entry entry : blockTO.getProperties().entrySet()) {
            model.getPropertyMiscellaneous().addItem(new KeyValueProperty((ModelComponent)model, (String)entry.getKey(), (String)entry.getValue()));
        }
        model.getPropertyColor().setColor(blockTO.getLayout().getColor());
        return model;
    }

    public LayoutModel importLayout(VisualLayoutCreationTO layoutTO) {
        LayoutModel model = new LayoutModel();
        model.setName(layoutTO.getName());
        model.getPropertyScaleX().setValueAndUnit(layoutTO.getScaleX(), (Enum)LengthProperty.Unit.MM);
        model.getPropertyScaleY().setValueAndUnit(layoutTO.getScaleY(), (Enum)LengthProperty.Unit.MM);
        this.initLayerGroups(model, layoutTO.getLayerGroups());
        this.initLayers(model, layoutTO.getLayers());
        for (Map.Entry property : layoutTO.getProperties().entrySet()) {
            model.getPropertyMiscellaneous().addItem(new KeyValueProperty((ModelComponent)model, (String)property.getKey(), (String)property.getValue()));
        }
        return model;
    }

    private PointModel.Type mapPointType(Point.Type type) {
        switch (type) {
            case HALT_POSITION: {
                return PointModel.Type.HALT;
            }
            case PARK_POSITION: {
                return PointModel.Type.PARK;
            }
            case REPORT_POSITION: {
                return PointModel.Type.REPORT;
            }
        }
        throw new IllegalArgumentException("Unhandled point type: " + type);
    }

    private BlockModel.Type mapBlockType(Block.Type type) {
        switch (type) {
            case SINGLE_VEHICLE_ONLY: {
                return BlockModel.Type.SINGLE_VEHICLE_ONLY;
            }
            case SAME_DIRECTION_ONLY: {
                return BlockModel.Type.SAME_DIRECTION_ONLY;
            }
        }
        throw new IllegalArgumentException("Unhandled block type: " + type);
    }

    private void initLayerGroups(LayoutModel model, Collection<LayerGroup> groups) {
        Map layerGroups = model.getPropertyLayerGroups().getValue();
        layerGroups.clear();
        for (LayerGroup group : groups) {
            layerGroups.put(group.getId(), group);
        }
    }

    private void initLayers(LayoutModel model, Collection<Layer> layers) {
        Map layerWrappers = model.getPropertyLayerWrappers().getValue();
        layerWrappers.clear();
        Map layerGroups = model.getPropertyLayerGroups().getValue();
        for (Layer layer : layers) {
            layerWrappers.put(layer.getId(), new LayerWrapper(layer, (LayerGroup)layerGroups.get(layer.getGroupId())));
        }
    }
}

