/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.modeleditor.persistence.unified;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.swing.filechooser.FileFilter;
import org.opentcs.access.to.model.PlantModelCreationTO;
import org.opentcs.guing.common.persistence.ModelFileReader;
import org.opentcs.guing.common.persistence.unified.UnifiedModelConstants;
import org.opentcs.util.persistence.ModelParser;

public class UnifiedModelReader
implements ModelFileReader {
    private final ModelParser modelParser;

    @Inject
    public UnifiedModelReader(ModelParser modelParser) {
        this.modelParser = Objects.requireNonNull(modelParser, "modelParser");
    }

    public Optional<PlantModelCreationTO> deserialize(File file) throws IOException {
        Objects.requireNonNull(file, "file");
        PlantModelCreationTO plantModel = this.modelParser.readModel(file);
        return Optional.of(plantModel);
    }

    public FileFilter getDialogFileFilter() {
        return UnifiedModelConstants.DIALOG_FILE_FILTER;
    }
}

