/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.thirdparty.modeleditor.jhotdraw.application.action.draw;

import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.action.AbstractSelectedAction;
import org.jhotdraw.draw.event.TransformEdit;
import org.jhotdraw.undo.CompositeEdit;
import org.opentcs.guing.common.util.ImageDirectory;
import org.opentcs.thirdparty.guing.common.jhotdraw.util.ResourceBundleUtil;

public abstract class AlignAction
extends AbstractSelectedAction {
    protected ResourceBundleUtil bundle = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.modeling.toolbar");

    public AlignAction(DrawingEditor editor) {
        super(editor);
        this.updateEnabledState();
    }

    protected final void updateEnabledState() {
        if (this.getView() != null) {
            this.setEnabled(this.getView().isEnabled() && this.getView().getSelectionCount() > 1);
        } else {
            this.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent e) {
        CompositeEdit edit = new CompositeEdit(this.bundle.getString("alignAction.undo.presentationName"));
        this.fireUndoableEditHappened((UndoableEdit)edit);
        this.alignFigures(this.getView().getSelectedFigures(), this.getSelectionBounds());
        this.fireUndoableEditHappened((UndoableEdit)edit);
    }

    protected abstract void alignFigures(Collection<?> var1, Rectangle2D.Double var2);

    protected Rectangle2D.Double getSelectionBounds() {
        Rectangle2D.Double bounds = null;
        for (Figure f : this.getView().getSelectedFigures()) {
            if (bounds == null) {
                bounds = f.getBounds();
                continue;
            }
            bounds.add(f.getBounds());
        }
        return bounds;
    }

    public static class Horizontal
    extends AlignAction {
        public Horizontal(DrawingEditor editor) {
            super(editor);
            this.putValue("ShortDescription", this.bundle.getString("alignAction.horizontal.shortDescription"));
            this.putValue("SmallIcon", ImageDirectory.getImageIcon((String)"/toolbar/align-horizontal-center-2.png"));
        }

        @Override
        protected void alignFigures(Collection<?> selectedFigures, Rectangle2D.Double selectionBounds) {
            double x = selectionBounds.x + selectionBounds.width / 2.0;
            for (Figure f : this.getView().getSelectedFigures()) {
                if (!f.isTransformable()) continue;
                f.willChange();
                Rectangle2D.Double b = f.getBounds();
                AffineTransform tx = new AffineTransform();
                tx.translate(x - b.x - b.width / 2.0, 0.0);
                f.transform(tx);
                f.changed();
                this.fireUndoableEditHappened((UndoableEdit)new TransformEdit(f, tx));
            }
        }
    }

    public static class Vertical
    extends AlignAction {
        public Vertical(DrawingEditor editor) {
            super(editor);
            this.putValue("ShortDescription", this.bundle.getString("alignAction.vertical.shortDescription"));
            this.putValue("SmallIcon", ImageDirectory.getImageIcon((String)"/toolbar/align-vertical-center-2.png"));
        }

        @Override
        protected void alignFigures(Collection<?> selectedFigures, Rectangle2D.Double selectionBounds) {
            double y = selectionBounds.y + selectionBounds.height / 2.0;
            for (Figure f : this.getView().getSelectedFigures()) {
                if (!f.isTransformable()) continue;
                f.willChange();
                Rectangle2D.Double b = f.getBounds();
                AffineTransform tx = new AffineTransform();
                tx.translate(0.0, y - b.y - b.height / 2.0);
                f.transform(tx);
                f.changed();
                this.fireUndoableEditHappened((UndoableEdit)new TransformEdit(f, tx));
            }
        }
    }

    public static class South
    extends AlignAction {
        public South(DrawingEditor editor) {
            super(editor);
            this.putValue("ShortDescription", this.bundle.getString("alignAction.south.shortDescription"));
            this.putValue("SmallIcon", ImageDirectory.getImageIcon((String)"/toolbar/align-vertical-bottom-2.png"));
        }

        @Override
        protected void alignFigures(Collection<?> selectedFigures, Rectangle2D.Double selectionBounds) {
            double y = selectionBounds.y + selectionBounds.height;
            for (Figure f : this.getView().getSelectedFigures()) {
                if (!f.isTransformable()) continue;
                f.willChange();
                Rectangle2D.Double b = f.getBounds();
                AffineTransform tx = new AffineTransform();
                tx.translate(0.0, y - b.y - b.height);
                f.transform(tx);
                f.changed();
                this.fireUndoableEditHappened((UndoableEdit)new TransformEdit(f, tx));
            }
        }
    }

    public static class West
    extends AlignAction {
        public West(DrawingEditor editor) {
            super(editor);
            this.putValue("ShortDescription", this.bundle.getString("alignAction.west.shortDescription"));
            this.putValue("SmallIcon", ImageDirectory.getImageIcon((String)"/toolbar/align-horizontal-left.png"));
        }

        @Override
        protected void alignFigures(Collection<?> selectedFigures, Rectangle2D.Double selectionBounds) {
            double x = selectionBounds.x;
            for (Figure f : this.getView().getSelectedFigures()) {
                if (!f.isTransformable()) continue;
                f.willChange();
                Rectangle2D.Double b = f.getBounds();
                AffineTransform tx = new AffineTransform();
                tx.translate(x - b.x, 0.0);
                f.transform(tx);
                f.changed();
                this.fireUndoableEditHappened((UndoableEdit)new TransformEdit(f, tx));
            }
        }
    }

    public static class East
    extends AlignAction {
        public East(DrawingEditor editor) {
            super(editor);
            this.putValue("ShortDescription", this.bundle.getString("alignAction.east.shortDescription"));
            this.putValue("SmallIcon", ImageDirectory.getImageIcon((String)"/toolbar/align-horizontal-right-2.png"));
        }

        @Override
        protected void alignFigures(Collection<?> selectedFigures, Rectangle2D.Double selectionBounds) {
            double x = selectionBounds.x + selectionBounds.width;
            for (Figure f : this.getView().getSelectedFigures()) {
                if (!f.isTransformable()) continue;
                f.willChange();
                Rectangle2D.Double b = f.getBounds();
                AffineTransform tx = new AffineTransform();
                tx.translate(x - b.x - b.width, 0.0);
                f.transform(tx);
                f.changed();
                this.fireUndoableEditHappened((UndoableEdit)new TransformEdit(f, tx));
            }
        }
    }

    public static class North
    extends AlignAction {
        public North(DrawingEditor editor) {
            super(editor);
            this.putValue("ShortDescription", this.bundle.getString("alignAction.north.shortDescription"));
            this.putValue("SmallIcon", ImageDirectory.getImageIcon((String)"/toolbar/align-vertical-top-2.png"));
        }

        @Override
        protected void alignFigures(Collection<?> selectedFigures, Rectangle2D.Double selectionBounds) {
            double y = selectionBounds.y;
            for (Figure f : this.getView().getSelectedFigures()) {
                if (!f.isTransformable()) continue;
                f.willChange();
                Rectangle2D.Double b = f.getBounds();
                AffineTransform tx = new AffineTransform();
                tx.translate(0.0, y - b.y);
                f.transform(tx);
                f.changed();
                this.fireUndoableEditHappened((UndoableEdit)new TransformEdit(f, tx));
            }
        }
    }
}

