/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.thirdparty.modeleditor.jhotdraw.application.action.edit;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.jhotdraw.app.action.edit.AbstractSelectionAction;
import org.opentcs.guing.common.components.EditableComponent;
import org.opentcs.guing.common.util.ImageDirectory;
import org.opentcs.thirdparty.guing.common.jhotdraw.util.ResourceBundleUtil;

public class ClearSelectionAction
extends AbstractSelectionAction {
    public static final String ID = "edit.clearSelection";
    private static final ResourceBundleUtil BUNDLE = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.modeling.mainMenu");

    public ClearSelectionAction() {
        this(null);
    }

    public ClearSelectionAction(JComponent target) {
        super(target);
        this.putValue("Name", BUNDLE.getString("clearSelectionAction.name"));
        this.putValue("ShortDescription", BUNDLE.getString("clearSelectionAction.shortDescription"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("shift ctrl A"));
        ImageIcon icon = ImageDirectory.getImageIcon((String)"/menu/edit-clear-2.png");
        this.putValue("SmallIcon", icon);
        this.putValue("SwingLargeIconKey", icon);
    }

    public void actionPerformed(ActionEvent evt) {
        JComponent cTarget = this.target;
        Component cFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        if (cTarget == null && cFocusOwner instanceof JComponent) {
            cTarget = (JComponent)cFocusOwner;
        }
        if (cTarget != null && cTarget.isEnabled()) {
            if (cTarget instanceof EditableComponent) {
                ((EditableComponent)cTarget).clearSelection();
            } else if (cTarget instanceof JTextComponent) {
                JTextComponent tc = (JTextComponent)cTarget;
                tc.select(tc.getSelectionStart(), tc.getSelectionStart());
            } else {
                cTarget.getToolkit().beep();
            }
        }
    }

    protected void updateEnabled() {
        if (this.target != null) {
            this.setEnabled(this.target.isEnabled());
        }
    }
}

