/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.thirdparty.modeleditor.jhotdraw.application.action.file;

import java.awt.event.ActionEvent;
import java.net.URI;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jhotdraw.app.View;
import org.jhotdraw.net.URIUtil;
import org.opentcs.guing.common.util.ImageDirectory;
import org.opentcs.modeleditor.application.OpenTCSView;
import org.opentcs.thirdparty.guing.common.jhotdraw.util.ResourceBundleUtil;

public class CloseFileAction
extends AbstractAction {
    public static final String ID = "file.close";
    public static final String ID_WINDOW_CLOSING = "windowClosing";
    public static final String ID_MODEL_CLOSING = "modelClosing";
    private static final ResourceBundleUtil BUNDLE = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.modeling.mainMenu");
    private int fileSaved;
    private final OpenTCSView view;

    public CloseFileAction(OpenTCSView view) {
        this.view = Objects.requireNonNull(view, "view");
        this.putValue("Name", BUNDLE.getString("closeFileAction.name"));
        this.putValue("ShortDescription", BUNDLE.getString("closeFileAction.shortDescription"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("alt F4"));
        this.putValue("MnemonicKey", 67);
        ImageIcon icon = ImageDirectory.getImageIcon((String)"/menu/document-close-4.png");
        this.putValue("SmallIcon", icon);
        this.putValue("SwingLargeIconKey", icon);
    }

    public int getFileSavedStatus() {
        return this.fileSaved;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle((String)"org.jhotdraw.app.Labels");
        if (this.view.hasUnsavedChanges()) {
            URI unsavedURI = this.view.getURI();
            String message = "<html><b>" + labels.getFormatted("file.saveBefore.doYouWantToSave.message", new Object[]{unsavedURI == null ? "unnamed" : URIUtil.getName((URI)unsavedURI)}) + "</b><p>" + labels.getString("file.saveBefore.doYouWantToSave.details") + "</p></html>";
            Object[] options = new Object[]{labels.getString("file.saveBefore.saveOption.text"), labels.getString("file.saveBefore.dontSaveOption.text"), labels.getString("file.saveBefore.cancelOption.text")};
            int option = JOptionPane.showOptionDialog(this.view.getComponent(), message, "", 1, 2, null, options, options[0]);
            this.fileSaved = 2;
            switch (option) {
                case 0: {
                    if (!this.view.saveModel()) break;
                    this.fileSaved = 0;
                    this.doIt(evt.getActionCommand(), (View)this.view);
                    break;
                }
                case 1: {
                    this.fileSaved = 1;
                    this.doIt(evt.getActionCommand(), (View)this.view);
                    break;
                }
            }
        } else {
            this.fileSaved = 1;
            this.doIt(evt.getActionCommand(), (View)this.view);
        }
    }

    protected void doIt(String actionCommand, View view) {
        if (!actionCommand.equals(ID_MODEL_CLOSING) && view != null) {
            if (view.isShowing()) {
                view.setShowing(false);
                JFrame f = (JFrame)SwingUtilities.getWindowAncestor(view.getComponent());
                f.setVisible(false);
                f.remove(view.getComponent());
                f.dispose();
            }
            view.dispose();
        }
    }

    protected void doIt(View view) {
        this.doIt(ID_WINDOW_CLOSING, view);
    }
}

