/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.modeleditor.components.layer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.opentcs.data.model.visualization.Layer;
import org.opentcs.guing.common.components.layer.LayerGroupChangeListener;
import org.opentcs.guing.common.components.layer.LayerGroupManager;
import org.opentcs.guing.common.persistence.ModelManager;
import org.opentcs.guing.common.util.IconToolkit;
import org.opentcs.modeleditor.components.layer.LayerGroupEditorModeling;
import org.opentcs.modeleditor.components.layer.LayerGroupsTableModel;

public class LayerGroupsPanel
extends JPanel {
    private static final String ICON_PATH = "/org/opentcs/guing/res/symbols/layer/";
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("i18n.org.opentcs.plantoverview.modeling.panels.layers");
    private final ModelManager modelManager;
    private final LayerGroupManager layerGroupManager;
    private final LayerGroupEditorModeling layerGroupEditor;
    private JTable table;
    private LayerGroupsTableModel tableModel;

    @Inject
    public LayerGroupsPanel(ModelManager modelManager, LayerGroupManager layerGroupManager, LayerGroupEditorModeling layerGroupEditor) {
        this.modelManager = Objects.requireNonNull(modelManager, "modelManager");
        this.layerGroupManager = Objects.requireNonNull(layerGroupManager, "layerGroupManager");
        this.layerGroupEditor = Objects.requireNonNull(layerGroupEditor, "layerGroupEditor");
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.tableModel = new LayerGroupsTableModel(this.modelManager, this.layerGroupEditor);
        this.layerGroupManager.addLayerGroupChangeListener((LayerGroupChangeListener)this.tableModel);
        this.table = new JTable((TableModel)((Object)this.tableModel));
        this.initTable();
        this.add((Component)this.createToolBar(), "North");
        this.add((Component)new JScrollPane(this.table), "Center");
    }

    private void initTable() {
        this.table.setSelectionMode(0);
        TableRowSorter<LayerGroupsTableModel> sorter = new TableRowSorter<LayerGroupsTableModel>(this.tableModel);
        sorter.setSortKeys(Arrays.asList(new RowSorter.SortKey(0, SortOrder.DESCENDING)));
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            sorter.setSortable(i, false);
        }
        sorter.setSortsOnUpdates(true);
        this.table.setRowSorter(sorter);
        this.table.removeColumn(this.table.getColumnModel().getColumn(this.table.convertColumnIndexToView(0)));
    }

    private JToolBar createToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.add(this.createAddGroupButton());
        toolBar.add(this.createRemoveGroupButton());
        return toolBar;
    }

    private JButton createAddGroupButton() {
        IconToolkit iconkit = IconToolkit.instance();
        JButton button = new JButton(iconkit.getImageIconByFullPath("/org/opentcs/guing/res/symbols/layer/create-layer-group.16.png"));
        button.addActionListener(actionEvent -> {
            this.layerGroupEditor.createLayerGroup();
            this.table.getSelectionModel().setSelectionInterval(0, 0);
        });
        button.setToolTipText(BUNDLE.getString("layerGroupsPanel.button_addGroup.tooltipText"));
        return button;
    }

    private JButton createRemoveGroupButton() {
        IconToolkit iconkit = IconToolkit.instance();
        JButton button = new JButton(iconkit.getImageIconByFullPath("/org/opentcs/guing/res/symbols/layer/delete-layer-group.16.png"));
        button.addActionListener(new RemoveGroupListener());
        button.setToolTipText(BUNDLE.getString("layerGroupsPanel.button_removeGroup.tooltipText"));
        this.table.getSelectionModel().addListSelectionListener(listSelectionEvent -> button.setEnabled(this.table.getSelectedRow() != -1 && this.tableModel.getRowCount() > 1));
        this.tableModel.addTableModelListener(tableModelEvent -> button.setEnabled(this.table.getSelectedRow() != -1 && this.tableModel.getRowCount() > 1));
        return button;
    }

    private class RemoveGroupListener
    implements ActionListener {
        RemoveGroupListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedOption;
            int selectedRow = LayerGroupsPanel.this.table.getSelectedRow();
            int selectedGroupId = LayerGroupsPanel.this.tableModel.getDataAt(LayerGroupsPanel.this.table.convertRowIndexToModel(selectedRow)).getId();
            Map<Boolean, List<Layer>> layersByGroupAssignment = LayerGroupsPanel.this.modelManager.getModel().getLayoutModel().getPropertyLayerWrappers().getValue().values().stream().map(wrapper -> wrapper.getLayer()).collect(Collectors.partitioningBy(layer -> layer.getGroupId() == selectedGroupId));
            List<Layer> layersAssignedToGroupToDelete = layersByGroupAssignment.get(Boolean.TRUE);
            List<Layer> layersAssignedToOtherGroups = layersByGroupAssignment.get(Boolean.FALSE);
            if (layersAssignedToOtherGroups.isEmpty()) {
                JOptionPane.showMessageDialog(LayerGroupsPanel.this, BUNDLE.getString("layerGroupsPanel.optionPane_groupRemovalNotPossible.message"), BUNDLE.getString("layerGroupsPanel.optionPane_groupRemovalNotPossible.title"), 1);
                return;
            }
            if (!layersAssignedToGroupToDelete.isEmpty() && (selectedOption = JOptionPane.showConfirmDialog(LayerGroupsPanel.this, BUNDLE.getString("layerGroupsPanel.optionPane_confirmGroupAndAssignedLayersRemoval.message"), BUNDLE.getString("layerGroupsPanel.optionPane_confirmGroupAndAssignedLayersRemoval.title"), 0, 2)) == 1) {
                return;
            }
            LayerGroupsPanel.this.layerGroupEditor.deleteLayerGroup(selectedGroupId);
        }
    }
}

