/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.modeleditor.components.layer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import org.opentcs.data.model.visualization.LayerGroup;
import org.opentcs.guing.common.components.layer.DisabledCheckBoxCellRenderer;
import org.opentcs.guing.common.components.layer.LayerChangeListener;
import org.opentcs.guing.common.components.layer.LayerGroupCellRenderer;
import org.opentcs.guing.common.components.layer.LayerGroupChangeListener;
import org.opentcs.guing.common.components.layer.LayerGroupManager;
import org.opentcs.guing.common.components.layer.LayerManager;
import org.opentcs.guing.common.persistence.ModelManager;
import org.opentcs.guing.common.util.IconToolkit;
import org.opentcs.modeleditor.components.layer.ActiveLayerProvider;
import org.opentcs.modeleditor.components.layer.LayerEditorModeling;
import org.opentcs.modeleditor.components.layer.LayersTableModel;
import org.opentcs.util.gui.StringListCellRenderer;

public class LayersPanel
extends JPanel {
    private static final String ICON_PATH = "/org/opentcs/guing/res/symbols/layer/";
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("i18n.org.opentcs.plantoverview.modeling.panels.layers");
    private final ModelManager modelManager;
    private final LayerManager layerManager;
    private final LayerGroupManager layerGroupManager;
    private final LayerEditorModeling layerEditor;
    private final ActiveLayerProvider activeLayerProvider;
    private JTable table;
    private LayersTableModel tableModel;

    @Inject
    public LayersPanel(ModelManager modelManager, LayerManager layerManager, LayerGroupManager layerGroupManager, LayerEditorModeling layerEditor, ActiveLayerProvider activeLayerProvider) {
        this.modelManager = Objects.requireNonNull(modelManager, "modelManager");
        this.layerManager = Objects.requireNonNull(layerManager, "layerManager");
        this.layerGroupManager = Objects.requireNonNull(layerGroupManager, "layerGroupManager");
        this.layerEditor = Objects.requireNonNull(layerEditor, "layerEditor");
        this.activeLayerProvider = Objects.requireNonNull(activeLayerProvider, "activeLayerProvider");
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.tableModel = new LayersTableModel(this.modelManager, this.activeLayerProvider, this.layerEditor);
        this.layerManager.setLayerChangeListener((LayerChangeListener)this.tableModel);
        this.layerGroupManager.addLayerGroupChangeListener((LayerGroupChangeListener)this.tableModel);
        this.table = new JTable(this.tableModel);
        this.initTable();
        this.add((Component)this.createToolBar(), "North");
        this.add((Component)new JScrollPane(this.table), "Center");
    }

    private void initTable() {
        this.table.setSelectionMode(0);
        TableRowSorter<LayersTableModel> sorter = new TableRowSorter<LayersTableModel>(this.tableModel);
        sorter.setSortKeys(Arrays.asList(new RowSorter.SortKey(1, SortOrder.DESCENDING)));
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            sorter.setSortable(i, false);
        }
        sorter.setSortsOnUpdates(true);
        this.table.setRowSorter(sorter);
        this.table.removeColumn(this.table.getColumnModel().getColumn(this.table.convertColumnIndexToView(1)));
        this.table.getColumnModel().getColumn(this.table.convertColumnIndexToView(5)).setCellRenderer((TableCellRenderer)new DisabledCheckBoxCellRenderer());
        this.initActiveColumn();
        this.initGroupColumn();
    }

    private JToolBar createToolBar() {
        JToolBar toolBar = new JToolBar();
        toolBar.setFloatable(false);
        toolBar.add(this.createAddLayerButton());
        toolBar.add(this.createRemoveLayerButton());
        toolBar.add(this.createMoveLayerUpButton());
        toolBar.add(this.createMoveLayerDownButton());
        return toolBar;
    }

    private void initActiveColumn() {
        TableColumn columnActive = this.table.getColumnModel().getColumn(this.table.convertColumnIndexToView(0));
        columnActive.setCellEditor(new RadioButtonCellEditor());
        columnActive.setCellRenderer(new RadioButtonCellRenderer());
    }

    private void initGroupColumn() {
        TableColumn columnGroup = this.table.getColumnModel().getColumn(this.table.convertColumnIndexToView(4));
        columnGroup.setCellRenderer((TableCellRenderer)new LayerGroupCellRenderer());
        columnGroup.setCellEditor(new GroupCellEditor());
    }

    private JButton createAddLayerButton() {
        IconToolkit iconkit = IconToolkit.instance();
        JButton button = new JButton(iconkit.getImageIconByFullPath("/org/opentcs/guing/res/symbols/layer/create-layer.16.png"));
        button.addActionListener(actionEvent -> {
            this.layerEditor.createLayer();
            this.table.getSelectionModel().setSelectionInterval(0, 0);
        });
        button.setToolTipText(BUNDLE.getString("layersPanel.button_addLayer.tooltipText"));
        return button;
    }

    private JButton createRemoveLayerButton() {
        IconToolkit iconkit = IconToolkit.instance();
        JButton button = new JButton(iconkit.getImageIconByFullPath("/org/opentcs/guing/res/symbols/layer/delete-layer.16.png"));
        button.addActionListener(new RemoveLayerListener());
        button.setToolTipText(BUNDLE.getString("layersPanel.button_removeLayer.tooltipText"));
        this.table.getSelectionModel().addListSelectionListener(listSelectionEvent -> button.setEnabled(this.table.getSelectedRow() != -1 && this.tableModel.getRowCount() > 1));
        this.tableModel.addTableModelListener(tableModelEvent -> button.setEnabled(this.table.getSelectedRow() != -1 && this.tableModel.getRowCount() > 1));
        return button;
    }

    private JButton createMoveLayerUpButton() {
        IconToolkit iconkit = IconToolkit.instance();
        JButton button = new JButton(iconkit.getImageIconByFullPath("/org/opentcs/guing/res/symbols/layer/move-layer-up.16.png"));
        button.setEnabled(false);
        button.addActionListener(actionEvent -> {
            int selectedRow = this.table.getSelectedRow();
            int selectedLayerId = this.tableModel.getDataAt(this.table.convertRowIndexToModel(selectedRow)).getId();
            this.layerEditor.moveLayerUp(selectedLayerId);
        });
        button.setToolTipText(BUNDLE.getString("layersPanel.button_moveLayerUp.tooltipText"));
        this.table.getSelectionModel().addListSelectionListener(listSelectionEvent -> button.setEnabled(this.table.getSelectedRow() != -1));
        return button;
    }

    private JButton createMoveLayerDownButton() {
        IconToolkit iconkit = IconToolkit.instance();
        JButton button = new JButton(iconkit.getImageIconByFullPath("/org/opentcs/guing/res/symbols/layer/move-layer-down.16.png"));
        button.setEnabled(false);
        button.addActionListener(actionEvent -> {
            int selectedRow = this.table.getSelectedRow();
            int selectedLayerId = this.tableModel.getDataAt(this.table.convertRowIndexToModel(selectedRow)).getId();
            this.layerEditor.moveLayerDown(selectedLayerId);
        });
        button.setToolTipText(BUNDLE.getString("layersPanel.button_moveLayerDown.tooltipText"));
        this.table.getSelectionModel().addListSelectionListener(listSelectionEvent -> button.setEnabled(this.table.getSelectedRow() != -1));
        return button;
    }

    private class RadioButtonCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final JRadioButton radioButton = new JRadioButton();

        RadioButtonCellEditor() {
            this.radioButton.setHorizontalAlignment(0);
            this.radioButton.addActionListener(actionEvent -> this.stopCellEditing());
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            this.radioButton.setSelected(Boolean.TRUE.equals(value));
            return this.radioButton;
        }

        @Override
        public Object getCellEditorValue() {
            return this.radioButton.isSelected();
        }
    }

    private class RadioButtonCellRenderer
    implements TableCellRenderer {
        private final Border unfocusedCellBorder = BorderFactory.createEmptyBorder();
        private final Border focusedCellBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
        private final JRadioButton radioButton = new JRadioButton();

        RadioButtonCellRenderer() {
            this.radioButton.setHorizontalAlignment(0);
            this.radioButton.setBorderPainted(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            this.radioButton.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            this.radioButton.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
            this.radioButton.setBorder(hasFocus ? this.focusedCellBorder : this.unfocusedCellBorder);
            this.radioButton.setSelected(Boolean.TRUE.equals(value));
            return this.radioButton;
        }
    }

    private class GroupCellEditor
    extends DefaultCellEditor {
        private final DefaultComboBoxModel<LayerGroup> model;

        GroupCellEditor() {
            super(new JComboBox());
            JComboBox combobox = (JComboBox)this.getComponent();
            combobox.setRenderer(new StringListCellRenderer(group -> group.getName()));
            this.model = (DefaultComboBoxModel)combobox.getModel();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.model.removeAllElements();
            List groups = LayersPanel.this.modelManager.getModel().getLayoutModel().getPropertyLayerGroups().getValue().values().stream().sorted((o1, o2) -> Integer.compare(o1.getId(), o2.getId())).collect(Collectors.toList());
            this.model.addAll(groups);
            this.model.setSelectedItem(table.getModel().getValueAt(row, column));
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    private class RemoveLayerListener
    implements ActionListener {
        RemoveLayerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedOption;
            int selectedRow = LayersPanel.this.table.getSelectedRow();
            int selectedLayerId = LayersPanel.this.tableModel.getDataAt(LayersPanel.this.table.convertRowIndexToModel(selectedRow)).getId();
            if (LayersPanel.this.layerManager.containsComponents(selectedLayerId) && (selectedOption = JOptionPane.showConfirmDialog(LayersPanel.this, BUNDLE.getString("layersPanel.optionPane_confirmLayerWithComponentsRemoval.message"), BUNDLE.getString("layersPanel.optionPane_confirmLayerWithComponentsRemoval.title"), 0, 2)) == 1) {
                return;
            }
            LayersPanel.this.layerEditor.deleteLayer(selectedLayerId);
        }
    }
}

