/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.modeleditor.components.layer;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import org.opentcs.data.model.visualization.Layer;
import org.opentcs.data.model.visualization.LayerGroup;
import org.opentcs.guing.base.components.layer.LayerWrapper;
import org.opentcs.guing.common.components.layer.LayerChangeListener;
import org.opentcs.guing.common.components.layer.LayerGroupChangeListener;
import org.opentcs.guing.common.persistence.ModelManager;
import org.opentcs.modeleditor.components.layer.ActiveLayerProvider;
import org.opentcs.modeleditor.components.layer.LayerEditorModeling;

class LayersTableModel
extends AbstractTableModel
implements LayerChangeListener,
LayerGroupChangeListener {
    public static final int COLUMN_ACTIVE = 0;
    public static final int COLUMN_ORDINAL = 1;
    public static final int COLUMN_VISIBLE = 2;
    public static final int COLUMN_NAME = 3;
    public static final int COLUMN_GROUP = 4;
    public static final int COLUMN_GROUP_VISIBLE = 5;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("i18n.org.opentcs.plantoverview.modeling.panels.layers");
    private static final String[] COLUMN_NAMES = new String[]{BUNDLE.getString("layersTableModel.column_active.headerText"), BUNDLE.getString("layersTableModel.column_ordinal.headerText"), BUNDLE.getString("layersTableModel.column_visible.headerText"), BUNDLE.getString("layersTableModel.column_name.headerText"), BUNDLE.getString("layersTableModel.column_group.headerText"), BUNDLE.getString("layersTableModel.column_groupVisible.headerText")};
    private static final Class<?>[] COLUMN_CLASSES = new Class[]{Boolean.class, Integer.class, Boolean.class, String.class, LayerGroup.class, Boolean.class};
    private final ModelManager modelManager;
    private final ActiveLayerProvider activeLayerProvider;
    private final LayerEditorModeling layerEditor;

    LayersTableModel(ModelManager modelManager, ActiveLayerProvider activeLayerProvider, LayerEditorModeling layerEditor) {
        this.modelManager = Objects.requireNonNull(modelManager, "modelManager");
        this.activeLayerProvider = Objects.requireNonNull(activeLayerProvider, "activeLayerProvider");
        this.layerEditor = Objects.requireNonNull(layerEditor, "layerEditor");
    }

    @Override
    public int getRowCount() {
        return this.getLayers().size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.getRowCount()) {
            return null;
        }
        Layer entry = this.getLayers().get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return entry.getId() == this.activeLayerProvider.getActiveLayer().getLayer().getId();
            }
            case 1: {
                return entry.getOrdinal();
            }
            case 2: {
                return entry.isVisible();
            }
            case 3: {
                return entry.getName();
            }
            case 4: {
                return this.getLayerGroups().get(entry.getGroupId());
            }
            case 5: {
                return this.getLayerGroups().get(entry.getGroupId()).isVisible();
            }
        }
        throw new IllegalArgumentException("Invalid column index: " + columnIndex);
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_NAMES[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return COLUMN_CLASSES[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 5: {
                return false;
            }
        }
        throw new IllegalArgumentException("Invalid column index: " + columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex < 0 || rowIndex >= this.getRowCount()) {
            return;
        }
        if (aValue == null) {
            return;
        }
        Layer entry = this.getLayers().get(rowIndex);
        switch (columnIndex) {
            case 0: {
                this.layerEditor.setLayerActive(entry.getId());
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.layerEditor.setLayerVisible(entry.getId(), (Boolean)aValue);
                break;
            }
            case 3: {
                this.layerEditor.setLayerName(entry.getId(), aValue.toString());
                break;
            }
            case 4: {
                this.layerEditor.setLayerGroupId(entry.getId(), ((LayerGroup)aValue).getId());
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid column index: " + columnIndex);
            }
        }
    }

    public void layersInitialized() {
        this.executeOnEventDispatcherThread(() -> this.fireTableDataChanged());
    }

    public void layersChanged() {
        this.executeOnEventDispatcherThread(() -> this.fireTableRowsUpdated(0, this.getRowCount() - 1));
    }

    public void layerAdded() {
        this.executeOnEventDispatcherThread(() -> this.fireTableRowsInserted(0, 0));
    }

    public void layerRemoved() {
        this.executeOnEventDispatcherThread(() -> this.fireTableRowsDeleted(this.getRowCount(), this.getRowCount()));
    }

    public void groupsInitialized() {
    }

    public void groupsChanged() {
        this.executeOnEventDispatcherThread(() -> this.fireTableRowsUpdated(0, this.getRowCount() - 1));
    }

    public void groupAdded() {
    }

    public void groupRemoved() {
    }

    public Layer getDataAt(int index) {
        return this.getLayers().get(index);
    }

    private List<Layer> getLayers() {
        return this.getLayerWrappers().values().stream().map(wrapper -> wrapper.getLayer()).collect(Collectors.toList());
    }

    private Map<Integer, LayerWrapper> getLayerWrappers() {
        return this.modelManager.getModel().getLayoutModel().getPropertyLayerWrappers().getValue();
    }

    private Map<Integer, LayerGroup> getLayerGroups() {
        return this.modelManager.getModel().getLayoutModel().getPropertyLayerGroups().getValue();
    }

    private void executeOnEventDispatcherThread(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }
}

