/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.thirdparty.modeleditor.jhotdraw.application;

import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import org.jhotdraw.app.SDIApplication;
import org.jhotdraw.app.View;
import org.opentcs.common.PortalManager;
import org.opentcs.customizations.ApplicationEventBus;
import org.opentcs.customizations.plantoverview.ApplicationFrame;
import org.opentcs.guing.common.event.ModelNameChangeEvent;
import org.opentcs.guing.common.persistence.ModelManager;
import org.opentcs.modeleditor.application.OpenTCSView;
import org.opentcs.modeleditor.application.menus.menubar.ApplicationMenuBar;
import org.opentcs.util.event.EventHandler;
import org.opentcs.util.event.EventSource;
import org.opentcs.util.gui.Icons;

public class OpenTCSSDIApplication
extends SDIApplication
implements EventHandler {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("i18n.org.opentcs.plantoverview.modeling.system");
    private static final boolean FRAME_MAXIMIZED = false;
    private static final int FRAME_BOUNDS_X = 0;
    private static final int FRAME_BOUNDS_Y = 0;
    private static final int FRAME_BOUNDS_HEIGHT = 768;
    private static final int FRAME_BOUNDS_WIDTH = 1024;
    private final JFrame contentFrame;
    private final Provider<ApplicationMenuBar> menuBarProvider;
    private final ModelManager modelManager;
    private final EventSource eventSource;
    private final PortalManager portalManager;

    @Inject
    public OpenTCSSDIApplication(@ApplicationFrame JFrame frame, Provider<ApplicationMenuBar> menuBarProvider, ModelManager modelManager, @ApplicationEventBus EventSource eventSource, PortalManager portalManager) {
        this.contentFrame = Objects.requireNonNull(frame, "frame");
        this.menuBarProvider = Objects.requireNonNull(menuBarProvider, "menuBarProvider");
        this.modelManager = Objects.requireNonNull(modelManager, "modelManager");
        this.eventSource = Objects.requireNonNull(eventSource, "eventSource");
        this.portalManager = Objects.requireNonNull(portalManager, "portalManager");
    }

    public void show(View view) {
        Objects.requireNonNull(view, "view");
        if (view.isShowing()) {
            return;
        }
        view.setShowing(true);
        this.eventSource.subscribe((EventHandler)this);
        OpenTCSView opentcsView = (OpenTCSView)view;
        this.setupContentFrame(opentcsView);
        TitleUpdater titleUpdater = new TitleUpdater(opentcsView);
        opentcsView.addPropertyChangeListener(titleUpdater);
        this.eventSource.subscribe((EventHandler)titleUpdater);
        this.updateViewTitle(view, this.contentFrame);
        opentcsView.start();
        this.contentFrame.setVisible(true);
    }

    protected void updateViewTitle(View view, JFrame frame) {
        ((OpenTCSView)view).updateModelName();
    }

    public void onEvent(Object event) {
        if (event instanceof ModelNameChangeEvent) {
            ModelNameChangeEvent modelNameChangeEvent = (ModelNameChangeEvent)event;
            this.updateViewTitle((OpenTCSView)((Object)modelNameChangeEvent.getSource()), this.contentFrame);
        }
    }

    private void updateViewTitle(OpenTCSView view, JFrame frame) {
        Object modelName = this.modelManager.getModel().getName();
        if (view.hasUnsavedChanges()) {
            modelName = (String)modelName + "*";
        }
        if (frame != null) {
            frame.setTitle(OpenTCSView.NAME + " - \"" + (String)modelName + "\" - " + BUNDLE.getString("openTcsSdiApplication.frameTitle_connectedTo.text") + this.portalManager.getDescription() + " (" + this.portalManager.getHost() + ":" + this.portalManager.getPort() + ")");
        }
    }

    private void setupContentFrame(OpenTCSView opentcsView) {
        this.contentFrame.setJMenuBar((JMenuBar)this.menuBarProvider.get());
        this.contentFrame.setIconImages(Icons.getOpenTCSIcons());
        this.contentFrame.setSize(1024, 768);
        this.contentFrame.setExtendedState(0);
        if (this.contentFrame.getExtendedState() != 6) {
            this.contentFrame.setBounds(0, 0, 1024, 768);
        }
        this.contentFrame.setDefaultCloseOperation(0);
        this.contentFrame.addWindowListener(new WindowStatusUpdater(opentcsView));
    }

    private class TitleUpdater
    implements PropertyChangeListener,
    EventHandler {
        private final OpenTCSView opentcsView;

        TitleUpdater(OpenTCSView opentcsView) {
            this.opentcsView = Objects.requireNonNull(opentcsView, "opentcsView");
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name.equals("hasUnsavedChanges")) {
                OpenTCSSDIApplication.this.updateViewTitle(this.opentcsView, OpenTCSSDIApplication.this.contentFrame);
            }
        }

        public void onEvent(Object event) {
            if (event instanceof PortalManager.ConnectionState) {
                PortalManager.ConnectionState connectionState = (PortalManager.ConnectionState)event;
                switch (connectionState) {
                    case CONNECTED: {
                        break;
                    }
                    case DISCONNECTED: {
                        break;
                    }
                }
                OpenTCSSDIApplication.this.updateViewTitle(this.opentcsView, OpenTCSSDIApplication.this.contentFrame);
            }
        }
    }

    private class WindowStatusUpdater
    extends WindowAdapter {
        private final OpenTCSView opentcsView;

        WindowStatusUpdater(OpenTCSView opentcsView) {
            this.opentcsView = Objects.requireNonNull(opentcsView, "opentcsView");
        }

        @Override
        public void windowClosing(WindowEvent e) {
            OpenTCSSDIApplication.this.getAction((View)this.opentcsView, "file.close").actionPerformed(new ActionEvent(OpenTCSSDIApplication.this.contentFrame, 1001, "windowClosing"));
        }

        @Override
        public void windowClosed(WindowEvent e) {
            this.opentcsView.stop();
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
            OpenTCSSDIApplication.this.setActiveView((View)this.opentcsView);
        }
    }
}

