/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.thirdparty.modeleditor.jhotdraw.application.action;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.text.StyledEditorKit;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.action.AttributeToggler;
import org.jhotdraw.draw.action.EditorColorIcon;
import org.jhotdraw.draw.action.FontChooserHandler;
import org.jhotdraw.draw.action.LineDecorationIcon;
import org.jhotdraw.draw.action.StrokeIcon;
import org.jhotdraw.draw.decoration.ArrowTip;
import org.jhotdraw.draw.decoration.LineDecoration;
import org.jhotdraw.geom.DoubleStroke;
import org.jhotdraw.gui.JComponentPopup;
import org.jhotdraw.gui.JFontChooser;
import org.jhotdraw.gui.JPopupButton;
import org.jhotdraw.util.Images;
import org.opentcs.guing.common.util.ImageDirectory;
import org.opentcs.thirdparty.guing.common.jhotdraw.application.action.draw.MoveAction;
import org.opentcs.thirdparty.guing.common.jhotdraw.util.ResourceBundleUtil;
import org.opentcs.thirdparty.modeleditor.jhotdraw.application.action.draw.AlignAction;
import org.opentcs.thirdparty.modeleditor.jhotdraw.application.action.draw.ApplyAttributesAction;
import org.opentcs.thirdparty.modeleditor.jhotdraw.application.action.draw.AttributeAction;
import org.opentcs.thirdparty.modeleditor.jhotdraw.application.action.draw.BringToFrontAction;
import org.opentcs.thirdparty.modeleditor.jhotdraw.application.action.draw.ColorIcon;
import org.opentcs.thirdparty.modeleditor.jhotdraw.application.action.draw.DefaultAttributeAction;
import org.opentcs.thirdparty.modeleditor.jhotdraw.application.action.draw.EditorColorChooserAction;
import org.opentcs.thirdparty.modeleditor.jhotdraw.application.action.draw.PickAttributesAction;
import org.opentcs.thirdparty.modeleditor.jhotdraw.application.action.draw.SendToBackAction;

public class ButtonFactory {
    private static final List<ColorIcon> DEFAULT_COLOR_ICONS;
    private static final int DEFAULT_COLORS_COLUMN_COUNT = 8;
    private static final ResourceBundleUtil BUNDLE;

    private ButtonFactory() {
    }

    public static void addAttributesButtonsTo(JToolBar toolBar, DrawingEditor editor) {
        JButton button = toolBar.add((Action)((Object)new PickAttributesAction(editor)));
        button.setFocusable(false);
        button = toolBar.add((Action)((Object)new ApplyAttributesAction(editor)));
        button.setFocusable(false);
        toolBar.addSeparator();
        ButtonFactory.addColorButtonsTo(toolBar, editor);
        toolBar.addSeparator();
        ButtonFactory.addStrokeButtonsTo(toolBar, editor);
        toolBar.addSeparator();
        ButtonFactory.addFontButtonsTo(toolBar, editor);
    }

    private static void addColorButtonsTo(JToolBar bar, DrawingEditor editor) {
        bar.add((Component)ButtonFactory.createEditorColorButton(editor, (AttributeKey<Color>)AttributeKeys.STROKE_COLOR, BUNDLE.getString("buttonFactory.button_lineColor.tooltipText"), ImageDirectory.getImageIcon((String)"/toolbar/attributeStrokeColor.png"), new HashMap<AttributeKey, Object>()));
        bar.add((Component)ButtonFactory.createEditorColorButton(editor, (AttributeKey<Color>)AttributeKeys.FILL_COLOR, BUNDLE.getString("buttonFactory.button_fillColor.tooltipText"), ImageDirectory.getImageIcon((String)"/toolbar/attributeFillColor.png"), new HashMap<AttributeKey, Object>()));
        bar.add((Component)ButtonFactory.createEditorColorButton(editor, (AttributeKey<Color>)AttributeKeys.TEXT_COLOR, BUNDLE.getString("buttonFactory.button_textlColor.tooltipText"), ImageDirectory.getImageIcon((String)"/toolbar/attributeTextColor.png"), new HashMap<AttributeKey, Object>()));
    }

    private static JPopupButton createEditorColorButton(DrawingEditor editor, AttributeKey<Color> attributeKey, String toolTipText, ImageIcon baseIcon, Map<AttributeKey, Object> defaultAttributes) {
        AttributeAction action;
        final JPopupButton popupButton = new JPopupButton();
        popupButton.setPopupAlpha(1.0f);
        popupButton.setAction((Action)((Object)new DefaultAttributeAction(editor, attributeKey, defaultAttributes)), new Rectangle(0, 0, 22, 22));
        popupButton.setColumnCount(8, false);
        boolean hasNullColor = false;
        for (ColorIcon swatch : DEFAULT_COLOR_ICONS) {
            HashMap<AttributeKey, Object> attributes = new HashMap<AttributeKey, Object>(defaultAttributes);
            Color swatchColor = swatch.getColor();
            attributes.put(attributeKey, swatchColor);
            if (swatchColor == null || swatchColor.getAlpha() == 0) {
                hasNullColor = true;
            }
            AttributeAction action2 = new AttributeAction(editor, attributes, toolTipText, swatch);
            popupButton.add((Action)((Object)action2));
            action2.putValue("ShortDescription", swatch.getName());
            action2.setUpdateEnabledState(false);
        }
        if (!hasNullColor) {
            HashMap<AttributeKey, Object> attributes = new HashMap<AttributeKey, Object>(defaultAttributes);
            attributes.put(attributeKey, null);
            action = new AttributeAction(editor, attributes, BUNDLE.getString("buttonFactory.action_noColor.name"), new ColorIcon(null, "", DEFAULT_COLOR_ICONS.get(0).getIconWidth(), DEFAULT_COLOR_ICONS.get(0).getIconHeight()));
            popupButton.add((Action)((Object)action));
            action.putValue("ShortDescription", BUNDLE.getString("buttonFactory.action_noColor.shortDescription"));
            action.setUpdateEnabledState(false);
        }
        ImageIcon chooserIcon = new ImageIcon(Images.createImage(ButtonFactory.class, (String)"/org/jhotdraw/draw/action/images/attribute.color.colorChooser.png"));
        action = new EditorColorChooserAction(editor, attributeKey, "color", chooserIcon, defaultAttributes);
        popupButton.add((Action)((Object)action));
        popupButton.setText(null);
        popupButton.setToolTipText(toolTipText);
        EditorColorIcon icon = new EditorColorIcon(editor, attributeKey, baseIcon.getImage(), (Shape)new Rectangle(1, 17, 20, 4));
        popupButton.setIcon((Icon)icon);
        popupButton.setDisabledIcon((Icon)icon);
        popupButton.setFocusable(false);
        editor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                popupButton.repaint();
            }
        });
        return popupButton;
    }

    private static void addStrokeButtonsTo(JToolBar bar, DrawingEditor editor) {
        bar.add((Component)ButtonFactory.createStrokeDecorationButton(editor));
        bar.add((Component)ButtonFactory.createStrokeWidthButton(editor));
        bar.add((Component)ButtonFactory.createStrokeDashesButton(editor));
        bar.add((Component)ButtonFactory.createStrokeTypeButton(editor));
        bar.add((Component)ButtonFactory.createStrokePlacementButton(editor));
        bar.add((Component)ButtonFactory.createStrokeCapButton(editor));
        bar.add((Component)ButtonFactory.createStrokeJoinButton(editor));
    }

    private static JPopupButton createStrokeDecorationButton(DrawingEditor editor) {
        LineDecoration[] decorations;
        JPopupButton strokeDecorationPopupButton = new JPopupButton();
        strokeDecorationPopupButton.setIcon((Icon)ImageDirectory.getImageIcon((String)"/toolbar/attributeStrokeDecoration.png"));
        strokeDecorationPopupButton.setText(null);
        strokeDecorationPopupButton.setToolTipText(BUNDLE.getString("buttonFactory.button_strokeDecoration.tooltipText"));
        strokeDecorationPopupButton.setFocusable(false);
        strokeDecorationPopupButton.setColumnCount(2, false);
        for (LineDecoration decoration : decorations = new LineDecoration[]{new ArrowTip(0.35, 12.0, 11.3), new ArrowTip(0.35, 13.0, 7.0), new ArrowTip(0.6283185307179586, 12.0, 9.8, true, true, false), new ArrowTip(0.5235987755982988, 12.0, 0.0, false, true, false), new ArrowTip(0.28559933214452665, 13.0, 0.0, false, true, true), new ArrowTip(0.5235987755982988, 10.0, 18.0, false, true, false), new ArrowTip(0.5235987755982988, 10.0, 18.0, true, true, true), null}) {
            strokeDecorationPopupButton.add((Action)((Object)new AttributeAction(editor, AttributeKeys.START_DECORATION, decoration, null, (Icon)new LineDecorationIcon(decoration, true))));
            strokeDecorationPopupButton.add((Action)((Object)new AttributeAction(editor, AttributeKeys.END_DECORATION, decoration, null, (Icon)new LineDecorationIcon(decoration, false))));
        }
        return strokeDecorationPopupButton;
    }

    private static JPopupButton createStrokeWidthButton(DrawingEditor editor) {
        JPopupButton strokeWidthPopupButton = new JPopupButton();
        strokeWidthPopupButton.setIcon((Icon)ImageDirectory.getImageIcon((String)"/toolbar/attributeStrokeWidth.png"));
        strokeWidthPopupButton.setText(null);
        strokeWidthPopupButton.setToolTipText(BUNDLE.getString("buttonFactory.button_strokeWidth.tooltipText"));
        strokeWidthPopupButton.setFocusable(false);
        NumberFormat formatter = NumberFormat.getInstance();
        if (formatter instanceof DecimalFormat) {
            ((DecimalFormat)formatter).setMaximumFractionDigits(1);
            ((DecimalFormat)formatter).setMinimumFractionDigits(0);
        }
        double[] widths = new double[]{0.5, 1.0, 2.0, 3.0, 5.0, 9.0, 13.0};
        for (int i = 0; i < widths.length; ++i) {
            String label = Double.toString(widths[i]);
            StrokeIcon icon = new StrokeIcon((Stroke)new BasicStroke((float)widths[i], 0, 2));
            AttributeAction action = new AttributeAction(editor, AttributeKeys.STROKE_WIDTH, widths[i], label, (Icon)icon);
            action.putValue("undoPresentationName", BUNDLE.getString("buttonFactory.action_strokeWidth.undo.presentationName"));
            AbstractButton btn = strokeWidthPopupButton.add((Action)((Object)action));
            btn.setDisabledIcon((Icon)icon);
        }
        return strokeWidthPopupButton;
    }

    private static JPopupButton createStrokeDashesButton(DrawingEditor editor) {
        double[][] dashes;
        JPopupButton strokeDashesPopupButton = new JPopupButton();
        strokeDashesPopupButton.setIcon((Icon)ImageDirectory.getImageIcon((String)"/toolbar/attributeStrokeDashes.png"));
        strokeDashesPopupButton.setText(null);
        strokeDashesPopupButton.setToolTipText(BUNDLE.getString("buttonFactory.button_strokeDashes.tooltipText"));
        strokeDashesPopupButton.setFocusable(false);
        for (double[] dash : dashes = new double[][]{null, {4.0, 4.0}, {2.0, 2.0}, {4.0, 2.0}, {2.0, 4.0}, {8.0, 2.0}, {6.0, 2.0, 2.0, 2.0}}) {
            float[] fdashes;
            if (dash == null) {
                fdashes = null;
            } else {
                fdashes = new float[dash.length];
                for (int j = 0; j < dash.length; ++j) {
                    fdashes[j] = (float)dash[j];
                }
            }
            StrokeIcon icon = new StrokeIcon((Stroke)new BasicStroke(2.0f, 0, 2, 10.0f, fdashes, 0.0f));
            AbstractButton button = strokeDashesPopupButton.add((Action)((Object)new AttributeAction(editor, AttributeKeys.STROKE_DASHES, dash, null, (Icon)icon)));
            button.setDisabledIcon((Icon)icon);
        }
        return strokeDashesPopupButton;
    }

    private static JPopupButton createStrokeTypeButton(DrawingEditor editor) {
        JPopupButton strokeTypePopupButton = new JPopupButton();
        strokeTypePopupButton.setIcon((Icon)ImageDirectory.getImageIcon((String)"/toolbar/attributeStrokeType.png"));
        strokeTypePopupButton.setText(null);
        strokeTypePopupButton.setToolTipText(BUNDLE.getString("buttonFactory.button_strokeType.tooltipText"));
        strokeTypePopupButton.setFocusable(false);
        strokeTypePopupButton.add((Action)((Object)new AttributeAction(editor, AttributeKeys.STROKE_TYPE, AttributeKeys.StrokeType.BASIC, BUNDLE.getString("buttonFactory.action_strokeTypeBasic.name"), (Icon)new StrokeIcon((Stroke)new BasicStroke(1.0f, 0, 2)))));
        HashMap<Object, Object> attributes = new HashMap<AttributeKey, Object>();
        attributes.put(AttributeKeys.STROKE_TYPE, AttributeKeys.StrokeType.DOUBLE);
        attributes.put(AttributeKeys.STROKE_INNER_WIDTH_FACTOR, 2.0);
        strokeTypePopupButton.add((Action)((Object)new AttributeAction(editor, attributes, BUNDLE.getString("buttonFactory.action_strokeTypeDouble.name"), (Icon)new StrokeIcon((Stroke)new DoubleStroke(2.0, 1.0)))));
        attributes = new HashMap();
        attributes.put(AttributeKeys.STROKE_TYPE, AttributeKeys.StrokeType.DOUBLE);
        attributes.put(AttributeKeys.STROKE_INNER_WIDTH_FACTOR, 3.0);
        strokeTypePopupButton.add((Action)((Object)new AttributeAction(editor, attributes, BUNDLE.getString("buttonFactory.action_strokeTypeDouble.name"), (Icon)new StrokeIcon((Stroke)new DoubleStroke(3.0, 1.0)))));
        attributes = new HashMap();
        attributes.put(AttributeKeys.STROKE_TYPE, AttributeKeys.StrokeType.DOUBLE);
        attributes.put(AttributeKeys.STROKE_INNER_WIDTH_FACTOR, 4.0);
        strokeTypePopupButton.add((Action)((Object)new AttributeAction(editor, attributes, BUNDLE.getString("buttonFactory.action_strokeTypeDouble.name"), (Icon)new StrokeIcon((Stroke)new DoubleStroke(4.0, 1.0)))));
        return strokeTypePopupButton;
    }

    private static JPopupButton createStrokePlacementButton(DrawingEditor editor) {
        JPopupButton strokePlacementPopupButton = new JPopupButton();
        strokePlacementPopupButton.setIcon((Icon)ImageDirectory.getImageIcon((String)"/toolbar/attributeStrokePlacement.png"));
        strokePlacementPopupButton.setText(null);
        strokePlacementPopupButton.setToolTipText(BUNDLE.getString("buttonFactory.button_strokePlacement.tooltipText"));
        strokePlacementPopupButton.setFocusable(false);
        HashMap<Object, Object> attributes = new HashMap<AttributeKey, Object>();
        attributes.put(AttributeKeys.STROKE_PLACEMENT, AttributeKeys.StrokePlacement.CENTER);
        attributes.put(AttributeKeys.FILL_UNDER_STROKE, AttributeKeys.Underfill.CENTER);
        strokePlacementPopupButton.add((Action)((Object)new AttributeAction(editor, attributes, BUNDLE.getString("buttonFactory.action_strokePlacementCenter.name"), null)));
        attributes = new HashMap();
        attributes.put(AttributeKeys.STROKE_PLACEMENT, AttributeKeys.StrokePlacement.INSIDE);
        attributes.put(AttributeKeys.FILL_UNDER_STROKE, AttributeKeys.Underfill.CENTER);
        strokePlacementPopupButton.add((Action)((Object)new AttributeAction(editor, attributes, BUNDLE.getString("buttonFactory.action_strokePlacementInside.name"), null)));
        attributes = new HashMap();
        attributes.put(AttributeKeys.STROKE_PLACEMENT, AttributeKeys.StrokePlacement.OUTSIDE);
        attributes.put(AttributeKeys.FILL_UNDER_STROKE, AttributeKeys.Underfill.CENTER);
        strokePlacementPopupButton.add((Action)((Object)new AttributeAction(editor, attributes, BUNDLE.getString("buttonFactory.action_strokePlacementOutside.name"), null)));
        attributes = new HashMap();
        attributes.put(AttributeKeys.STROKE_PLACEMENT, AttributeKeys.StrokePlacement.CENTER);
        attributes.put(AttributeKeys.FILL_UNDER_STROKE, AttributeKeys.Underfill.FULL);
        strokePlacementPopupButton.add((Action)((Object)new AttributeAction(editor, attributes, BUNDLE.getString("buttonFactory.action_strokePlacementCenterFilled.name"), null)));
        attributes = new HashMap();
        attributes.put(AttributeKeys.STROKE_PLACEMENT, AttributeKeys.StrokePlacement.INSIDE);
        attributes.put(AttributeKeys.FILL_UNDER_STROKE, AttributeKeys.Underfill.FULL);
        strokePlacementPopupButton.add((Action)((Object)new AttributeAction(editor, attributes, BUNDLE.getString("buttonFactory.action_strokePlacementInsideFilled.name"), null)));
        attributes = new HashMap();
        attributes.put(AttributeKeys.STROKE_PLACEMENT, AttributeKeys.StrokePlacement.OUTSIDE);
        attributes.put(AttributeKeys.FILL_UNDER_STROKE, AttributeKeys.Underfill.FULL);
        strokePlacementPopupButton.add((Action)((Object)new AttributeAction(editor, attributes, BUNDLE.getString("buttonFactory.action_strokePlacementOutsideFilled.name"), null)));
        attributes = new HashMap();
        attributes.put(AttributeKeys.STROKE_PLACEMENT, AttributeKeys.StrokePlacement.CENTER);
        attributes.put(AttributeKeys.FILL_UNDER_STROKE, AttributeKeys.Underfill.NONE);
        strokePlacementPopupButton.add((Action)((Object)new AttributeAction(editor, attributes, BUNDLE.getString("buttonFactory.action_strokePlacementCenterUnfilled.name"), null)));
        attributes = new HashMap();
        attributes.put(AttributeKeys.STROKE_PLACEMENT, AttributeKeys.StrokePlacement.INSIDE);
        attributes.put(AttributeKeys.FILL_UNDER_STROKE, AttributeKeys.Underfill.NONE);
        strokePlacementPopupButton.add((Action)((Object)new AttributeAction(editor, attributes, BUNDLE.getString("buttonFactory.action_strokePlacementInsideUnfilled.name"), null)));
        attributes = new HashMap();
        attributes.put(AttributeKeys.STROKE_PLACEMENT, AttributeKeys.StrokePlacement.OUTSIDE);
        attributes.put(AttributeKeys.FILL_UNDER_STROKE, AttributeKeys.Underfill.NONE);
        strokePlacementPopupButton.add((Action)((Object)new AttributeAction(editor, attributes, BUNDLE.getString("buttonFactory.action_strokePlacementOutsideUnfilled.name"), null)));
        return strokePlacementPopupButton;
    }

    private static JPopupButton createStrokeCapButton(DrawingEditor editor) {
        JPopupButton popupButton = new JPopupButton();
        popupButton.setIcon((Icon)ImageDirectory.getImageIcon((String)"/toolbar/attributeStrokeCap.png"));
        popupButton.setText(null);
        popupButton.setToolTipText(BUNDLE.getString("buttonFactory.button_strokeCap.tooltipText"));
        popupButton.setFocusable(false);
        LinkedList<AttributeAction> dsp = new LinkedList<AttributeAction>();
        HashMap<Object, Object> attributes = new HashMap<AttributeKey, Object>();
        attributes.put(AttributeKeys.STROKE_CAP, 0);
        AttributeAction action = new AttributeAction(editor, attributes, BUNDLE.getString("buttonFactory.action_strokeCapButt.name"), null);
        popupButton.add((Action)((Object)action));
        dsp.add(action);
        attributes = new HashMap();
        attributes.put(AttributeKeys.STROKE_CAP, 1);
        action = new AttributeAction(editor, attributes, BUNDLE.getString("buttonFactory.action_strokeCapRound.name"), null);
        popupButton.add((Action)((Object)action));
        dsp.add(action);
        attributes = new HashMap();
        attributes.put(AttributeKeys.STROKE_CAP, 2);
        action = new AttributeAction(editor, attributes, BUNDLE.getString("buttonFactory.action_strokeCapSquare.name"), null);
        popupButton.add((Action)((Object)action));
        dsp.add(action);
        return popupButton;
    }

    private static JPopupButton createStrokeJoinButton(DrawingEditor editor) {
        JPopupButton popupButton = new JPopupButton();
        popupButton.setIcon((Icon)ImageDirectory.getImageIcon((String)"/toolbar/attributeStrokeJoin.png"));
        popupButton.setText(null);
        popupButton.setToolTipText(BUNDLE.getString("buttonFactory.button_strokeJoin.tooltipText"));
        popupButton.setFocusable(false);
        LinkedList<AttributeAction> dsp = new LinkedList<AttributeAction>();
        HashMap<Object, Object> attributes = new HashMap<AttributeKey, Object>();
        attributes.put(AttributeKeys.STROKE_JOIN, 2);
        AttributeAction action = new AttributeAction(editor, attributes, BUNDLE.getString("buttonFactory.action_strokeJoinBevel.name"), null);
        popupButton.add((Action)((Object)action));
        dsp.add(action);
        attributes = new HashMap();
        attributes.put(AttributeKeys.STROKE_JOIN, 1);
        action = new AttributeAction(editor, attributes, BUNDLE.getString("buttonFactory.action_strokeJoinRound.name"), null);
        popupButton.add((Action)((Object)action));
        dsp.add(action);
        attributes = new HashMap();
        attributes.put(AttributeKeys.STROKE_JOIN, 0);
        action = new AttributeAction(editor, attributes, BUNDLE.getString("buttonFactory.action_strokeJoinMiter.name"), null);
        popupButton.add((Action)((Object)action));
        dsp.add(action);
        return popupButton;
    }

    private static void addFontButtonsTo(JToolBar bar, DrawingEditor editor) {
        bar.add((Component)ButtonFactory.createFontButton(editor));
        bar.add(ButtonFactory.createFontStyleBoldButton(editor));
        bar.add(ButtonFactory.createFontStyleItalicButton(editor));
        bar.add(ButtonFactory.createFontStyleUnderlineButton(editor));
    }

    private static JPopupButton createFontButton(DrawingEditor editor) {
        JPopupButton fontPopupButton = new JPopupButton();
        fontPopupButton.setIcon((Icon)ImageDirectory.getImageIcon((String)"/toolbar/attributeFont.png"));
        fontPopupButton.setText(null);
        fontPopupButton.setToolTipText(BUNDLE.getString("buttonFactory.button_font.tooltipText"));
        fontPopupButton.setFocusable(false);
        JComponentPopup popupMenu = new JComponentPopup();
        JFontChooser fontChooser = new JFontChooser();
        new LinkedList<FontChooserHandler>().add(new FontChooserHandler(editor, AttributeKeys.FONT_FACE, fontChooser, (JPopupMenu)popupMenu));
        popupMenu.add((Component)fontChooser);
        fontPopupButton.setPopupMenu((JPopupMenu)popupMenu);
        fontPopupButton.setFocusable(false);
        return fontPopupButton;
    }

    private static JButton createFontStyleBoldButton(DrawingEditor editor) {
        JButton button = new JButton();
        button.setIcon(ImageDirectory.getImageIcon((String)"/toolbar/attributeFontBold.png"));
        button.setText(null);
        button.setToolTipText(BUNDLE.getString("buttonFactory.button_fontStyleBold.tooltipText"));
        button.setFocusable(false);
        AttributeToggler action = new AttributeToggler(editor, AttributeKeys.FONT_BOLD, (Object)Boolean.TRUE, (Object)Boolean.FALSE, (Action)new StyledEditorKit.BoldAction());
        action.putValue("undoPresentationName", BUNDLE.getString("buttonFactory.action_fontStyleBold.undo.presentationName"));
        button.addActionListener((ActionListener)action);
        return button;
    }

    private static JButton createFontStyleItalicButton(DrawingEditor editor) {
        JButton button = new JButton();
        button.setIcon(ImageDirectory.getImageIcon((String)"/toolbar/attributeFontItalic.png"));
        button.setText(null);
        button.setToolTipText(BUNDLE.getString("buttonFactory.button_fontStyleItalic.tooltipText"));
        button.setFocusable(false);
        AttributeToggler action = new AttributeToggler(editor, AttributeKeys.FONT_ITALIC, (Object)Boolean.TRUE, (Object)Boolean.FALSE, (Action)new StyledEditorKit.BoldAction());
        action.putValue("undoPresentationName", BUNDLE.getString("buttonFactory.action_fontStyleItalic.undo.presentationName"));
        button.addActionListener((ActionListener)action);
        return button;
    }

    private static JButton createFontStyleUnderlineButton(DrawingEditor editor) {
        JButton button = new JButton();
        button.setIcon(ImageDirectory.getImageIcon((String)"/toolbar/attributeFontUnderline.png"));
        button.setText(null);
        button.setToolTipText(BUNDLE.getString("buttonFactory.button_fontStyleUnderline.tooltipText"));
        button.setFocusable(false);
        AttributeToggler action = new AttributeToggler(editor, AttributeKeys.FONT_UNDERLINE, (Object)Boolean.TRUE, (Object)Boolean.FALSE, (Action)new StyledEditorKit.BoldAction());
        action.putValue("undoPresentationName", BUNDLE.getString("buttonFactory.action_fontStyleUnderline.undo.presentationName"));
        button.addActionListener((ActionListener)action);
        return button;
    }

    public static void addAlignmentButtonsTo(JToolBar bar, DrawingEditor editor) {
        bar.add((Action)((Object)new AlignAction.West(editor))).setFocusable(false);
        bar.add((Action)((Object)new AlignAction.East(editor))).setFocusable(false);
        bar.add((Action)((Object)new AlignAction.Horizontal(editor))).setFocusable(false);
        bar.add((Action)((Object)new AlignAction.North(editor))).setFocusable(false);
        bar.add((Action)((Object)new AlignAction.South(editor))).setFocusable(false);
        bar.add((Action)((Object)new AlignAction.Vertical(editor))).setFocusable(false);
        bar.addSeparator();
        bar.add((Action)new MoveAction.West(editor)).setFocusable(false);
        bar.add((Action)new MoveAction.East(editor)).setFocusable(false);
        bar.add((Action)new MoveAction.North(editor)).setFocusable(false);
        bar.add((Action)new MoveAction.South(editor)).setFocusable(false);
        bar.addSeparator();
        bar.add((Action)((Object)new BringToFrontAction(editor))).setFocusable(false);
        bar.add((Action)((Object)new SendToBackAction(editor))).setFocusable(false);
    }

    static {
        BUNDLE = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.modeling.toolbar");
        LinkedList<ColorIcon> m = new LinkedList<ColorIcon>();
        m.add(new ColorIcon(0x800000, "Cayenne"));
        m.add(new ColorIcon(0x808000, "Asparagus"));
        m.add(new ColorIcon(32768, "Clover"));
        m.add(new ColorIcon(32896, "Teal"));
        m.add(new ColorIcon(128, "Midnight"));
        m.add(new ColorIcon(0x800080, "Plum"));
        m.add(new ColorIcon(0x7F7F7F, "Tin"));
        m.add(new ColorIcon(0x808080, "Nickel"));
        m.add(new ColorIcon(0xFF0000, "Maraschino"));
        m.add(new ColorIcon(0xFFFF00, "Lemon"));
        m.add(new ColorIcon(65280, "Spring"));
        m.add(new ColorIcon(65535, "Turquoise"));
        m.add(new ColorIcon(255, "Blueberry"));
        m.add(new ColorIcon(0xFF00FF, "Magenta"));
        m.add(new ColorIcon(0x666666, "Steel"));
        m.add(new ColorIcon(0x999999, "Aluminium"));
        m.add(new ColorIcon(0xFF6666, "Salmon"));
        m.add(new ColorIcon(0xFFFF66, "Banana"));
        m.add(new ColorIcon(0x66FF66, "Flora"));
        m.add(new ColorIcon(0x66FFFF, "Ice"));
        m.add(new ColorIcon(0x6666FF, "Orchid"));
        m.add(new ColorIcon(0xFF66FF, "Bubblegum"));
        m.add(new ColorIcon(0x4C4C4C, "Iron"));
        m.add(new ColorIcon(0xB3B3B3, "Magnesium"));
        m.add(new ColorIcon(0x804000, "Mocha"));
        m.add(new ColorIcon(0x408000, "Fern"));
        m.add(new ColorIcon(32832, "Moss"));
        m.add(new ColorIcon(16512, "Ocean"));
        m.add(new ColorIcon(0x400080, "Eggplant"));
        m.add(new ColorIcon(0x800040, "Maroon"));
        m.add(new ColorIcon(0x333333, "Tungsten"));
        m.add(new ColorIcon(0xCCCCCC, "Silver"));
        m.add(new ColorIcon(0xFF8000, "Tangerine"));
        m.add(new ColorIcon(0x80FF00, "Lime"));
        m.add(new ColorIcon(65408, "Sea Foam"));
        m.add(new ColorIcon(33023, "Aqua"));
        m.add(new ColorIcon(0x8000FF, "Grape"));
        m.add(new ColorIcon(0xFF0080, "Strawberry"));
        m.add(new ColorIcon(0x191919, "Lead"));
        m.add(new ColorIcon(0xE6E6E6, "Mercury"));
        m.add(new ColorIcon(0xFFCC66, "Cantaloupe"));
        m.add(new ColorIcon(0xCCFF66, "Honeydew"));
        m.add(new ColorIcon(0x66FFCC, "Spindrift"));
        m.add(new ColorIcon(0x66CCFF, "Sky"));
        m.add(new ColorIcon(0xCC66FF, "Lavender"));
        m.add(new ColorIcon(0xFF6FCF, "Carnation"));
        m.add(new ColorIcon(0, "Licorice"));
        m.add(new ColorIcon(0xFFFFFF, "Snow"));
        DEFAULT_COLOR_ICONS = Collections.unmodifiableList(m);
    }
}

