/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.thirdparty.modeleditor.jhotdraw.components.drawing;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.DefaultDrawingView;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.opentcs.guing.base.event.BlockChangeListener;
import org.opentcs.guing.base.model.ModelComponent;
import org.opentcs.guing.base.model.elements.BlockModel;
import org.opentcs.guing.base.model.elements.VehicleModel;
import org.opentcs.guing.common.application.ApplicationState;
import org.opentcs.guing.common.components.drawing.course.Origin;
import org.opentcs.guing.common.components.drawing.course.OriginChangeListener;
import org.opentcs.guing.common.components.drawing.figures.FigureConstants;
import org.opentcs.guing.common.components.drawing.figures.LabeledFigure;
import org.opentcs.guing.common.components.drawing.figures.ModelBasedFigure;
import org.opentcs.guing.common.components.drawing.figures.OriginFigure;
import org.opentcs.guing.common.persistence.ModelManager;
import org.opentcs.modeleditor.components.drawing.BlockChangeHandler;
import org.opentcs.modeleditor.components.drawing.DeleteEdit;
import org.opentcs.modeleditor.components.drawing.PasteEdit;
import org.opentcs.modeleditor.components.layer.ActiveLayerProvider;
import org.opentcs.modeleditor.util.FigureCloner;
import org.opentcs.thirdparty.guing.common.jhotdraw.components.drawing.AbstractOpenTCSDrawingView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTCSDrawingViewModeling
extends AbstractOpenTCSDrawingView {
    private static final Logger LOG = LoggerFactory.getLogger(OpenTCSDrawingViewModeling.class);
    private final FigureCloner figureCloner;
    private final ActiveLayerProvider activeLayerProvider;
    private List<Figure> bufferedFigures = new ArrayList<Figure>();
    private final BlockChangeHandler blockChangeHandler;

    @Inject
    public OpenTCSDrawingViewModeling(ApplicationState appState, ModelManager modelManager, FigureCloner figureCloner, ActiveLayerProvider activeLayerProvider, BlockChangeHandler blockChangeHandler) {
        super(appState, modelManager);
        this.figureCloner = Objects.requireNonNull(figureCloner, "figureCloner");
        this.activeLayerProvider = Objects.requireNonNull(activeLayerProvider, "activeLayerProvider");
        this.blockChangeHandler = Objects.requireNonNull(blockChangeHandler, "blockChangeHandler");
    }

    public void cutSelectedItems() {
        this.deleteSelectedFigures();
    }

    public void copySelectedItems() {
        this.bufferedFigures = this.getDrawing().sort((Collection)this.getSelectedFigures());
    }

    public void pasteBufferedItems() {
        this.clearSelection();
        ArrayList<Figure> pastedFigures = new ArrayList<Figure>();
        if (this.getDrawing().getChildren().containsAll(this.bufferedFigures)) {
            pastedFigures.addAll(this.copyPasteBufferedItems());
        } else if (Collections.disjoint(this.getDrawing().getChildren(), this.bufferedFigures)) {
            pastedFigures.addAll(this.cutPasteBufferedItems());
        } else {
            throw new IllegalStateException("Some figures to be pasted are already in the drawing, some are not.");
        }
        this.placeFiguresOnActiveLayer(pastedFigures);
    }

    public void delete() {
        this.deleteSelectedFigures();
        if (!this.bufferedFigures.isEmpty()) {
            this.getDrawing().fireUndoableEditHappened((UndoableEdit)new DeleteEdit((DrawingView)this, this.bufferedFigures));
        }
    }

    public void duplicate() {
        this.copySelectedItems();
        this.pasteBufferedItems();
    }

    public void displayDriveOrders(VehicleModel vehicle, boolean visible) {
    }

    public void followVehicle(@Nonnull VehicleModel model) {
    }

    public void stopFollowVehicle() {
    }

    protected void drawTool(Graphics2D g2d) {
        super.drawTool(g2d);
        if (this.getEditor() == null || this.getEditor().getTool() == null || this.getEditor().getActiveView() != this) {
            return;
        }
        this.highlightFocus(g2d);
    }

    protected DefaultDrawingView.EventHandler createEventHandler() {
        return new ExtendedEventHandler();
    }

    public void delete(Set<ModelComponent> components) {
        List<Figure> figuresToDelete = components.stream().map(component -> this.getModelManager().getModel().getFigure(component)).collect(Collectors.toList());
        this.deleteFigures(figuresToDelete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBlocks(ModelComponent blocks) {
        OpenTCSDrawingViewModeling openTCSDrawingViewModeling = this;
        synchronized (openTCSDrawingViewModeling) {
            for (ModelComponent blockComp : blocks.getChildComponents()) {
                BlockModel block = (BlockModel)blockComp;
                block.addBlockChangeListener((BlockChangeListener)this.blockChangeHandler);
            }
        }
    }

    public void blockAdded(BlockModel block) {
        block.addBlockChangeListener((BlockChangeListener)this.blockChangeHandler);
    }

    private List<Figure> copyPasteBufferedItems() {
        List<Figure> clonedFigures = this.figureCloner.cloneFigures(this.bufferedFigures);
        this.addToSelection(clonedFigures);
        this.getDrawing().fireUndoableEditHappened((UndoableEdit)new PasteEdit((DrawingView)this, clonedFigures));
        return clonedFigures;
    }

    private List<Figure> cutPasteBufferedItems() {
        for (Figure deletedFigure : this.bufferedFigures) {
            this.getDrawing().add(deletedFigure);
        }
        this.getDrawing().fireUndoableEditHappened((UndoableEdit)new PasteEdit((DrawingView)this, this.bufferedFigures));
        return this.bufferedFigures;
    }

    private void placeFiguresOnActiveLayer(List<Figure> figures) {
        for (Figure figure : figures) {
            if (figure instanceof ModelBasedFigure) {
                ((ModelBasedFigure)figure).getModel().getPropertyLayerWrapper().setValue((Object)this.activeLayerProvider.getActiveLayer());
                continue;
            }
            if (!(figure instanceof LabeledFigure)) continue;
            ((LabeledFigure)figure).getPresentationFigure().getModel().getPropertyLayerWrapper().setValue((Object)this.activeLayerProvider.getActiveLayer());
        }
    }

    private void deleteSelectedFigures() {
        List deletedFigures = this.getDrawing().sort((Collection)this.getSelectedFigures());
        this.deleteFigures(deletedFigures);
    }

    private void deleteFigures(List<Figure> figures) {
        for (Figure figure : figures) {
            if (figure.isRemovable()) continue;
            LOG.warn("Figure is not removable: {}. Aborting.", (Object)figure);
            return;
        }
        this.bufferedFigures = figures;
        this.clearSelection();
        for (Figure figure : figures) {
            Origin ref;
            if (figure instanceof OriginChangeListener && (ref = (Origin)figure.get(FigureConstants.ORIGIN)) != null) {
                ref.removeListener((OriginChangeListener)figure);
                figure.set(FigureConstants.ORIGIN, null);
            }
            this.getDrawing().remove(figure);
        }
    }

    private class ExtendedEventHandler
    extends AbstractOpenTCSDrawingView.AbstractExtendedEventHandler {
        ExtendedEventHandler() {
            super((AbstractOpenTCSDrawingView)OpenTCSDrawingViewModeling.this);
        }

        protected boolean shouldShowFigure(Figure figure) {
            return !(figure instanceof OriginFigure);
        }
    }
}

