/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.application;

import java.util.Objects;
import javax.inject.Inject;
import org.jhotdraw.app.Application;
import org.jhotdraw.app.View;
import org.opentcs.guing.application.OpenTCSView;
import org.opentcs.guing.application.ProgressIndicator;
import org.opentcs.guing.application.ProgressStatus;
import org.opentcs.guing.application.StartupProgressStatus;
import org.opentcs.guing.event.EventLogger;
import org.opentcs.guing.exchange.AttributeAdapterRegistry;
import org.opentcs.guing.exchange.KernelEventFetcher;
import org.opentcs.guing.exchange.OpenTCSEventDispatcher;
import org.opentcs.guing.peripherals.jobs.PeripheralJobsContainer;
import org.opentcs.guing.transport.orders.TransportOrdersContainer;
import org.opentcs.guing.transport.sequences.OrderSequencesContainer;

public class PlantOverviewStarter {
    private final ProgressIndicator progressIndicator;
    private final Application application;
    private final OpenTCSView opentcsView;
    private final EventLogger eventLogger;
    private final KernelEventFetcher kernelEventFetcher;
    private final OpenTCSEventDispatcher eventDispatcher;
    private final AttributeAdapterRegistry attributeAdapterRegistry;
    private final TransportOrdersContainer transportOrdersContainer;
    private final PeripheralJobsContainer peripheralJobsContainer;
    private final OrderSequencesContainer orderSequencesContainer;

    @Inject
    public PlantOverviewStarter(ProgressIndicator progressIndicator, Application application, OpenTCSView opentcsView, EventLogger eventLogger, KernelEventFetcher kernelEventFetcher, OpenTCSEventDispatcher eventDispatcher, AttributeAdapterRegistry attributeAdapterRegistry, TransportOrdersContainer transportOrdersContainer, PeripheralJobsContainer peripheralJobsContainer, OrderSequencesContainer orderSequencesContainer) {
        this.progressIndicator = Objects.requireNonNull(progressIndicator, "progressIndicator");
        this.application = Objects.requireNonNull(application, "application");
        this.opentcsView = Objects.requireNonNull(opentcsView, "opentcsView");
        this.eventLogger = Objects.requireNonNull(eventLogger, "eventLogger");
        this.kernelEventFetcher = Objects.requireNonNull(kernelEventFetcher, "kernelEventFetcher");
        this.eventDispatcher = Objects.requireNonNull(eventDispatcher, "eventDispatcher");
        this.attributeAdapterRegistry = Objects.requireNonNull(attributeAdapterRegistry, "attributeAdapterRegistry");
        this.transportOrdersContainer = Objects.requireNonNull(transportOrdersContainer, "transportOrdersContainer");
        this.peripheralJobsContainer = Objects.requireNonNull(peripheralJobsContainer, "peripheralJobsContainer");
        this.orderSequencesContainer = Objects.requireNonNull(orderSequencesContainer, "orderSequencesContainer");
    }

    public void startPlantOverview() {
        this.eventLogger.initialize();
        this.kernelEventFetcher.initialize();
        this.eventDispatcher.initialize();
        this.attributeAdapterRegistry.initialize();
        this.transportOrdersContainer.initialize();
        this.peripheralJobsContainer.initialize();
        this.orderSequencesContainer.initialize();
        this.opentcsView.init();
        this.progressIndicator.initialize();
        this.progressIndicator.setProgress((ProgressStatus)StartupProgressStatus.START_PLANT_OVERVIEW);
        this.progressIndicator.setProgress((ProgressStatus)StartupProgressStatus.SHOW_PLANT_OVERVIEW);
        this.opentcsView.setApplication(this.application);
        this.application.show((View)this.opentcsView);
        this.progressIndicator.terminate();
    }
}

