/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.application.action;

import java.awt.event.ItemListener;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.event.ToolAdapter;
import org.jhotdraw.draw.event.ToolEvent;
import org.jhotdraw.draw.event.ToolListener;
import org.jhotdraw.draw.tool.Tool;
import org.opentcs.guing.application.action.ToolButtonListener;
import org.opentcs.guing.application.action.ViewActionMap;
import org.opentcs.guing.application.toolbar.DragTool;
import org.opentcs.guing.application.toolbar.MultipleSelectionTool;
import org.opentcs.guing.application.toolbar.SelectionToolFactory;
import org.opentcs.guing.components.drawing.OpenTCSDrawingEditor;
import org.opentcs.guing.event.ResetInteractionToolCommand;
import org.opentcs.guing.util.CourseObjectFactory;
import org.opentcs.guing.util.ImageDirectory;
import org.opentcs.thirdparty.jhotdraw.application.action.draw.SelectSameAction;
import org.opentcs.thirdparty.jhotdraw.util.ResourceBundleUtil;
import org.opentcs.util.event.EventHandler;

public class ToolBarManager
implements EventHandler {
    private final SelectionToolFactory selectionToolFactory;
    private final List<JToolBar> toolBarList = Collections.synchronizedList(new LinkedList());
    private final JToolBar toolBarCreation = new JToolBar();
    private final JToggleButton selectionToolButton;
    private final JToggleButton dragToolButton;
    private DragTool dragTool;
    private final JButton buttonCreateOrder;
    private final JButton buttonFindVehicle;
    private final JButton buttonPauseAllVehicles;
    private final JButton buttonResumeAllVehicles;

    @Inject
    public ToolBarManager(ViewActionMap actionMap, CourseObjectFactory crsObjFactory, OpenTCSDrawingEditor editor, SelectionToolFactory selectionToolFactory) {
        Objects.requireNonNull(actionMap, "actionMap");
        Objects.requireNonNull(crsObjFactory, "crsObjFactory");
        Objects.requireNonNull(editor, "editor");
        this.selectionToolFactory = Objects.requireNonNull(selectionToolFactory, "selectionToolFactory");
        ResourceBundleUtil labels = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.toolbar");
        this.toolBarCreation.setActionMap(actionMap);
        this.selectionToolButton = this.addSelectionToolButton(this.toolBarCreation, (DrawingEditor)editor);
        this.dragToolButton = this.addDragToolButton(this.toolBarCreation, (DrawingEditor)editor);
        this.toolBarCreation.addSeparator();
        this.buttonCreateOrder = new JButton(actionMap.get("actions.createTransportOrder"));
        this.buttonCreateOrder.setText(null);
        this.toolBarCreation.add(this.buttonCreateOrder);
        this.toolBarCreation.addSeparator();
        this.buttonFindVehicle = new JButton(actionMap.get("actions.findVehicle"));
        this.buttonFindVehicle.setText(null);
        this.toolBarCreation.add(this.buttonFindVehicle);
        this.toolBarCreation.addSeparator();
        this.buttonPauseAllVehicles = new JButton(actionMap.get("openTCS.pauseAllVehicles"));
        this.buttonPauseAllVehicles.setText(null);
        this.toolBarCreation.add(this.buttonPauseAllVehicles);
        this.buttonResumeAllVehicles = new JButton(actionMap.get("openTCS.resumeAllVehicles"));
        this.buttonResumeAllVehicles.setText(null);
        this.toolBarCreation.add(this.buttonResumeAllVehicles);
        this.toolBarCreation.setName(labels.getString("toolBarManager.toolbar_drawing.title"));
        this.toolBarList.add(this.toolBarCreation);
    }

    public List<JToolBar> getToolBars() {
        return this.toolBarList;
    }

    public JToolBar getToolBarCreation() {
        return this.toolBarCreation;
    }

    public JToggleButton getSelectionToolButton() {
        return this.selectionToolButton;
    }

    public JToggleButton getDragToolButton() {
        return this.dragToolButton;
    }

    public void onEvent(Object event) {
        if (event instanceof ResetInteractionToolCommand) {
            this.handleToolReset((ResetInteractionToolCommand)event);
        }
    }

    private void handleToolReset(ResetInteractionToolCommand evt) {
        this.selectionToolButton.setSelected(true);
    }

    private JToggleButton addSelectionToolButton(JToolBar toolBar, DrawingEditor editor) {
        ButtonGroup buttonGroup;
        LinkedList<Action> drawingActions = new LinkedList<Action>();
        drawingActions.add((Action)new SelectSameAction(editor));
        MultipleSelectionTool selectionTool = this.selectionToolFactory.createMultipleSelectionTool(drawingActions, new LinkedList<Action>());
        if (toolBar.getClientProperty("toolButtonGroup") instanceof ButtonGroup) {
            buttonGroup = (ButtonGroup)toolBar.getClientProperty("toolButtonGroup");
        } else {
            buttonGroup = new ButtonGroup();
            toolBar.putClientProperty("toolButtonGroup", buttonGroup);
        }
        editor.setTool((Tool)selectionTool);
        final JToggleButton toggleButton = new JToggleButton();
        if (!(toolBar.getClientProperty("toolHandler") instanceof ToolListener)) {
            ToolAdapter toolHandler = new ToolAdapter(){

                public void toolDone(ToolEvent event) {
                    toggleButton.setSelected(true);
                }
            };
            toolBar.putClientProperty("toolHandler", toolHandler);
        }
        toggleButton.setIcon(ImageDirectory.getImageIcon((String)"/toolbar/select-2.png"));
        toggleButton.setText(null);
        toggleButton.setToolTipText(ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.toolbar").getString("toolBarManager.button_selectionTool.tooltipText"));
        toggleButton.setSelected(true);
        toggleButton.addItemListener((ItemListener)new ToolButtonListener((Tool)selectionTool, editor));
        buttonGroup.add(toggleButton);
        toolBar.add(toggleButton);
        return toggleButton;
    }

    private JToggleButton addDragToolButton(JToolBar toolBar, DrawingEditor editor) {
        final JToggleButton button = new JToggleButton();
        this.dragTool = new DragTool();
        editor.setTool((Tool)this.dragTool);
        if (!(toolBar.getClientProperty("toolHandler") instanceof ToolListener)) {
            ToolAdapter toolHandler = new ToolAdapter(){

                public void toolDone(ToolEvent event) {
                    button.setSelected(true);
                }
            };
            toolBar.putClientProperty("toolHandler", toolHandler);
        }
        URL url = this.getClass().getResource("/org/opentcs/guing/res/symbols/toolbar/cursor-opened-hand.png");
        button.setIcon(new ImageIcon(url));
        button.setText(null);
        button.setToolTipText(ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.toolbar").getString("toolBarManager.button_dragTool.tooltipText"));
        button.setSelected(false);
        button.addItemListener((ItemListener)new ToolButtonListener((Tool)this.dragTool, editor));
        ButtonGroup group = (ButtonGroup)toolBar.getClientProperty("toolButtonGroup");
        group.add(button);
        toolBar.add(button);
        return button;
    }
}

