/*
 * Decompiled with CFR 0.152.
 */
package org.opentcs.guing.application.action.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.AbstractAction;
import org.opentcs.access.KernelRuntimeException;
import org.opentcs.access.SharedKernelServicePortal;
import org.opentcs.access.SharedKernelServicePortalProvider;
import org.opentcs.access.to.peripherals.PeripheralJobCreationTO;
import org.opentcs.customizations.plantoverview.ApplicationFrame;
import org.opentcs.guing.components.dialogs.DialogContent;
import org.opentcs.guing.components.dialogs.StandardContentDialog;
import org.opentcs.guing.transport.CreatePeripheralJobPanel;
import org.opentcs.thirdparty.jhotdraw.util.ResourceBundleUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreatePeripheralJobAction
extends AbstractAction {
    private static final Logger LOG = LoggerFactory.getLogger(CreatePeripheralJobAction.class);
    public static final String ID = "actions.createPeripheralJob";
    private static final ResourceBundleUtil BUNDLE = ResourceBundleUtil.getBundle((String)"i18n.org.opentcs.plantoverview.operating.mainMenu");
    private final Component dialogParent;
    private final Provider<CreatePeripheralJobPanel> jobPanelProvider;
    private final SharedKernelServicePortalProvider portalProvider;

    @Inject
    public CreatePeripheralJobAction(@ApplicationFrame Component dialogParent, Provider<CreatePeripheralJobPanel> peripheralJobPanel, SharedKernelServicePortalProvider portalProvider) {
        this.dialogParent = Objects.requireNonNull(dialogParent, "dialogParent");
        this.jobPanelProvider = Objects.requireNonNull(peripheralJobPanel, "peripheralJobPanel");
        this.portalProvider = Objects.requireNonNull(portalProvider, "portalProvider");
        this.putValue("Name", BUNDLE.getString("createPeripheralJobAction.name"));
        this.putValue("MnemonicKey", 80);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        CreatePeripheralJobPanel contentPanel = (CreatePeripheralJobPanel)((Object)this.jobPanelProvider.get());
        StandardContentDialog dialog = new StandardContentDialog(this.dialogParent, (DialogContent)contentPanel);
        dialog.setVisible(true);
        if (dialog.getReturnStatus() != 1) {
            return;
        }
        PeripheralJobCreationTO job = new PeripheralJobCreationTO("Job-", contentPanel.getReservationToken(), contentPanel.getPeripheralOperation()).withIncompleteName(true);
        try (SharedKernelServicePortal sharedPortal = this.portalProvider.register();){
            sharedPortal.getPortal().getPeripheralJobService().createPeripheralJob(job);
            sharedPortal.getPortal().getPeripheralDispatcherService().dispatch();
        }
        catch (KernelRuntimeException exception) {
            LOG.warn("Unexpected exception", (Throwable)exception);
        }
    }
}

